/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.python.jsr223;

import java.io.Reader;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import javax.script.Bindings;
import javax.script.ScriptContext;
import javax.script.ScriptException;
import javax.script.SimpleBindings;
import org.apache.tinkerpop.gremlin.jsr223.CoreGremlinPlugin;
import org.apache.tinkerpop.gremlin.jsr223.Customizer;
import org.apache.tinkerpop.gremlin.jsr223.GremlinScriptEngine;
import org.apache.tinkerpop.gremlin.jsr223.GremlinScriptEngineFactory;
import org.apache.tinkerpop.gremlin.jsr223.ImportCustomizer;
import org.apache.tinkerpop.gremlin.process.traversal.Bytecode;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.TraversalSource;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.GraphTraversal;
import org.apache.tinkerpop.gremlin.python.jsr223.GremlinJythonScriptEngineFactory;
import org.apache.tinkerpop.gremlin.python.jsr223.JythonTranslator;
import org.apache.tinkerpop.gremlin.python.jsr223.SymbolHelper;
import org.python.jsr223.PyScriptEngine;
import org.python.jsr223.PyScriptEngineFactory;

public class GremlinJythonScriptEngine
implements GremlinScriptEngine {
    private final PyScriptEngine pyScriptEngine = (PyScriptEngine)new PyScriptEngineFactory().getScriptEngine();

    public GremlinJythonScriptEngine(Customizer ... customizers) {
        ArrayList<Customizer> listOfCustomizers = new ArrayList<Customizer>(Arrays.asList(customizers));
        CoreGremlinPlugin.instance().getCustomizers("gremlin-jython").ifPresent(c -> listOfCustomizers.addAll(Arrays.asList(c)));
        List importCustomizers = listOfCustomizers.stream().filter(p -> p instanceof ImportCustomizer).map(p -> (ImportCustomizer)p).collect(Collectors.toList());
        try {
            for (ImportCustomizer ic : importCustomizers) {
                for (Class c2 : ic.getClassImports()) {
                    if (null == c2.getDeclaringClass()) {
                        this.pyScriptEngine.eval("from " + c2.getPackage().getName() + " import " + c2.getSimpleName());
                        continue;
                    }
                    this.pyScriptEngine.eval("from " + c2.getPackage().getName() + "." + c2.getDeclaringClass().getSimpleName() + " import " + c2.getSimpleName());
                }
                for (Method m : ic.getMethodImports()) {
                    this.pyScriptEngine.eval(SymbolHelper.toPython(m.getName()) + " = " + m.getDeclaringClass().getSimpleName() + "." + m.getName());
                }
                for (Enum e : ic.getEnumImports()) {
                    this.pyScriptEngine.eval(SymbolHelper.toPython(e.name()) + " = " + e.getDeclaringClass().getSimpleName() + "." + e.name());
                }
            }
            this.loadSugar();
        }
        catch (Exception ex) {
            throw new IllegalStateException(ex);
        }
    }

    public Traversal.Admin eval(Bytecode bytecode, Bindings bindings, String traversalSource) throws ScriptException {
        if (traversalSource.equals("gremlinscriptengine__g")) {
            throw new IllegalArgumentException("The traversalSource cannot have the name gremlinscriptengine__g - it is reserved");
        }
        if (!bindings.containsKey(traversalSource)) {
            throw new IllegalArgumentException("The bindings available to the ScriptEngine do not contain a traversalSource named: " + traversalSource);
        }
        Object b = bindings.get(traversalSource);
        if (!(b instanceof TraversalSource)) {
            throw new IllegalArgumentException(traversalSource + " is of type " + b.getClass().getSimpleName() + " and is not an instance of TraversalSource");
        }
        SimpleBindings inner = new SimpleBindings();
        inner.putAll(bindings);
        inner.putAll(bytecode.getBindings());
        inner.put("gremlinscriptengine__g", b);
        return (Traversal.Admin)this.eval(JythonTranslator.of("gremlinscriptengine__g").translate(bytecode), (Bindings)inner);
    }

    public Object eval(String script, ScriptContext context) throws ScriptException {
        return this.pyScriptEngine.eval(script, context);
    }

    public Object eval(Reader reader, ScriptContext context) throws ScriptException {
        return this.pyScriptEngine.eval(reader, context);
    }

    public Object eval(String script) throws ScriptException {
        return this.pyScriptEngine.eval(script);
    }

    public Object eval(Reader reader) throws ScriptException {
        return this.pyScriptEngine.eval(reader);
    }

    public Object eval(String script, Bindings n) throws ScriptException {
        this.pyScriptEngine.getBindings(100).putAll(n);
        return this.pyScriptEngine.eval(script);
    }

    public Object eval(Reader reader, Bindings n) throws ScriptException {
        this.pyScriptEngine.getBindings(100).putAll(n);
        return this.pyScriptEngine.eval(reader);
    }

    public void put(String key, Object value) {
        this.pyScriptEngine.put(key, value);
    }

    public Object get(String key) {
        return this.pyScriptEngine.get(key);
    }

    public Bindings getBindings(int scope) {
        return this.pyScriptEngine.getBindings(scope);
    }

    public void setBindings(Bindings bindings, int scope) {
        this.pyScriptEngine.setBindings(bindings, scope);
    }

    public Bindings createBindings() {
        return this.pyScriptEngine.createBindings();
    }

    public ScriptContext getContext() {
        return this.pyScriptEngine.getContext();
    }

    public void setContext(ScriptContext context) {
        this.pyScriptEngine.setContext(context);
    }

    public GremlinScriptEngineFactory getFactory() {
        return new GremlinJythonScriptEngineFactory();
    }

    private void loadSugar() throws ScriptException {
        this.pyScriptEngine.eval("def getitem_bypass(self, index):\n  if isinstance(index,int):\n    return self.range(index,index+1)\n  elif isinstance(index,slice):\n    return self.range(index.start,index.stop)\n  else:\n    return TypeError('Index must be int or slice')");
        this.pyScriptEngine.eval(GraphTraversal.class.getSimpleName() + ".__getitem__ = getitem_bypass");
        this.pyScriptEngine.eval(GraphTraversal.class.getSimpleName() + ".__getattr__ = lambda self, key: self.values(key)\n");
        this.pyScriptEngine.eval("\nfrom java.lang import Long\nimport org.apache.tinkerpop.gremlin.util.function.Lambda\nfrom org.apache.tinkerpop.gremlin.util.function.Lambda import AbstractLambda\nfrom org.apache.tinkerpop.gremlin.util.function.Lambda import UnknownArgLambda\nfrom org.apache.tinkerpop.gremlin.util.function.Lambda import ZeroArgLambda\nfrom org.apache.tinkerpop.gremlin.util.function.Lambda import OneArgLambda\nfrom org.apache.tinkerpop.gremlin.util.function.Lambda import TwoArgLambda\n\nclass JythonUnknownArgLambda(UnknownArgLambda):\n  def __init__(self,func,script='none',lang='gremlin-jython'):\n    UnknownArgLambda.__init__(self, script, lang, -1)\n    self.func = func\n  def __repr__(self):\n    return self.getLambdaScript()\n\nclass JythonZeroArgLambda(ZeroArgLambda):\n  def __init__(self,func,script='none',lang='gremlin-jython'):\n    ZeroArgLambda.__init__(self, script, lang)\n    self.func = func\n  def __repr__(self):\n    return self.getLambdaScript()\n  def get(self):\n    return self.func()\n\nclass JythonOneArgLambda(OneArgLambda):\n  def __init__(self,func,script='none',lang='gremlin-jython'):\n    OneArgLambda.__init__(self, script, lang)\n    self.func = func\n  def __repr__(self):\n    return self.getLambdaScript()\n  def test(self,a):\n    return self.func(a)\n  def apply(self,a):\n    return self.func(a)\n  def accept(self,a):\n    self.func(a)\n  def compare(self,a,b):\n    return self.func(a,b)\n\nclass JythonTwoArgLambda(TwoArgLambda):\n  def __init__(self,func,script='none',lang='gremlin-jython'):\n    TwoArgLambda.__init__(self, script, lang)\n    self.func = func\n  def __repr__(self):\n    return self.getLambdaScript()\n  def apply(self,a,b):\n    return self.func(a,b)\n  def compare(self,a,b):\n    return self.func(a,b)\n");
    }
}

