/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.driver.ser;

import io.netty.buffer.ByteBufAllocator;
import java.nio.ByteBuffer;
import org.apache.tinkerpop.gremlin.driver.message.RequestMessage;
import org.apache.tinkerpop.gremlin.driver.message.ResponseMessage;
import org.apache.tinkerpop.gremlin.driver.ser.AbstractGraphSONMessageSerializerV2d0;
import org.apache.tinkerpop.gremlin.driver.ser.MessageTextSerializer;
import org.apache.tinkerpop.gremlin.driver.ser.SerializationException;
import org.apache.tinkerpop.gremlin.structure.io.graphson.GraphSONMapper;
import org.apache.tinkerpop.gremlin.structure.io.graphson.TypeInfo;
import org.apache.tinkerpop.shaded.jackson.databind.ObjectMapper;
import org.apache.tinkerpop.shaded.jackson.databind.module.SimpleModule;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class GraphSONMessageSerializerV2d0
extends AbstractGraphSONMessageSerializerV2d0
implements MessageTextSerializer<ObjectMapper> {
    private static final Logger logger = LoggerFactory.getLogger(GraphSONMessageSerializerV2d0.class);
    private static final String MIME_TYPE = "application/vnd.gremlin-v2.0+json";
    private static byte[] header;

    public GraphSONMessageSerializerV2d0() {
    }

    @Deprecated
    public GraphSONMessageSerializerV2d0(GraphSONMapper mapper) {
        super(mapper);
    }

    public GraphSONMessageSerializerV2d0(GraphSONMapper.Builder mapperBuilder) {
        super(mapperBuilder);
    }

    @Override
    public String[] mimeTypesSupported() {
        return new String[]{MIME_TYPE, "application/json"};
    }

    @Override
    GraphSONMapper.Builder configureBuilder(GraphSONMapper.Builder builder) {
        return builder.typeInfo(TypeInfo.PARTIAL_TYPES).addCustomModule((SimpleModule)new AbstractGraphSONMessageSerializerV2d0.GremlinServerModule());
    }

    @Override
    byte[] obtainHeader() {
        return header;
    }

    @Override
    public ResponseMessage deserializeResponse(String msg) throws SerializationException {
        try {
            return (ResponseMessage)this.mapper.readValue(msg, ResponseMessage.class);
        }
        catch (Exception ex) {
            logger.warn("Response [{}] could not be deserialized by {}.", (Object)msg, (Object)AbstractGraphSONMessageSerializerV2d0.class.getName());
            throw new SerializationException(ex);
        }
    }

    @Override
    public String serializeResponseAsString(ResponseMessage responseMessage, ByteBufAllocator allocator) throws SerializationException {
        try {
            return this.mapper.writeValueAsString((Object)responseMessage);
        }
        catch (Exception ex) {
            logger.warn("Response [{}] could not be serialized by {}.", (Object)responseMessage.toString(), (Object)AbstractGraphSONMessageSerializerV2d0.class.getName());
            throw new SerializationException(ex);
        }
    }

    @Override
    public RequestMessage deserializeRequest(String msg) throws SerializationException {
        try {
            return (RequestMessage)this.mapper.readValue(msg, RequestMessage.class);
        }
        catch (Exception ex) {
            logger.warn("Request [{}] could not be deserialized by {}.", (Object)msg, (Object)AbstractGraphSONMessageSerializerV2d0.class.getName());
            throw new SerializationException(ex);
        }
    }

    @Override
    public String serializeRequestAsString(RequestMessage requestMessage, ByteBufAllocator allocator) throws SerializationException {
        try {
            return this.mapper.writeValueAsString((Object)requestMessage);
        }
        catch (Exception ex) {
            logger.warn("Request [{}] could not be serialized by {}.", (Object)requestMessage.toString(), (Object)AbstractGraphSONMessageSerializerV2d0.class.getName());
            throw new SerializationException(ex);
        }
    }

    static {
        ByteBuffer buffer = ByteBuffer.allocate(MIME_TYPE.length() + 1);
        buffer.put((byte)MIME_TYPE.length());
        buffer.put(MIME_TYPE.getBytes());
        header = buffer.array();
    }
}

