/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.driver;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.socket.SocketChannel;
import io.netty.handler.codec.http.EmptyHttpHeaders;
import io.netty.handler.codec.http.HttpClientCodec;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.websocketx.CloseWebSocketFrame;
import io.netty.handler.codec.http.websocketx.PingWebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketClientHandshakerFactory;
import io.netty.handler.codec.http.websocketx.WebSocketVersion;
import io.netty.handler.ssl.SslContext;
import java.net.URI;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import org.apache.tinkerpop.gremlin.driver.Cluster;
import org.apache.tinkerpop.gremlin.driver.Connection;
import org.apache.tinkerpop.gremlin.driver.Handler;
import org.apache.tinkerpop.gremlin.driver.ResultQueue;
import org.apache.tinkerpop.gremlin.driver.exception.ConnectionException;
import org.apache.tinkerpop.gremlin.driver.handler.NioGremlinRequestEncoder;
import org.apache.tinkerpop.gremlin.driver.handler.NioGremlinResponseDecoder;
import org.apache.tinkerpop.gremlin.driver.handler.WebSocketClientHandler;
import org.apache.tinkerpop.gremlin.driver.handler.WebSocketGremlinRequestEncoder;
import org.apache.tinkerpop.gremlin.driver.handler.WebSocketGremlinResponseDecoder;

public interface Channelizer
extends ChannelHandler {
    public void init(Connection var1);

    public void close(Channel var1);

    default public Object createKeepAliveMessage() {
        return null;
    }

    default public boolean supportsKeepAlive() {
        return false;
    }

    default public void connected() {
    }

    @Deprecated
    public static final class NioChannelizer
    extends AbstractChannelizer {
        @Override
        public void init(Connection connection) {
            super.init(connection);
        }

        @Override
        public void configure(ChannelPipeline pipeline) {
            pipeline.addLast("gremlin-decoder", (ChannelHandler)new NioGremlinResponseDecoder(this.cluster.getSerializer()));
            pipeline.addLast("gremlin-encoder", (ChannelHandler)new NioGremlinRequestEncoder(true, this.cluster.getSerializer()));
        }
    }

    public static final class WebSocketChannelizer
    extends AbstractChannelizer {
        private WebSocketClientHandler handler;
        private WebSocketGremlinRequestEncoder webSocketGremlinRequestEncoder;
        private WebSocketGremlinResponseDecoder webSocketGremlinResponseDecoder;

        @Override
        public void init(Connection connection) {
            super.init(connection);
            this.webSocketGremlinRequestEncoder = new WebSocketGremlinRequestEncoder(true, this.cluster.getSerializer());
            this.webSocketGremlinResponseDecoder = new WebSocketGremlinResponseDecoder(this.cluster.getSerializer());
        }

        @Override
        public boolean supportsKeepAlive() {
            return true;
        }

        @Override
        public Object createKeepAliveMessage() {
            return new PingWebSocketFrame();
        }

        @Override
        public void close(Channel channel) {
            if (channel.isOpen()) {
                channel.writeAndFlush((Object)new CloseWebSocketFrame());
            }
        }

        @Override
        public boolean supportsSsl() {
            String scheme = this.connection.getUri().getScheme();
            return "wss".equalsIgnoreCase(scheme);
        }

        @Override
        public void configure(ChannelPipeline pipeline) {
            String scheme = this.connection.getUri().getScheme();
            if (!"ws".equalsIgnoreCase(scheme) && !"wss".equalsIgnoreCase(scheme)) {
                throw new IllegalStateException("Unsupported scheme (only ws: or wss: supported): " + scheme);
            }
            if (!this.supportsSsl() && "wss".equalsIgnoreCase(scheme)) {
                throw new IllegalStateException("To use wss scheme ensure that enableSsl is set to true in configuration");
            }
            int maxContentLength = this.cluster.connectionPoolSettings().maxContentLength;
            this.handler = new WebSocketClientHandler(WebSocketClientHandshakerFactory.newHandshaker((URI)this.connection.getUri(), (WebSocketVersion)WebSocketVersion.V13, null, (boolean)false, (HttpHeaders)EmptyHttpHeaders.INSTANCE, (int)maxContentLength));
            pipeline.addLast("http-codec", (ChannelHandler)new HttpClientCodec());
            pipeline.addLast("aggregator", (ChannelHandler)new HttpObjectAggregator(maxContentLength));
            pipeline.addLast("ws-handler", (ChannelHandler)this.handler);
            pipeline.addLast("gremlin-encoder", (ChannelHandler)this.webSocketGremlinRequestEncoder);
            pipeline.addLast("gremlin-decoder", (ChannelHandler)this.webSocketGremlinResponseDecoder);
        }

        @Override
        public void connected() {
            try {
                this.handler.handshakeFuture().get(15000L, TimeUnit.MILLISECONDS);
            }
            catch (Exception ex) {
                throw new RuntimeException(new ConnectionException(this.connection.getUri(), "Could not complete websocket handshake - ensure that client protocol matches server", ex));
            }
        }
    }

    public static abstract class AbstractChannelizer
    extends ChannelInitializer<SocketChannel>
    implements Channelizer {
        protected Connection connection;
        protected Cluster cluster;
        private ConcurrentMap<UUID, ResultQueue> pending;
        protected static final String PIPELINE_GREMLIN_SASL_HANDLER = "gremlin-sasl-handler";
        protected static final String PIPELINE_GREMLIN_HANDLER = "gremlin-handler";

        public boolean supportsSsl() {
            return this.cluster.connectionPoolSettings().enableSsl;
        }

        public abstract void configure(ChannelPipeline var1);

        public void finalize(ChannelPipeline pipeline) {
        }

        @Override
        public void close(Channel channel) {
        }

        @Override
        public void init(Connection connection) {
            this.connection = connection;
            this.cluster = connection.getCluster();
            this.pending = connection.getPending();
        }

        protected void initChannel(SocketChannel socketChannel) throws Exception {
            Optional<Object> sslCtx;
            ChannelPipeline pipeline = socketChannel.pipeline();
            if (this.supportsSsl()) {
                try {
                    sslCtx = Optional.of(this.cluster.createSSLContext());
                }
                catch (Exception ex) {
                    throw new RuntimeException(ex);
                }
            } else {
                sslCtx = Optional.empty();
            }
            if (sslCtx.isPresent()) {
                pipeline.addLast(new ChannelHandler[]{((SslContext)sslCtx.get()).newHandler(socketChannel.alloc(), this.connection.getUri().getHost(), this.connection.getUri().getPort())});
            }
            this.configure(pipeline);
            pipeline.addLast(PIPELINE_GREMLIN_SASL_HANDLER, (ChannelHandler)new Handler.GremlinSaslAuthenticationHandler(this.cluster.authProperties()));
            pipeline.addLast(PIPELINE_GREMLIN_HANDLER, (ChannelHandler)new Handler.GremlinResponseHandler(this.pending));
        }
    }
}

