/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.driver;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.commons.lang3.concurrent.BasicThreadFactory;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.tinkerpop.gremlin.driver.Cluster;
import org.apache.tinkerpop.gremlin.driver.Connection;
import org.apache.tinkerpop.gremlin.driver.ConnectionPool;
import org.apache.tinkerpop.gremlin.driver.Host;
import org.apache.tinkerpop.gremlin.driver.RequestOptions;
import org.apache.tinkerpop.gremlin.driver.ResultSet;
import org.apache.tinkerpop.gremlin.driver.exception.ConnectionException;
import org.apache.tinkerpop.gremlin.driver.exception.NoHostAvailableException;
import org.apache.tinkerpop.gremlin.driver.message.RequestMessage;
import org.apache.tinkerpop.gremlin.process.traversal.Bytecode;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.util.iterator.IteratorUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Client {
    private static final Logger logger = LoggerFactory.getLogger(Client.class);
    protected final Cluster cluster;
    protected volatile boolean initialized;
    protected final Settings settings;
    protected Throwable initializationFailure = null;

    Client(Cluster cluster, Settings settings) {
        this.cluster = cluster;
        this.settings = settings;
    }

    public RequestMessage.Builder buildMessage(RequestMessage.Builder builder) {
        return builder;
    }

    protected abstract void initializeImplementation();

    protected abstract Connection chooseConnection(RequestMessage var1) throws TimeoutException, ConnectionException;

    public abstract CompletableFuture<Void> closeAsync();

    public Client alias(String graphOrTraversalSource) {
        return this.alias(this.makeDefaultAliasMap(graphOrTraversalSource));
    }

    public Client alias(Map<String, String> aliases) {
        return new AliasClusteredClient(this, aliases, this.settings);
    }

    public ResultSet submit(Traversal traversal) {
        try {
            return this.submitAsync(traversal).get();
        }
        catch (UnsupportedOperationException uoe) {
            throw uoe;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public CompletableFuture<ResultSet> submitAsync(Traversal traversal) {
        throw new UnsupportedOperationException("This implementation does not support Traversal submission - use a sessionless Client created with from the alias() method");
    }

    public ResultSet submit(Bytecode bytecode) {
        try {
            return this.submitAsync(bytecode).get();
        }
        catch (UnsupportedOperationException uoe) {
            throw uoe;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public ResultSet submit(Bytecode bytecode, RequestOptions options) {
        try {
            return this.submitAsync(bytecode, options).get();
        }
        catch (UnsupportedOperationException uoe) {
            throw uoe;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public CompletableFuture<ResultSet> submitAsync(Bytecode bytecode) {
        throw new UnsupportedOperationException("This implementation does not support Traversal submission - use a sessionless Client created with from the alias() method");
    }

    public CompletableFuture<ResultSet> submitAsync(Bytecode bytecode, RequestOptions options) {
        throw new UnsupportedOperationException("This implementation does not support Traversal submission - use a sessionless Client created with from the alias() method");
    }

    public synchronized Client init() {
        if (this.initialized) {
            return this;
        }
        logger.debug("Initializing client on cluster [{}]", (Object)this.cluster);
        this.cluster.init();
        this.initializeImplementation();
        if (this.cluster.availableHosts().isEmpty()) {
            if (this.initializationFailure != null) {
                throw new NoHostAvailableException(this.initializationFailure);
            }
            throw new NoHostAvailableException();
        }
        this.initialized = true;
        return this;
    }

    public ResultSet submit(String gremlin) {
        return this.submit(gremlin, RequestOptions.EMPTY);
    }

    public ResultSet submit(String gremlin, Map<String, Object> parameters) {
        try {
            return this.submitAsync(gremlin, parameters).get();
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public ResultSet submit(String gremlin, RequestOptions options) {
        try {
            return this.submitAsync(gremlin, options).get();
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public CompletableFuture<ResultSet> submitAsync(String gremlin) {
        return this.submitAsync(gremlin, RequestOptions.build().create());
    }

    public CompletableFuture<ResultSet> submitAsync(String gremlin, Map<String, Object> parameters) {
        RequestOptions.Builder options = RequestOptions.build();
        if (parameters != null && !parameters.isEmpty()) {
            parameters.forEach(options::addParameter);
        }
        return this.submitAsync(gremlin, options.create());
    }

    @Deprecated
    public CompletableFuture<ResultSet> submitAsync(String gremlin, String graphOrTraversalSource, Map<String, Object> parameters) {
        Map<String, String> aliases = null;
        if (graphOrTraversalSource != null && !graphOrTraversalSource.isEmpty()) {
            aliases = this.makeDefaultAliasMap(graphOrTraversalSource);
        }
        return this.submitAsync(gremlin, aliases, parameters);
    }

    @Deprecated
    public CompletableFuture<ResultSet> submitAsync(String gremlin, Map<String, String> aliases, Map<String, Object> parameters) {
        RequestOptions.Builder options = RequestOptions.build();
        if (aliases != null && !aliases.isEmpty()) {
            aliases.forEach(options::addAlias);
        }
        if (parameters != null && !parameters.isEmpty()) {
            parameters.forEach(options::addParameter);
        }
        options.batchSize(this.cluster.connectionPoolSettings().resultIterationBatchSize);
        return this.submitAsync(gremlin, options.create());
    }

    public CompletableFuture<ResultSet> submitAsync(String gremlin, RequestOptions options) {
        int batchSize = options.getBatchSize().orElse(this.cluster.connectionPoolSettings().resultIterationBatchSize);
        RequestMessage.Builder request = this.buildMessage(RequestMessage.build("eval")).add("gremlin", gremlin).add("batchSize", batchSize);
        options.getTimeout().ifPresent(timeout -> request.add("scriptEvaluationTimeout", timeout));
        options.getParameters().ifPresent(params -> request.addArg("bindings", params));
        options.getAliases().ifPresent(aliases -> request.addArg("aliases", aliases));
        options.getOverrideRequestId().ifPresent(request::overrideRequestId);
        options.getUserAgent().ifPresent(userAgent -> request.addArg("userAgent", userAgent));
        return this.submitAsync(request.create());
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public CompletableFuture<ResultSet> submitAsync(RequestMessage msg) {
        CompletableFuture<ResultSet> completableFuture;
        if (this.isClosing()) {
            throw new IllegalStateException("Client has been closed");
        }
        if (!this.initialized) {
            this.init();
        }
        CompletableFuture<ResultSet> future = new CompletableFuture<ResultSet>();
        Connection connection = null;
        try {
            connection = this.chooseConnection(msg);
            connection.write(msg, future);
            completableFuture = future;
        }
        catch (TimeoutException toe) {
            try {
                throw new RuntimeException(toe);
                catch (ConnectionException ce) {
                    throw new RuntimeException(ce);
                }
                catch (Exception ex) {
                    throw new RuntimeException(ex);
                }
            }
            catch (Throwable throwable) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Submitted {} to - {}", (Object)msg, (Object)(null == connection ? "connection not initialized" : connection.toString()));
                }
                throw throwable;
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Submitted {} to - {}", (Object)msg, (Object)(null == connection ? "connection not initialized" : connection.toString()));
        }
        return completableFuture;
    }

    public abstract boolean isClosing();

    public void close() {
        this.closeAsync().join();
    }

    public Settings getSettings() {
        return this.settings;
    }

    public Cluster getCluster() {
        return this.cluster;
    }

    protected Map<String, String> makeDefaultAliasMap(String graphOrTraversalSource) {
        HashMap<String, String> aliases = new HashMap<String, String>();
        aliases.put("g", graphOrTraversalSource);
        return aliases;
    }

    public static class SessionSettings {
        private final boolean manageTransactions;
        private final String sessionId;
        private final boolean forceClosed;

        private SessionSettings(Builder builder) {
            this.manageTransactions = builder.manageTransactions;
            this.sessionId = builder.sessionId;
            this.forceClosed = builder.forceClosed;
        }

        public boolean manageTransactions() {
            return this.manageTransactions;
        }

        public String getSessionId() {
            return this.sessionId;
        }

        public boolean isForceClosed() {
            return this.forceClosed;
        }

        public static Builder build() {
            return new Builder();
        }

        public static class Builder {
            private boolean manageTransactions = false;
            private String sessionId = UUID.randomUUID().toString();
            private boolean forceClosed = false;

            private Builder() {
            }

            public Builder manageTransactions(boolean manage) {
                this.manageTransactions = manage;
                return this;
            }

            public Builder sessionId(String sessionId) {
                if (null == sessionId || sessionId.isEmpty()) {
                    throw new IllegalArgumentException("sessionId cannot be null or empty");
                }
                this.sessionId = sessionId;
                return this;
            }

            public Builder forceClosed(boolean forced) {
                this.forceClosed = forced;
                return this;
            }

            public SessionSettings create() {
                return new SessionSettings(this);
            }
        }
    }

    public static class Settings {
        private final Optional<SessionSettings> session;

        private Settings(Builder builder) {
            this.session = builder.session;
        }

        public static Builder build() {
            return new Builder();
        }

        public Optional<SessionSettings> getSession() {
            return this.session;
        }

        public static class Builder {
            private Optional<SessionSettings> session = Optional.empty();

            private Builder() {
            }

            public Builder useSession(boolean enabled) {
                this.session = enabled ? Optional.of(SessionSettings.build().create()) : Optional.empty();
                return this;
            }

            public Builder useSession(String sessionId) {
                this.session = sessionId != null && !sessionId.isEmpty() ? Optional.of(SessionSettings.build().sessionId(sessionId).create()) : Optional.empty();
                return this;
            }

            public Builder useSession(SessionSettings settings) {
                this.session = Optional.ofNullable(settings);
                return this;
            }

            public Settings create() {
                return new Settings(this);
            }
        }
    }

    public static final class SessionedClient
    extends Client {
        private final String sessionId;
        private final boolean manageTransactions;
        private ConnectionPool connectionPool;
        private final AtomicReference<CompletableFuture<Void>> closing = new AtomicReference<Object>(null);

        SessionedClient(Cluster cluster, Settings settings) {
            super(cluster, settings);
            this.sessionId = settings.getSession().get().sessionId;
            this.manageTransactions = settings.getSession().get().manageTransactions;
        }

        String getSessionId() {
            return this.sessionId;
        }

        @Override
        public RequestMessage.Builder buildMessage(RequestMessage.Builder builder) {
            builder.processor("session");
            builder.addArg("session", this.sessionId);
            builder.addArg("manageTransaction", this.manageTransactions);
            return builder;
        }

        @Override
        protected Connection chooseConnection(RequestMessage msg) throws TimeoutException, ConnectionException {
            return this.connectionPool.borrowConnection(this.cluster.connectionPoolSettings().maxWaitForConnection, TimeUnit.MILLISECONDS);
        }

        @Override
        protected void initializeImplementation() {
            if (this.cluster.allHosts().isEmpty()) {
                throw new IllegalStateException("No available host in the cluster");
            }
            ArrayList<Host> hosts = new ArrayList<Host>(this.cluster.allHosts());
            Collections.shuffle(hosts);
            Optional<Host> host = hosts.stream().filter(Host::isAvailable).findFirst();
            Host selectedHost = host.orElse((Host)hosts.get(0));
            try {
                this.connectionPool = new ConnectionPool(selectedHost, this, Optional.of(1), Optional.of(1));
                selectedHost.makeAvailable();
            }
            catch (RuntimeException ex) {
                logger.error("Could not initialize client for {}", host, (Object)ex);
                this.initializationFailure = ex;
            }
        }

        @Override
        public boolean isClosing() {
            return this.closing.get() != null;
        }

        @Override
        public synchronized CompletableFuture<Void> closeAsync() {
            if (this.closing.get() != null) {
                return this.closing.get();
            }
            CompletableFuture<Object> connectionPoolClose = null == this.connectionPool ? CompletableFuture.completedFuture(null) : this.connectionPool.closeAsync();
            this.closing.set(connectionPoolClose);
            return connectionPoolClose;
        }
    }

    public static class AliasClusteredClient
    extends Client {
        private final Client client;
        private final Map<String, String> aliases = new HashMap<String, String>();
        final CompletableFuture<Void> close = new CompletableFuture();

        AliasClusteredClient(Client client, Map<String, String> aliases, Settings settings) {
            super(client.cluster, settings);
            this.client = client;
            this.aliases.putAll(aliases);
        }

        @Override
        public CompletableFuture<ResultSet> submitAsync(Bytecode bytecode) {
            return this.submitAsync(bytecode, RequestOptions.EMPTY);
        }

        @Override
        public CompletableFuture<ResultSet> submitAsync(Bytecode bytecode, RequestOptions options) {
            try {
                RequestMessage.Builder request = this.buildMessage(RequestMessage.build("bytecode").processor("traversal").addArg("gremlin", bytecode));
                options.getBatchSize().ifPresent(batchSize -> request.add("batchSize", batchSize));
                options.getTimeout().ifPresent(timeout -> request.add("scriptEvaluationTimeout", timeout));
                options.getOverrideRequestId().ifPresent(request::overrideRequestId);
                options.getUserAgent().ifPresent(userAgent -> request.add("userAgent", userAgent));
                return this.submitAsync(request.create());
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }

        @Override
        public CompletableFuture<ResultSet> submitAsync(RequestMessage msg) {
            RequestMessage.Builder builder = RequestMessage.from(msg);
            if (!this.aliases.isEmpty()) {
                Map original = msg.getArgs().getOrDefault("aliases", Collections.emptyMap());
                this.aliases.forEach((k, v) -> {
                    if (!original.containsKey(k)) {
                        builder.addArg("aliases", this.aliases);
                    }
                });
            }
            return super.submitAsync(builder.create());
        }

        @Override
        public CompletableFuture<ResultSet> submitAsync(Traversal traversal) {
            return this.submitAsync(traversal.asAdmin().getBytecode());
        }

        @Override
        public synchronized Client init() {
            if (this.close.isDone()) {
                throw new IllegalStateException("Client is closed");
            }
            this.client.init();
            return this;
        }

        @Override
        public RequestMessage.Builder buildMessage(RequestMessage.Builder builder) {
            if (this.close.isDone()) {
                throw new IllegalStateException("Client is closed");
            }
            if (!this.aliases.isEmpty()) {
                builder.addArg("aliases", this.aliases);
            }
            return this.client.buildMessage(builder);
        }

        @Override
        protected void initializeImplementation() {
            if (this.close.isDone()) {
                throw new IllegalStateException("Client is closed");
            }
        }

        @Override
        protected Connection chooseConnection(RequestMessage msg) throws TimeoutException, ConnectionException {
            if (this.close.isDone()) {
                throw new IllegalStateException("Client is closed");
            }
            return this.client.chooseConnection(msg);
        }

        @Override
        public synchronized CompletableFuture<Void> closeAsync() {
            this.close.complete(null);
            return this.close;
        }

        @Override
        public boolean isClosing() {
            return this.close.isDone();
        }

        @Override
        public Client alias(Map<String, String> aliases) {
            if (this.close.isDone()) {
                throw new IllegalStateException("Client is closed");
            }
            return new AliasClusteredClient(this.client, aliases, this.settings);
        }
    }

    public static final class ClusteredClient
    extends Client {
        protected ConcurrentMap<Host, ConnectionPool> hostConnectionPools = new ConcurrentHashMap<Host, ConnectionPool>();
        private final AtomicReference<CompletableFuture<Void>> closing = new AtomicReference<Object>(null);
        private Consumer<Host> initializeConnectionSetupForHost = host -> {
            try {
                this.hostConnectionPools.put((Host)host, new ConnectionPool((Host)host, this));
                host.makeAvailable();
                this.cluster.loadBalancingStrategy().onNew((Host)host);
            }
            catch (RuntimeException ex) {
                throw new RuntimeException(String.format("Could not initialize client for %s.", host), ex);
            }
        };

        ClusteredClient(Cluster cluster, Settings settings) {
            super(cluster, settings);
        }

        @Override
        public boolean isClosing() {
            return this.closing.get() != null;
        }

        public ResultSet submit(String gremlin, String graphOrTraversalSource) {
            return this.submit(gremlin, graphOrTraversalSource, null);
        }

        public ResultSet submit(String gremlin, String graphOrTraversalSource, Map<String, Object> parameters) {
            try {
                return this.submitAsync(gremlin, graphOrTraversalSource, parameters).get();
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }

        @Override
        public Client alias(String graphOrTraversalSource) {
            HashMap<String, String> aliases = new HashMap<String, String>();
            aliases.put("g", graphOrTraversalSource);
            return this.alias(aliases);
        }

        @Override
        public Client alias(Map<String, String> aliases) {
            return new AliasClusteredClient(this, aliases, this.settings);
        }

        @Override
        protected Connection chooseConnection(RequestMessage msg) throws TimeoutException, ConnectionException {
            Iterator possibleHosts;
            if (msg.optionalArgs("host").isPresent()) {
                Host host = (Host)msg.getArgs().get("host");
                msg.getArgs().remove("host");
                possibleHosts = IteratorUtils.of((Object)host);
            } else {
                possibleHosts = this.cluster.loadBalancingStrategy().select(msg);
            }
            if (!possibleHosts.hasNext()) {
                if (this.initializationFailure != null) {
                    throw new NoHostAvailableException(this.initializationFailure);
                }
                throw new NoHostAvailableException();
            }
            Host bestHost = possibleHosts.next();
            ConnectionPool pool = (ConnectionPool)this.hostConnectionPools.get(bestHost);
            return pool.borrowConnection(this.cluster.connectionPoolSettings().maxWaitForConnection, TimeUnit.MILLISECONDS);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void initializeImplementation() {
            BasicThreadFactory threadFactory = new BasicThreadFactory.Builder().namingPattern("gremlin-driver-initializer").build();
            ExecutorService hostExecutor = Executors.newSingleThreadExecutor((ThreadFactory)threadFactory);
            try {
                CompletableFuture.allOf((CompletableFuture[])this.cluster.allHosts().stream().map(host -> CompletableFuture.runAsync(() -> this.initializeConnectionSetupForHost.accept((Host)host), hostExecutor)).toArray(CompletableFuture[]::new)).join();
            }
            catch (CompletionException ex) {
                this.initializationFailure = ExceptionUtils.getRootCause((Throwable)ex) != null ? ExceptionUtils.getRootCause((Throwable)ex) : ex;
                logger.error("", this.initializationFailure);
            }
            finally {
                hostExecutor.shutdown();
            }
            if (this.cluster.availableHosts().isEmpty()) {
                throw new NoHostAvailableException();
            }
            List unavailableHosts = this.cluster.allHosts().stream().filter(host -> !host.isAvailable()).collect(Collectors.toList());
            if (!unavailableHosts.isEmpty()) {
                CompletableFuture.runAsync(() -> this.handleUnavailableHosts(unavailableHosts));
            }
        }

        @Override
        public synchronized CompletableFuture<Void> closeAsync() {
            if (this.closing.get() != null) {
                return this.closing.get();
            }
            CompletableFuture<Void> allPoolsClosedFuture = CompletableFuture.allOf((CompletableFuture[])this.hostConnectionPools.values().stream().map(ConnectionPool::closeAsync).toArray(CompletableFuture[]::new));
            this.closing.set(allPoolsClosedFuture);
            return this.closing.get();
        }

        private void handleUnavailableHosts(List<Host> unavailableHosts) {
            try {
                CompletableFuture.allOf((CompletableFuture[])unavailableHosts.stream().map(host -> CompletableFuture.runAsync(() -> host.makeUnavailable(this::tryReInitializeHost))).toArray(CompletableFuture[]::new)).join();
            }
            catch (CompletionException ex) {
                logger.error("", ex.getCause() == null ? ex : ex.getCause());
            }
        }

        public boolean tryReInitializeHost(Host host) {
            logger.debug("Trying to re-initiate host connection pool on {}", (Object)host);
            try {
                this.initializeConnectionSetupForHost.accept(host);
                return true;
            }
            catch (Exception ex) {
                logger.debug("Failed re-initialization attempt on {}", (Object)host, (Object)ex);
                return false;
            }
        }
    }
}

