/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.driver.ser.binary.types;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.CompositeByteBuf;
import org.apache.tinkerpop.gremlin.driver.ser.SerializationException;
import org.apache.tinkerpop.gremlin.driver.ser.binary.DataType;
import org.apache.tinkerpop.gremlin.driver.ser.binary.GraphBinaryReader;
import org.apache.tinkerpop.gremlin.driver.ser.binary.GraphBinaryWriter;
import org.apache.tinkerpop.gremlin.driver.ser.binary.types.SimpleTypeSerializer;
import org.apache.tinkerpop.gremlin.structure.VertexProperty;
import org.apache.tinkerpop.gremlin.structure.util.reference.ReferenceVertexProperty;

public class VertexPropertySerializer
extends SimpleTypeSerializer<VertexProperty> {
    public VertexPropertySerializer() {
        super(DataType.VERTEXPROPERTY);
    }

    @Override
    VertexProperty readValue(ByteBuf buffer, GraphBinaryReader context) throws SerializationException {
        ReferenceVertexProperty v = new ReferenceVertexProperty(context.read(buffer), context.readValue(buffer, String.class, false), context.read(buffer));
        context.read(buffer);
        context.read(buffer);
        return v;
    }

    @Override
    public ByteBuf writeValue(VertexProperty value, ByteBufAllocator allocator, GraphBinaryWriter context) throws SerializationException {
        CompositeByteBuf result = allocator.compositeBuffer(5);
        result.addComponent(true, context.write(value.id(), allocator));
        result.addComponent(true, context.writeValue(value.label(), allocator, false));
        result.addComponent(true, context.write(value.value(), allocator));
        result.addComponent(true, context.write(null, allocator));
        result.addComponent(true, context.write(null, allocator));
        return result;
    }
}

