/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.driver.ser.binary.types;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.CompositeByteBuf;
import org.apache.tinkerpop.gremlin.driver.ser.SerializationException;
import org.apache.tinkerpop.gremlin.driver.ser.binary.DataType;
import org.apache.tinkerpop.gremlin.driver.ser.binary.GraphBinaryReader;
import org.apache.tinkerpop.gremlin.driver.ser.binary.GraphBinaryWriter;
import org.apache.tinkerpop.gremlin.driver.ser.binary.types.SimpleTypeSerializer;
import org.apache.tinkerpop.gremlin.process.remote.traversal.DefaultRemoteTraverser;
import org.apache.tinkerpop.gremlin.process.traversal.Traverser;

public class TraverserSerializer
extends SimpleTypeSerializer<Traverser> {
    public TraverserSerializer() {
        super(DataType.TRAVERSER);
    }

    @Override
    Traverser readValue(ByteBuf buffer, GraphBinaryReader context) throws SerializationException {
        long bulk = context.readValue(buffer, Long.class, false);
        Object v = context.read(buffer);
        return new DefaultRemoteTraverser(v, bulk);
    }

    @Override
    public ByteBuf writeValue(Traverser value, ByteBufAllocator allocator, GraphBinaryWriter context) throws SerializationException {
        CompositeByteBuf result = allocator.compositeBuffer(2);
        result.addComponent(true, context.writeValue(value.bulk(), allocator, false));
        result.addComponent(true, context.write(value.get(), allocator));
        return result;
    }
}

