/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.driver.ser.binary.types;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import java.time.MonthDay;
import org.apache.tinkerpop.gremlin.driver.ser.SerializationException;
import org.apache.tinkerpop.gremlin.driver.ser.binary.DataType;
import org.apache.tinkerpop.gremlin.driver.ser.binary.GraphBinaryReader;
import org.apache.tinkerpop.gremlin.driver.ser.binary.GraphBinaryWriter;
import org.apache.tinkerpop.gremlin.driver.ser.binary.types.SimpleTypeSerializer;

public class MonthDaySerializer
extends SimpleTypeSerializer<MonthDay> {
    public MonthDaySerializer() {
        super(DataType.MONTHDAY);
    }

    @Override
    MonthDay readValue(ByteBuf buffer, GraphBinaryReader context) throws SerializationException {
        return MonthDay.of(buffer.readByte(), (int)buffer.readByte());
    }

    @Override
    public ByteBuf writeValue(MonthDay value, ByteBufAllocator allocator, GraphBinaryWriter context) throws SerializationException {
        return allocator.buffer(2).writeByte(value.getMonthValue()).writeByte(value.getDayOfMonth());
    }
}

