/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.driver.ser.binary.types;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.tinkerpop.gremlin.driver.ser.SerializationException;
import org.apache.tinkerpop.gremlin.driver.ser.binary.DataType;
import org.apache.tinkerpop.gremlin.driver.ser.binary.GraphBinaryReader;
import org.apache.tinkerpop.gremlin.driver.ser.binary.GraphBinaryWriter;
import org.apache.tinkerpop.gremlin.driver.ser.binary.types.CollectionSerializer;
import org.apache.tinkerpop.gremlin.driver.ser.binary.types.SimpleTypeSerializer;
import org.apache.tinkerpop.gremlin.process.traversal.util.Metrics;
import org.apache.tinkerpop.gremlin.process.traversal.util.MutableMetrics;

public class MetricsSerializer
extends SimpleTypeSerializer<Metrics> {
    private static final CollectionSerializer collectionSerializer = new CollectionSerializer(DataType.LIST);

    public MetricsSerializer() {
        super(DataType.METRICS);
    }

    @Override
    Metrics readValue(ByteBuf buffer, GraphBinaryReader context) throws SerializationException {
        MutableMetrics result = new MutableMetrics(context.readValue(buffer, String.class, false), context.readValue(buffer, String.class, false));
        result.setDuration(context.readValue(buffer, Long.class, false).longValue(), TimeUnit.NANOSECONDS);
        Map counts = context.readValue(buffer, Map.class, false);
        counts.forEach((arg_0, arg_1) -> ((MutableMetrics)result).setCount(arg_0, arg_1));
        Map annotations = context.readValue(buffer, Map.class, false);
        annotations.forEach((arg_0, arg_1) -> ((MutableMetrics)result).setAnnotation(arg_0, arg_1));
        Collection nestedMetrics = collectionSerializer.readValue(buffer, context);
        nestedMetrics.forEach(arg_0 -> ((MutableMetrics)result).addNested(arg_0));
        return result;
    }

    @Override
    public ByteBuf writeValue(Metrics value, ByteBufAllocator allocator, GraphBinaryWriter context) throws SerializationException {
        return allocator.compositeBuffer(6).addComponents(true, new ByteBuf[]{context.writeValue(value.getId(), allocator, false), context.writeValue(value.getName(), allocator, false), context.writeValue(value.getDuration(TimeUnit.NANOSECONDS), allocator, false), context.writeValue(value.getCounts(), allocator, false), context.writeValue(value.getAnnotations(), allocator, false), collectionSerializer.writeValue(value.getNested(), allocator, context)});
    }
}

