/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.driver.ser;

import java.util.Map;
import java.util.UUID;
import org.apache.tinkerpop.gremlin.driver.message.ResponseMessage;
import org.apache.tinkerpop.gremlin.driver.message.ResponseStatusCode;
import org.apache.tinkerpop.gremlin.structure.io.gryo.kryoshim.InputShim;
import org.apache.tinkerpop.gremlin.structure.io.gryo.kryoshim.KryoShim;
import org.apache.tinkerpop.gremlin.structure.io.gryo.kryoshim.OutputShim;
import org.apache.tinkerpop.gremlin.structure.io.gryo.kryoshim.SerializerShim;

public class ResponseMessageGryoSerializer
implements SerializerShim<ResponseMessage> {
    public <O extends OutputShim> void write(KryoShim<?, O> kryo, O output, ResponseMessage responseMessage) {
        kryo.writeObjectOrNull(output, (Object)(responseMessage.getRequestId() != null ? responseMessage.getRequestId() : null), UUID.class);
        output.writeShort((int)((short)responseMessage.getStatus().getCode().getValue()));
        output.writeString(responseMessage.getStatus().getMessage());
        kryo.writeClassAndObject(output, responseMessage.getStatus().getAttributes());
        kryo.writeClassAndObject(output, responseMessage.getResult().getData());
        kryo.writeClassAndObject(output, responseMessage.getResult().getMeta());
    }

    public <I extends InputShim> ResponseMessage read(KryoShim<I, ?> kryo, I input, Class<ResponseMessage> clazz) {
        UUID requestId = (UUID)kryo.readObjectOrNull(input, UUID.class);
        short status = input.readShort();
        String statusMsg = input.readString();
        Map statusAttributes = (Map)kryo.readClassAndObject(input);
        Object result = kryo.readClassAndObject(input);
        Map metaAttributes = (Map)kryo.readClassAndObject(input);
        return ResponseMessage.build(requestId).code(ResponseStatusCode.getFromValue(status)).statusMessage(statusMsg).statusAttributes(statusAttributes).result(result).responseMetaData(metaAttributes).create();
    }
}

