/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.driver.message;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.tinkerpop.gremlin.driver.message.RequestMessage;
import org.apache.tinkerpop.gremlin.driver.message.ResponseResult;
import org.apache.tinkerpop.gremlin.driver.message.ResponseStatus;
import org.apache.tinkerpop.gremlin.driver.message.ResponseStatusCode;
import org.apache.tinkerpop.gremlin.util.iterator.IteratorUtils;

public final class ResponseMessage {
    private final UUID requestId;
    private final ResponseStatus responseStatus;
    private final ResponseResult responseResult;

    private ResponseMessage(UUID requestId, ResponseStatus responseStatus, ResponseResult responseResult) {
        this.requestId = requestId;
        this.responseResult = responseResult;
        this.responseStatus = responseStatus;
    }

    public UUID getRequestId() {
        return this.requestId;
    }

    public ResponseStatus getStatus() {
        return this.responseStatus;
    }

    public ResponseResult getResult() {
        return this.responseResult;
    }

    public String toString() {
        return "ResponseMessage{requestId=" + this.requestId + ", status=" + this.responseStatus + ", result=" + this.responseResult + '}';
    }

    public static Builder build(RequestMessage requestMessage) {
        return new Builder(requestMessage);
    }

    public static Builder build(UUID requestId) {
        return new Builder(requestId);
    }

    public static final class Builder {
        private final UUID requestId;
        private ResponseStatusCode code = ResponseStatusCode.SUCCESS;
        private Object result = null;
        private String statusMessage = "";
        private Map<String, Object> attributes = Collections.emptyMap();
        private Map<String, Object> metaData = Collections.emptyMap();

        private Builder(RequestMessage requestMessage) {
            this.requestId = requestMessage.getRequestId();
        }

        private Builder(UUID requestId) {
            this.requestId = requestId;
        }

        public Builder code(ResponseStatusCode code) {
            this.code = code;
            return this;
        }

        public Builder statusMessage(String message) {
            this.statusMessage = message;
            return this;
        }

        public Builder statusAttributes(Map<String, Object> attributes) {
            this.attributes = attributes;
            return this;
        }

        public Builder statusAttributeException(Throwable ex) {
            this.statusAttribute("exceptions", IteratorUtils.asList((Object)IteratorUtils.map((Iterable)ExceptionUtils.getThrowableList((Throwable)ex), t -> t.getClass().getName())));
            this.statusAttribute("stackTrace", ExceptionUtils.getFullStackTrace((Throwable)ex));
            return this;
        }

        public Builder statusAttribute(String key, Object value) {
            if (this.attributes == Collections.EMPTY_MAP) {
                this.attributes = new HashMap<String, Object>();
            }
            this.attributes.put(key, value);
            return this;
        }

        public Builder result(Object result) {
            this.result = result;
            return this;
        }

        public Builder responseMetaData(Map<String, Object> metaData) {
            this.metaData = metaData;
            return this;
        }

        public ResponseMessage create() {
            ResponseResult responseResult = new ResponseResult(this.result, this.metaData);
            ResponseStatus responseStatus = new ResponseStatus(this.code, this.statusMessage, this.attributes);
            return new ResponseMessage(this.requestId, responseStatus, responseResult);
        }
    }
}

