/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.driver.remote;

import java.util.Iterator;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import org.apache.commons.configuration.Configuration;
import org.apache.tinkerpop.gremlin.driver.Client;
import org.apache.tinkerpop.gremlin.driver.Cluster;
import org.apache.tinkerpop.gremlin.driver.ResultSet;
import org.apache.tinkerpop.gremlin.driver.remote.DriverRemoteTraversal;
import org.apache.tinkerpop.gremlin.process.computer.traversal.strategy.decoration.VertexProgramStrategy;
import org.apache.tinkerpop.gremlin.process.remote.RemoteConnection;
import org.apache.tinkerpop.gremlin.process.remote.RemoteConnectionException;
import org.apache.tinkerpop.gremlin.process.remote.traversal.RemoteTraversal;
import org.apache.tinkerpop.gremlin.process.traversal.Bytecode;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.Traverser;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.apache.tinkerpop.gremlin.util.iterator.IteratorUtils;

public class DriverRemoteConnection
implements RemoteConnection {
    public static final String GREMLIN_REMOTE_DRIVER_CLUSTERFILE = "gremlin.remote.driver.clusterFile";
    public static final String GREMLIN_REMOTE_DRIVER_SOURCENAME = "gremlin.remote.driver.sourceName";
    private static final String DEFAULT_TRAVERSAL_SOURCE = "g";
    private final Client client;
    private final boolean tryCloseCluster;
    private final boolean tryCloseClient;
    private final String remoteTraversalSourceName;
    private transient Optional<Configuration> conf = Optional.empty();
    private final boolean attachElements;

    public DriverRemoteConnection(Configuration conf) {
        boolean hasClusterConf = IteratorUtils.anyMatch((Iterator)conf.getKeys(), k -> k.startsWith("clusterConfiguration"));
        if (conf.containsKey(GREMLIN_REMOTE_DRIVER_CLUSTERFILE) && hasClusterConf) {
            throw new IllegalStateException(String.format("A configuration should not contain both '%s' and 'clusterConfiguration'", GREMLIN_REMOTE_DRIVER_CLUSTERFILE));
        }
        this.remoteTraversalSourceName = conf.getString(GREMLIN_REMOTE_DRIVER_SOURCENAME, DEFAULT_TRAVERSAL_SOURCE);
        try {
            Cluster cluster = !conf.containsKey(GREMLIN_REMOTE_DRIVER_CLUSTERFILE) && !hasClusterConf ? Cluster.open() : (conf.containsKey(GREMLIN_REMOTE_DRIVER_CLUSTERFILE) ? Cluster.open(conf.getString(GREMLIN_REMOTE_DRIVER_CLUSTERFILE)) : Cluster.open(conf.subset("clusterConfiguration")));
            this.client = ((Client)cluster.connect(Client.Settings.build().create())).alias(this.remoteTraversalSourceName);
        }
        catch (Exception ex) {
            throw new IllegalStateException(ex);
        }
        this.attachElements = false;
        this.tryCloseCluster = true;
        this.tryCloseClient = true;
        this.conf = Optional.of(conf);
    }

    private DriverRemoteConnection(Cluster cluster, boolean tryCloseCluster, String remoteTraversalSourceName) {
        this.client = ((Client)cluster.connect(Client.Settings.build().create())).alias(remoteTraversalSourceName);
        this.remoteTraversalSourceName = remoteTraversalSourceName;
        this.tryCloseCluster = tryCloseCluster;
        this.attachElements = false;
        this.tryCloseClient = true;
    }

    DriverRemoteConnection(Cluster cluster, Configuration conf) {
        this.remoteTraversalSourceName = conf.getString(GREMLIN_REMOTE_DRIVER_SOURCENAME, DEFAULT_TRAVERSAL_SOURCE);
        this.attachElements = conf.containsKey("gremlin.remote.attachment");
        this.client = ((Client)cluster.connect(Client.Settings.build().create())).alias(this.remoteTraversalSourceName);
        this.tryCloseCluster = false;
        this.tryCloseClient = true;
        this.conf = Optional.of(conf);
    }

    private DriverRemoteConnection(Client client, String remoteTraversalSourceName) {
        this.client = client.alias(remoteTraversalSourceName);
        this.remoteTraversalSourceName = remoteTraversalSourceName;
        this.tryCloseCluster = false;
        this.attachElements = false;
        this.tryCloseClient = false;
    }

    public static DriverRemoteConnection using(Client client) {
        return DriverRemoteConnection.using(client, DEFAULT_TRAVERSAL_SOURCE);
    }

    public static DriverRemoteConnection using(Client client, String remoteTraversalSourceName) {
        return new DriverRemoteConnection(client, remoteTraversalSourceName);
    }

    public static DriverRemoteConnection using(String host, int port) {
        return DriverRemoteConnection.using(Cluster.build(host).port(port).create(), DEFAULT_TRAVERSAL_SOURCE);
    }

    public static DriverRemoteConnection using(String host, int port, String remoteTraversalSourceName) {
        return DriverRemoteConnection.using(Cluster.build(host).port(port).create(), remoteTraversalSourceName);
    }

    public static DriverRemoteConnection using(Cluster cluster) {
        return DriverRemoteConnection.using(cluster, DEFAULT_TRAVERSAL_SOURCE);
    }

    public static DriverRemoteConnection using(Cluster cluster, String remoteTraversalSourceName) {
        return new DriverRemoteConnection(cluster, false, remoteTraversalSourceName);
    }

    public static DriverRemoteConnection using(String clusterConfFile) {
        return DriverRemoteConnection.using(clusterConfFile, DEFAULT_TRAVERSAL_SOURCE);
    }

    public static DriverRemoteConnection using(String clusterConfFile, String remoteTraversalSourceName) {
        try {
            return new DriverRemoteConnection(Cluster.open(clusterConfFile), true, remoteTraversalSourceName);
        }
        catch (Exception ex) {
            throw new IllegalStateException(ex);
        }
    }

    public static DriverRemoteConnection using(Configuration conf) {
        if (conf.containsKey("clusterConfigurationFile") && conf.containsKey("clusterConfiguration")) {
            throw new IllegalStateException("A configuration should not contain both 'clusterConfigurationFile' and 'clusterConfiguration'");
        }
        if (!conf.containsKey("clusterConfigurationFile") && !conf.containsKey("clusterConfiguration")) {
            throw new IllegalStateException("A configuration must contain either 'clusterConfigurationFile' and 'clusterConfiguration'");
        }
        String remoteTraversalSourceName = conf.getString(DEFAULT_TRAVERSAL_SOURCE, DEFAULT_TRAVERSAL_SOURCE);
        if (conf.containsKey("clusterConfigurationFile")) {
            return DriverRemoteConnection.using(conf.getString("clusterConfigurationFile"), remoteTraversalSourceName);
        }
        return DriverRemoteConnection.using(Cluster.open(conf.subset("clusterConfiguration")), remoteTraversalSourceName);
    }

    @Deprecated
    public <E> Iterator<Traverser.Admin<E>> submit(Traversal<?, E> t) throws RemoteConnectionException {
        try {
            if (this.conf.isPresent() && this.conf.get().containsKey("gremlin.remote.attachment") && !t.asAdmin().getStrategies().getStrategy(VertexProgramStrategy.class).isPresent()) {
                Graph graph = (Graph)((Supplier)this.conf.get().getProperty("gremlin.remote.attachment")).get();
                return new DriverRemoteTraversal.AttachingTraverserIterator(this.client.submit(t.asAdmin().getBytecode()).iterator(), graph);
            }
            return new DriverRemoteTraversal.TraverserIterator(this.client.submit(t.asAdmin().getBytecode()).iterator());
        }
        catch (Exception ex) {
            throw new RemoteConnectionException((Throwable)ex);
        }
    }

    @Deprecated
    public <E> RemoteTraversal<?, E> submit(Bytecode bytecode) throws RemoteConnectionException {
        try {
            ResultSet rs = this.client.submit(bytecode);
            return new DriverRemoteTraversal(rs, this.client, this.attachElements, this.conf);
        }
        catch (Exception ex) {
            throw new RemoteConnectionException((Throwable)ex);
        }
    }

    public <E> CompletableFuture<RemoteTraversal<?, E>> submitAsync(Bytecode bytecode) throws RemoteConnectionException {
        try {
            return this.client.submitAsync(bytecode).thenApply(rs -> new DriverRemoteTraversal((ResultSet)rs, this.client, this.attachElements, this.conf));
        }
        catch (Exception ex) {
            throw new RemoteConnectionException((Throwable)ex);
        }
    }

    public void close() throws Exception {
        try {
            if (this.tryCloseClient) {
                this.client.close();
            }
        }
        catch (Exception ex) {
            throw new RemoteConnectionException((Throwable)ex);
        }
        finally {
            if (this.tryCloseCluster) {
                this.client.getCluster().close();
            }
        }
    }

    public String toString() {
        return "DriverServerConnection-" + this.client.getCluster() + " [graph=" + this.remoteTraversalSourceName + "]";
    }
}

