/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.driver.exception;

import java.util.List;
import java.util.Optional;
import org.apache.tinkerpop.gremlin.driver.message.ResponseStatusCode;

public class ResponseException
extends Exception {
    private ResponseStatusCode responseStatusCode;
    private String remoteStackTrace = null;
    private List<String> remoteExceptionHierarchy = null;

    public ResponseException(ResponseStatusCode responseStatusCode, String serverMessage) {
        super(serverMessage);
        this.responseStatusCode = responseStatusCode;
    }

    public ResponseException(ResponseStatusCode responseStatusCode, String serverMessage, List<String> remoteExceptionHierarchy, String remoteStackTrace) {
        this(responseStatusCode, serverMessage);
        this.remoteExceptionHierarchy = remoteExceptionHierarchy;
        this.remoteStackTrace = remoteStackTrace;
    }

    public ResponseStatusCode getResponseStatusCode() {
        return this.responseStatusCode;
    }

    public Optional<String> getRemoteStackTrace() {
        return Optional.ofNullable(this.remoteStackTrace);
    }

    public Optional<List<String>> getRemoteExceptionHierarchy() {
        return Optional.ofNullable(this.remoteExceptionHierarchy);
    }
}

