/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.driver;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.tinkerpop.gremlin.driver.Result;
import org.javatuples.Pair;

final class ResultQueue {
    private final LinkedBlockingQueue<Result> resultLinkedBlockingQueue;
    private final AtomicReference<Throwable> error = new AtomicReference();
    private final CompletableFuture<Void> readComplete;
    private final Queue<Pair<CompletableFuture<List<Result>>, Integer>> waiting = new ConcurrentLinkedQueue<Pair<CompletableFuture<List<Result>>, Integer>>();

    public ResultQueue(LinkedBlockingQueue<Result> resultLinkedBlockingQueue, CompletableFuture<Void> readComplete) {
        this.resultLinkedBlockingQueue = resultLinkedBlockingQueue;
        this.readComplete = readComplete;
    }

    public void add(Result result) {
        this.resultLinkedBlockingQueue.offer(result);
        this.tryDrainNextWaiting(false);
    }

    public CompletableFuture<List<Result>> await(int items) {
        CompletableFuture<List<Result>> result = new CompletableFuture<List<Result>>();
        this.waiting.add((Pair<CompletableFuture<List<Result>>, Integer>)Pair.with(result, (Object)items));
        this.tryDrainNextWaiting(false);
        return result;
    }

    public int size() {
        if (this.error.get() != null) {
            throw new RuntimeException(this.error.get());
        }
        return this.resultLinkedBlockingQueue.size();
    }

    public boolean isEmpty() {
        if (this.error.get() != null) {
            throw new RuntimeException(this.error.get());
        }
        return this.size() == 0;
    }

    void drainTo(Collection<Result> collection) {
        if (this.error.get() != null) {
            throw new RuntimeException(this.error.get());
        }
        this.resultLinkedBlockingQueue.drainTo(collection);
    }

    void markComplete() {
        this.readComplete.complete(null);
        this.drainAllWaiting();
    }

    void markError(Throwable throwable) {
        this.error.set(throwable);
        this.readComplete.completeExceptionally(throwable);
        this.drainAllWaiting();
    }

    private synchronized void tryDrainNextWaiting(boolean force) {
        Pair<CompletableFuture<List<Result>>, Integer> nextWaiting = this.waiting.peek();
        if (nextWaiting != null && (force || this.resultLinkedBlockingQueue.size() >= (Integer)nextWaiting.getValue1() || this.readComplete.isDone())) {
            int items = (Integer)nextWaiting.getValue1();
            CompletableFuture future = (CompletableFuture)nextWaiting.getValue0();
            ArrayList results = new ArrayList(items);
            this.resultLinkedBlockingQueue.drainTo(results, items);
            if (null == this.error.get()) {
                future.complete(results);
            } else {
                future.completeExceptionally(this.error.get());
            }
            this.waiting.remove(nextWaiting);
        }
    }

    private void drainAllWaiting() {
        while (!this.waiting.isEmpty()) {
            this.tryDrainNextWaiting(true);
        }
    }
}

