/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tiles.velocity.renderer;

import java.io.IOException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletContext;
import org.apache.tiles.Attribute;
import org.apache.tiles.TilesApplicationContext;
import org.apache.tiles.context.TilesRequestContext;
import org.apache.tiles.impl.InvalidTemplateException;
import org.apache.tiles.renderer.impl.AbstractBaseAttributeRenderer;
import org.apache.tiles.servlet.context.ServletTilesRequestContext;
import org.apache.tiles.servlet.context.ServletUtil;
import org.apache.tiles.util.IteratorEnumeration;
import org.apache.velocity.Template;
import org.apache.velocity.context.Context;
import org.apache.velocity.tools.view.JeeConfig;
import org.apache.velocity.tools.view.VelocityView;
import org.apache.velocity.tools.view.ViewToolContext;

public class VelocityAttributeRenderer
extends AbstractBaseAttributeRenderer {
    private VelocityView velocityView;
    private Map<String, String> params = new HashMap<String, String>();

    public void setParameter(String key, String value) {
        this.params.put(key, value);
    }

    public void commit() {
        this.velocityView = new VelocityView((JeeConfig)new TilesApplicationContextJeeConfig());
    }

    public void write(Object value, Attribute attribute, TilesRequestContext request) throws IOException {
        if (value != null) {
            if (!(value instanceof String)) {
                throw new InvalidTemplateException("Cannot render a template that is not a string: " + value.toString());
            }
        } else {
            throw new InvalidTemplateException("Cannot render a null template");
        }
        ServletTilesRequestContext servletRequest = ServletUtil.getServletRequest((TilesRequestContext)request);
        ViewToolContext context = this.velocityView.createContext(servletRequest.getRequest(), servletRequest.getResponse());
        Template template = this.velocityView.getTemplate((String)value);
        this.velocityView.merge(template, (Context)context, request.getWriter());
    }

    private class TilesApplicationContextJeeConfig
    implements JeeConfig {
        private TilesApplicationContextJeeConfig() {
        }

        public String getInitParameter(String name) {
            return (String)VelocityAttributeRenderer.this.params.get(name);
        }

        public String findInitParameter(String key) {
            return (String)VelocityAttributeRenderer.this.params.get(key);
        }

        public Enumeration getInitParameterNames() {
            return new IteratorEnumeration(VelocityAttributeRenderer.this.params.keySet().iterator());
        }

        public String getName() {
            return "Tiles Application Context JEE Config";
        }

        public ServletContext getServletContext() {
            return ServletUtil.getServletContext((TilesApplicationContext)VelocityAttributeRenderer.this.applicationContext);
        }
    }
}

