/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.xmp;

import com.adobe.internal.xmp.XMPDateTime;
import com.adobe.internal.xmp.XMPException;
import com.adobe.internal.xmp.XMPIterator;
import com.adobe.internal.xmp.XMPMeta;
import com.adobe.internal.xmp.XMPMetaFactory;
import com.adobe.internal.xmp.XMPSchemaRegistry;
import com.adobe.internal.xmp.XMPUtils;
import com.adobe.internal.xmp.options.IteratorOptions;
import com.adobe.internal.xmp.options.PropertyOptions;
import com.adobe.internal.xmp.options.SerializeOptions;
import com.adobe.internal.xmp.properties.XMPProperty;
import java.io.IOException;
import java.io.NotSerializableException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import org.apache.tika.exception.TikaException;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.metadata.Property;
import org.apache.tika.metadata.PropertyTypeException;
import org.apache.tika.xmp.convert.TikaToXMP;

public class XMPMetadata
extends Metadata {
    private static final XMPSchemaRegistry registry = XMPMetaFactory.getSchemaRegistry();
    private XMPMeta xmpData;

    public XMPMetadata() {
        this.xmpData = XMPMetaFactory.create();
    }

    public XMPMetadata(Metadata meta) throws TikaException {
        this.xmpData = TikaToXMP.convert(meta);
    }

    public XMPMetadata(Metadata meta, String mimetype) throws TikaException {
        this.xmpData = TikaToXMP.convert(meta, mimetype);
    }

    public static String registerNamespace(String namespaceURI, String suggestedPrefix) throws XMPException {
        return registry.registerNamespace(namespaceURI, suggestedPrefix);
    }

    public static String getNamespacePrefix(String namespaceURI) {
        return registry.getNamespacePrefix(namespaceURI);
    }

    public static String getNamespaceURI(String namespacePrefix) {
        return registry.getNamespaceURI(namespacePrefix);
    }

    public static Map<String, String> getNamespaces() {
        return registry.getNamespaces();
    }

    public static Map<String, String> getPrefixes() {
        return registry.getPrefixes();
    }

    public static void deleteNamespace(String namespaceURI) {
        registry.deleteNamespace(namespaceURI);
    }

    public void process(Metadata meta) throws TikaException {
        this.xmpData = TikaToXMP.convert(meta);
    }

    public void process(Metadata meta, String mimetype) throws TikaException {
        this.xmpData = TikaToXMP.convert(meta, mimetype);
    }

    public XMPMeta getXMPData() {
        return this.xmpData;
    }

    public boolean isMultiValued(Property property) {
        return this.isMultiValued(property.getName());
    }

    public boolean isMultiValued(String name) {
        this.checkKey(name);
        String[] keyParts = this.splitKey(name);
        String ns = registry.getNamespaceURI(keyParts[0]);
        if (ns != null) {
            try {
                XMPProperty prop = this.xmpData.getProperty(ns, keyParts[1]);
                return prop.getOptions().isArray();
            }
            catch (XMPException xMPException) {
                // empty catch block
            }
        }
        return false;
    }

    public String[] names() {
        throw new UnsupportedOperationException("Not implemented");
    }

    public String get(String name) {
        this.checkKey(name);
        String value = null;
        String[] keyParts = this.splitKey(name);
        String ns = registry.getNamespaceURI(keyParts[0]);
        if (ns != null) {
            try {
                XMPProperty prop = this.xmpData.getProperty(ns, keyParts[1]);
                if (prop != null && prop.getOptions().isSimple()) {
                    value = prop.getValue();
                } else if (prop != null && prop.getOptions().isArray()) {
                    prop = this.xmpData.getArrayItem(ns, keyParts[1], 1);
                    value = prop.getValue();
                }
            }
            catch (XMPException xMPException) {
                // empty catch block
            }
        }
        return value;
    }

    public String get(Property property) {
        return this.get(property.getName());
    }

    public Integer getInt(Property property) {
        Integer result = null;
        try {
            result = XMPUtils.convertToInteger((String)this.get(property.getName()));
        }
        catch (XMPException xMPException) {
            // empty catch block
        }
        return result;
    }

    public Date getDate(Property property) {
        Date result = null;
        try {
            XMPDateTime xmpDate = XMPUtils.convertToDate((String)this.get(property.getName()));
            if (xmpDate != null) {
                Calendar cal = xmpDate.getCalendar();
                result = cal.getTime();
            }
        }
        catch (XMPException xMPException) {
            // empty catch block
        }
        return result;
    }

    public String[] getValues(Property property) {
        return this.getValues(property.getName());
    }

    public String[] getValues(String name) {
        this.checkKey(name);
        String[] value = null;
        String[] keyParts = this.splitKey(name);
        String ns = registry.getNamespaceURI(keyParts[0]);
        if (ns != null) {
            try {
                XMPProperty prop = this.xmpData.getProperty(ns, keyParts[1]);
                if (prop != null && prop.getOptions().isSimple()) {
                    value = new String[]{prop.getValue()};
                } else if (prop != null && prop.getOptions().isArray()) {
                    int size = this.xmpData.countArrayItems(ns, keyParts[1]);
                    value = new String[size];
                    boolean onlySimpleChildren = true;
                    for (int i = 0; i < size && onlySimpleChildren; ++i) {
                        prop = this.xmpData.getArrayItem(ns, keyParts[1], i + 1);
                        if (prop.getOptions().isSimple()) {
                            value[i] = prop.getValue();
                            continue;
                        }
                        onlySimpleChildren = false;
                    }
                    if (!onlySimpleChildren) {
                        value = null;
                    }
                }
            }
            catch (XMPException xMPException) {
                // empty catch block
            }
        }
        return value;
    }

    public void add(String name, String value) {
        this.set(name, value);
    }

    public void set(String name, String value) {
        this.checkKey(name);
        String[] keyParts = this.splitKey(name);
        String ns = registry.getNamespaceURI(keyParts[0]);
        if (ns != null) {
            try {
                this.xmpData.setProperty(ns, keyParts[1], (Object)value);
            }
            catch (XMPException xMPException) {
                // empty catch block
            }
        }
    }

    public void set(Property property, String value) {
        this.set(property.getName(), value);
    }

    public void set(Property property, int value) {
        super.set(property, value);
    }

    public void set(Property property, double value) {
        super.set(property, value);
    }

    public void set(Property property, Date date) {
        super.set(property, date);
    }

    public void set(Property property, String[] values) {
        this.checkKey(property.getName());
        if (!property.isMultiValuePermitted()) {
            throw new PropertyTypeException("Property is not of an array type");
        }
        String[] keyParts = this.splitKey(property.getName());
        String ns = registry.getNamespaceURI(keyParts[0]);
        if (ns != null) {
            try {
                int arrayType = this.tikaToXMPArrayType(property.getPrimaryProperty().getPropertyType());
                this.xmpData.setProperty(ns, keyParts[1], null, new PropertyOptions(arrayType));
                for (String value : values) {
                    this.xmpData.appendArrayItem(ns, keyParts[1], value);
                }
            }
            catch (XMPException xMPException) {
                // empty catch block
            }
        }
    }

    public void setAll(Properties properties) {
        Enumeration<?> names = properties.propertyNames();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            Property property = Property.get((String)name);
            if (property == null) {
                throw new PropertyTypeException("Unknown property: " + name);
            }
            String value = properties.getProperty(name);
            if (property.isMultiValuePermitted()) {
                this.set(property, new String[]{value});
                continue;
            }
            this.set(property, value);
        }
    }

    public void remove(Property property) {
        this.remove(property.getName());
    }

    public void remove(String name) {
        this.checkKey(name);
        String[] keyParts = this.splitKey(name);
        String ns = registry.getNamespaceURI(keyParts[0]);
        if (ns != null) {
            this.xmpData.deleteProperty(ns, keyParts[1]);
        }
    }

    public int size() {
        int size = 0;
        try {
            XMPIterator nsIter = this.xmpData.iterator(new IteratorOptions().setJustChildren(true).setOmitQualifiers(true));
            while (nsIter.hasNext()) {
                nsIter.next();
                ++size;
            }
        }
        catch (XMPException xMPException) {
            // empty catch block
        }
        return size;
    }

    public boolean equals(Object o) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.xmpData);
    }

    public String toString() {
        String result = null;
        try {
            result = XMPMetaFactory.serializeToString((XMPMeta)this.xmpData, (SerializeOptions)new SerializeOptions().setOmitPacketWrapper(true).setUseCompactFormat(true));
        }
        catch (XMPException xMPException) {
            // empty catch block
        }
        return result;
    }

    private void readObject(ObjectInputStream ois) throws ClassNotFoundException, IOException {
        throw new NotSerializableException();
    }

    private void writeObject(ObjectOutputStream ois) throws IOException {
        throw new NotSerializableException();
    }

    private void checkKey(String key) throws PropertyTypeException {
        if (key == null || key.isEmpty()) {
            throw new PropertyTypeException("Key must not be null");
        }
        String[] keyParts = this.splitKey(key);
        if (keyParts == null) {
            throw new PropertyTypeException("Key must be a QName in the form prefix:localName");
        }
        if (registry.getNamespaceURI(keyParts[0]) == null) {
            throw new PropertyTypeException("Key does not use a registered Namespace prefix");
        }
    }

    private String[] splitKey(String key) {
        String[] keyParts = key.split(":");
        if (keyParts.length > 0 && keyParts.length <= 2) {
            return keyParts;
        }
        return null;
    }

    private int tikaToXMPArrayType(Property.PropertyType type) {
        int result = 0;
        switch (type) {
            case BAG: {
                result = 512;
                break;
            }
            case SEQ: {
                result = 1024;
                break;
            }
            case ALT: {
                result = 2048;
            }
        }
        return result;
    }
}

