/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.language.translate.impl;

import com.memetix.mst.language.Language;
import com.memetix.mst.translate.Translate;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.apache.tika.exception.TikaException;
import org.apache.tika.language.translate.Translator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MicrosoftTranslator
implements Translator {
    public static final String PROPERTIES_FILE = "translator.microsoft.properties";
    public static final String ID_PROPERTY = "translator.client-id";
    public static final String SECRET_PROPERTY = "translator.client-secret";
    public static final String DEFAULT_ID = "dummy-id";
    public static final String DEFAULT_SECRET = "dummy-secret";
    private static final Logger LOG = LoggerFactory.getLogger(MicrosoftTranslator.class);
    boolean available;
    String clientId;
    String clientSecret;

    public MicrosoftTranslator() {
        Properties props = new Properties();
        InputStream stream = MicrosoftTranslator.class.getResourceAsStream(PROPERTIES_FILE);
        try {
            if (stream != null) {
                props.load(stream);
                this.clientId = props.getProperty(ID_PROPERTY);
                this.clientSecret = props.getProperty(SECRET_PROPERTY);
                this.available = this.checkAvailable();
            }
        }
        catch (IOException e) {
            LOG.warn("Error loading props file", (Throwable)e);
            this.available = false;
        }
    }

    public String translate(String text, String sourceLanguage, String targetLanguage) throws TikaException, IOException {
        if (!this.available) {
            return text;
        }
        Language source = Language.fromString((String)sourceLanguage);
        Language target = Language.fromString((String)targetLanguage);
        Translate.setClientId((String)this.clientId);
        Translate.setClientSecret((String)this.clientSecret);
        try {
            return Translate.execute((String)text, (Language)source, (Language)target);
        }
        catch (Exception e) {
            throw new TikaException("Error with Microsoft Translation: " + e.getMessage());
        }
    }

    public String translate(String text, String targetLanguage) throws TikaException, IOException {
        if (!this.available) {
            return text;
        }
        Language target = Language.fromString((String)targetLanguage);
        Translate.setClientId((String)this.clientId);
        Translate.setClientSecret((String)this.clientSecret);
        try {
            return Translate.execute((String)text, (Language)target);
        }
        catch (Exception e) {
            throw new TikaException("Error with Microsoft Translation: " + e.getMessage());
        }
    }

    public boolean isAvailable() {
        return this.available;
    }

    public void setId(String id) {
        this.clientId = id;
        this.available = this.checkAvailable();
    }

    public void setSecret(String secret) {
        this.clientSecret = secret;
        this.available = this.checkAvailable();
    }

    private boolean checkAvailable() {
        return this.clientId != null && !this.clientId.equals(DEFAULT_ID) && this.clientSecret != null && !this.clientSecret.equals(DEFAULT_SECRET);
    }
}

