/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.transcribe.aws;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import org.apache.tika.config.Field;
import org.apache.tika.config.Initializable;
import org.apache.tika.config.InitializableProblemHandler;
import org.apache.tika.config.Param;
import org.apache.tika.exception.TikaConfigException;
import org.apache.tika.exception.TikaException;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.mime.MediaType;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.Parser;
import org.apache.tika.sax.XHTMLContentHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import software.amazon.awssdk.auth.credentials.AwsBasicCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.StaticCredentialsProvider;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.ResponseInputStream;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.sync.RequestBody;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.s3.S3Client;
import software.amazon.awssdk.services.s3.S3ClientBuilder;
import software.amazon.awssdk.services.s3.model.CreateBucketRequest;
import software.amazon.awssdk.services.s3.model.DeleteObjectRequest;
import software.amazon.awssdk.services.s3.model.GetObjectRequest;
import software.amazon.awssdk.services.s3.model.GetUrlRequest;
import software.amazon.awssdk.services.s3.model.HeadBucketRequest;
import software.amazon.awssdk.services.s3.model.NoSuchBucketException;
import software.amazon.awssdk.services.s3.model.PutObjectRequest;
import software.amazon.awssdk.services.s3.model.PutObjectResponse;
import software.amazon.awssdk.services.s3.model.S3Exception;
import software.amazon.awssdk.services.sts.StsClient;
import software.amazon.awssdk.services.sts.StsClientBuilder;
import software.amazon.awssdk.services.sts.model.GetCallerIdentityRequest;
import software.amazon.awssdk.services.sts.model.GetCallerIdentityResponse;
import software.amazon.awssdk.services.transcribe.TranscribeAsyncClient;
import software.amazon.awssdk.services.transcribe.TranscribeAsyncClientBuilder;
import software.amazon.awssdk.services.transcribe.model.GetTranscriptionJobRequest;
import software.amazon.awssdk.services.transcribe.model.GetTranscriptionJobResponse;
import software.amazon.awssdk.services.transcribe.model.LanguageCode;
import software.amazon.awssdk.services.transcribe.model.Media;
import software.amazon.awssdk.services.transcribe.model.StartTranscriptionJobRequest;
import software.amazon.awssdk.services.transcribe.model.TranscriptionJob;
import software.amazon.awssdk.services.transcribe.model.TranscriptionJobStatus;

public class AmazonTranscribe
implements Parser,
Initializable {
    private static final Logger LOG = LoggerFactory.getLogger(AmazonTranscribe.class);
    private TranscribeAsyncClient amazonTranscribeAsync;
    private S3Client amazonS3;
    private String bucketName;
    private String region;
    private boolean isAvailable;
    private String clientId;
    private String clientSecret;
    private StaticCredentialsProvider credsProvider;
    protected static final Set<MediaType> SUPPORTED_TYPES = Collections.unmodifiableSet(new HashSet<MediaType>(Arrays.asList(MediaType.audio((String)"x-flac"), MediaType.audio((String)"mp3"), MediaType.audio((String)"mpeg"), MediaType.video((String)"ogg"), MediaType.audio((String)"vnd.wave"), MediaType.audio((String)"mp4"), MediaType.video((String)"mp4"), MediaType.application((String)"mp4"), MediaType.video((String)"quicktime"))));

    public Set<MediaType> getSupportedTypes(ParseContext context) {
        if (!this.isAvailable) {
            return Collections.EMPTY_SET;
        }
        return SUPPORTED_TYPES;
    }

    public void parse(InputStream stream, ContentHandler handler, Metadata metadata, ParseContext context) throws IOException, SAXException, TikaException {
        if (!this.isAvailable) {
            return;
        }
        if (this.amazonS3 == null) {
            return;
        }
        String jobName = this.getJobKey();
        LanguageCode languageCode = (LanguageCode)context.get(LanguageCode.class);
        this.uploadFileToBucket(stream, jobName);
        StartTranscriptionJobRequest startTranscriptionJobRequest = (StartTranscriptionJobRequest)StartTranscriptionJobRequest.builder().build();
        Media media = (Media)Media.builder().mediaFileUri(this.amazonS3.utilities().getUrl((GetUrlRequest)GetUrlRequest.builder().bucket(this.bucketName).key(jobName).build()).toString()).build();
        startTranscriptionJobRequest = (StartTranscriptionJobRequest)startTranscriptionJobRequest.toBuilder().media(media).outputBucketName(this.bucketName).transcriptionJobName(jobName).build();
        startTranscriptionJobRequest = languageCode != null ? (StartTranscriptionJobRequest)startTranscriptionJobRequest.toBuilder().languageCode(languageCode).build() : (StartTranscriptionJobRequest)startTranscriptionJobRequest.toBuilder().identifyLanguage(Boolean.valueOf(true)).build();
        this.amazonTranscribeAsync.startTranscriptionJob(startTranscriptionJobRequest);
        XHTMLContentHandler xhtml = new XHTMLContentHandler(handler, metadata);
        xhtml.startDocument();
        String text = this.getTranscriptText(jobName);
        xhtml.startElement("p");
        xhtml.characters(text);
        xhtml.endElement("p");
        xhtml.endDocument();
        this.deleteFilesFromBucket(jobName);
    }

    public boolean isAvailable() {
        return this.isAvailable;
    }

    @Field
    public void setClientId(String id) {
        this.clientId = id;
        this.isAvailable = this.checkAvailable();
    }

    @Field
    public void setClientSecret(String secret) {
        this.clientSecret = secret;
        this.isAvailable = this.checkAvailable();
    }

    @Field
    public void setBucket(String bucket) {
        this.bucketName = bucket;
        this.isAvailable = this.checkAvailable();
    }

    @Field
    public void setRegion(String region) {
        this.region = region;
        this.isAvailable = this.checkAvailable();
    }

    private boolean checkAvailable() {
        return this.clientId != null && this.clientSecret != null && this.bucketName != null;
    }

    private String getJobKey() {
        return UUID.randomUUID().toString();
    }

    private void uploadFileToBucket(InputStream inputStream, String jobName) throws TikaException {
        PutObjectRequest request = (PutObjectRequest)PutObjectRequest.builder().bucket(this.bucketName).key(jobName).build();
        try {
            PutObjectResponse putObjectResponse = this.amazonS3.putObject(request, RequestBody.fromInputStream((InputStream)inputStream, (long)inputStream.available()));
        }
        catch (IOException | SdkClientException e) {
            throw new TikaException("File upload to AWS failed: " + e.getMessage(), e);
        }
    }

    private void deleteFilesFromBucket(String jobName) throws TikaException {
        try {
            this.amazonS3.deleteObject((DeleteObjectRequest)DeleteObjectRequest.builder().bucket(this.bucketName).key(jobName).build());
            this.amazonS3.deleteObject((DeleteObjectRequest)DeleteObjectRequest.builder().bucket(this.bucketName).key(jobName + ".json").build());
        }
        catch (SdkClientException e) {
            LOG.error("Failed to delete {} and/or {} from {}", new Object[]{jobName, jobName + ".json", this.bucketName, e});
        }
    }

    private String getTranscriptText(String fileNameS3) throws AwsServiceException, SdkClientException, IOException {
        TranscriptionJob transcriptionJob = this.retrieveObjectWhenJobCompleted(fileNameS3);
        String text = "";
        if (transcriptionJob != null && !TranscriptionJobStatus.FAILED.equals((Object)transcriptionJob.transcriptionJobStatus())) {
            ResponseInputStream s3Object;
            try (ResponseInputStream responseInputStream = s3Object = this.amazonS3.getObject((GetObjectRequest)GetObjectRequest.builder().bucket(this.bucketName).key(fileNameS3 + ".json").build());){
                ObjectMapper mapper = new ObjectMapper();
                JsonNode root = mapper.readTree((InputStream)s3Object);
                text = root.path("results").path("transcripts").get(0).path("transcript").asText();
            }
        }
        return text;
    }

    private TranscriptionJob retrieveObjectWhenJobCompleted(String jobName) {
        GetTranscriptionJobRequest transcriptionJobRequest = (GetTranscriptionJobRequest)GetTranscriptionJobRequest.builder().transcriptionJobName(jobName).build();
        CompletableFuture transcriptionJob;
        GetTranscriptionJobResponse transcriptionJobResponse;
        TranscriptionJobStatus status;
        while (!TranscriptionJobStatus.COMPLETED.equals((Object)(status = (transcriptionJobResponse = (GetTranscriptionJobResponse)(transcriptionJob = this.amazonTranscribeAsync.getTranscriptionJob(transcriptionJobRequest)).join()).transcriptionJob().transcriptionJobStatus())) && !TranscriptionJobStatus.FAILED.equals((Object)status)) {
            try {
                Thread.sleep(1000L);
                continue;
            }
            catch (InterruptedException ex) {
                LOG.warn("interrupted");
                continue;
            }
            break;
        }
        return transcriptionJobResponse.transcriptionJob();
    }

    public void initialize(Map<String, Param> params) throws TikaConfigException {
        if (!this.checkAvailable()) {
            return;
        }
        try {
            AwsBasicCredentials creds = AwsBasicCredentials.create((String)this.clientId, (String)this.clientSecret);
            this.credsProvider = StaticCredentialsProvider.create((AwsCredentials)creds);
            if (this.region != null) {
                this.amazonS3 = (S3Client)((S3ClientBuilder)((S3ClientBuilder)S3Client.builder().credentialsProvider((AwsCredentialsProvider)this.credsProvider)).region(Region.of((String)this.region))).build();
            } else {
                this.amazonS3 = (S3Client)((S3ClientBuilder)S3Client.builder().credentialsProvider((AwsCredentialsProvider)this.credsProvider)).build();
                this.region = this.amazonS3.serviceClientConfiguration().region().id();
            }
            StsClient stsClient = (StsClient)((StsClientBuilder)((StsClientBuilder)StsClient.builder().credentialsProvider((AwsCredentialsProvider)this.credsProvider)).region(Region.of((String)this.region))).build();
            GetCallerIdentityResponse identity = stsClient.getCallerIdentity((GetCallerIdentityRequest)GetCallerIdentityRequest.builder().build());
            LOG.debug("Authenticated as: {}", (Object)identity.arn());
            if (!this.doesBucketExistV2(this.amazonS3, this.bucketName)) {
                try {
                    this.amazonS3.createBucket((CreateBucketRequest)CreateBucketRequest.builder().bucket(this.bucketName).build());
                }
                catch (S3Exception e) {
                    throw new TikaConfigException("couldn't create bucket", (Throwable)e);
                }
            }
            this.amazonTranscribeAsync = (TranscribeAsyncClient)((TranscribeAsyncClientBuilder)((TranscribeAsyncClientBuilder)TranscribeAsyncClient.builder().credentialsProvider((AwsCredentialsProvider)this.credsProvider)).region(Region.of((String)this.region))).build();
        }
        catch (Exception e) {
            LOG.warn("Exception reading config file", (Throwable)e);
            this.isAvailable = false;
        }
    }

    public void checkInitialization(InitializableProblemHandler problemHandler) throws TikaConfigException {
        this.isAvailable = this.checkAvailable();
    }

    private boolean doesBucketExistV2(S3Client s3, String bucketName) {
        try {
            s3.headBucket((HeadBucketRequest)HeadBucketRequest.builder().bucket(bucketName).build());
            return true;
        }
        catch (NoSuchBucketException e) {
            return false;
        }
        catch (S3Exception e) {
            if (e.statusCode() == 403) {
                return true;
            }
            throw e;
        }
    }
}

