/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.eval.core.tokens;

import java.util.Arrays;
import org.apache.commons.math3.stat.descriptive.SummaryStatistics;
import org.apache.tika.eval.core.tokens.TokenIntPair;

public class TokenStatistics {
    private final int totalTokens;
    private final int totalUniqueTokens;
    private final TokenIntPair[] topN;
    private final double entropy;
    private final SummaryStatistics summaryStatistics;

    public TokenStatistics(int totalUniqueTokens, int totalTokens, TokenIntPair[] topN, double entropy, SummaryStatistics summaryStatistics) {
        this.totalUniqueTokens = totalUniqueTokens;
        this.totalTokens = totalTokens;
        this.topN = topN;
        this.entropy = entropy;
        this.summaryStatistics = summaryStatistics;
    }

    private static boolean doubleEquals(double a, double b) {
        return TokenStatistics.doubleEquals(a, b, 1.0E-12);
    }

    private static boolean doubleEquals(double a, double b, double epsilon) {
        return a == b || Math.abs(a - b) < epsilon;
    }

    public int getTotalTokens() {
        return this.totalTokens;
    }

    public int getTotalUniqueTokens() {
        return this.totalUniqueTokens;
    }

    public TokenIntPair[] getTopN() {
        return this.topN;
    }

    public double getEntropy() {
        return this.entropy;
    }

    public SummaryStatistics getSummaryStatistics() {
        return this.summaryStatistics;
    }

    public String toString() {
        return "TokenStatistics{totalTokens=" + this.totalTokens + ", totalUniqueTokens=" + this.totalUniqueTokens + ", topN=" + Arrays.toString(this.topN) + ", entropy=" + this.entropy + ", summaryStatistics=" + this.summaryStatistics + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TokenStatistics that = (TokenStatistics)o;
        if (this.totalTokens != that.totalTokens) {
            return false;
        }
        if (this.totalUniqueTokens != that.totalUniqueTokens) {
            return false;
        }
        if (!TokenStatistics.doubleEquals(that.entropy, this.entropy)) {
            return false;
        }
        if (!Arrays.equals(this.topN, that.topN)) {
            return false;
        }
        SummaryStatistics thatS = ((TokenStatistics)o).summaryStatistics;
        if (this.summaryStatistics.getN() != thatS.getN()) {
            return false;
        }
        if (this.summaryStatistics.getN() == 0L) {
            return true;
        }
        if (!TokenStatistics.doubleEquals(this.summaryStatistics.getGeometricMean(), thatS.getGeometricMean())) {
            return false;
        }
        if (!TokenStatistics.doubleEquals(this.summaryStatistics.getMax(), thatS.getMax())) {
            return false;
        }
        if (!TokenStatistics.doubleEquals(this.summaryStatistics.getMean(), thatS.getMean())) {
            return false;
        }
        if (!TokenStatistics.doubleEquals(this.summaryStatistics.getMin(), thatS.getMin())) {
            return false;
        }
        if (!TokenStatistics.doubleEquals(this.summaryStatistics.getSum(), thatS.getSum())) {
            return false;
        }
        return TokenStatistics.doubleEquals(this.summaryStatistics.getStandardDeviation(), thatS.getStandardDeviation());
    }

    public int hashCode() {
        int result = this.totalTokens ^ this.totalTokens >>> 32;
        result = 31 * result + (this.totalUniqueTokens ^ this.totalUniqueTokens >>> 32);
        result = 31 * result + Arrays.hashCode(this.topN);
        long temp = Double.doubleToLongBits(this.entropy);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        result = 31 * result + this.summaryStatistics.hashCode();
        return result;
    }
}

