/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.server.client;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.util.EntityUtils;
import org.apache.tika.client.HttpClientFactory;
import org.apache.tika.exception.TikaConfigException;
import org.apache.tika.exception.TikaException;
import org.apache.tika.server.client.TikaEmitterResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class TikaPipesHttpClient {
    private static final String TIKA_ENDPOINT = "tika";
    private static final Logger LOGGER = LoggerFactory.getLogger(TikaPipesHttpClient.class);
    private final String endPoint = "pipes";
    private final HttpClientFactory httpClientFactory;
    private HttpClient httpClient;
    private final String endPointUrl;
    private final String tikaUrl;
    private final int maxRetries = 3;
    private final long maxWaitForTikaMs = 120000L;
    private final long pulseWaitForTikaMs = 1000L;

    TikaPipesHttpClient(String baseUrl, HttpClientFactory httpClientFactory) throws TikaConfigException {
        if (!baseUrl.endsWith("/")) {
            baseUrl = baseUrl + "/";
        }
        this.endPointUrl = baseUrl + this.getEndpoint();
        this.tikaUrl = baseUrl + TIKA_ENDPOINT;
        this.httpClientFactory = httpClientFactory;
        this.httpClient = this.getNewClient(baseUrl);
    }

    String getEndpoint() {
        return "pipes";
    }

    private HttpClient getNewClient(String baseUrl) throws TikaConfigException {
        if (this.httpClient instanceof CloseableHttpClient) {
            try {
                ((CloseableHttpClient)this.httpClient).close();
            }
            catch (IOException e) {
                LOGGER.warn("exception closing client", e);
            }
        }
        return this.httpClientFactory.build();
    }

    public TikaEmitterResult postJson(String jsonRequest) {
        return this.postJson(this.endPointUrl, jsonRequest);
    }

    private TikaEmitterResult postJson(String endPoint, String jsonRequest) {
        HttpPost post = new HttpPost(endPoint);
        post.setEntity(new StringEntity(jsonRequest, StandardCharsets.UTF_8));
        post.setHeader("Content-Type", "application/json");
        int tries = 0;
        long start = System.currentTimeMillis();
        try {
            while (tries++ < 3) {
                HttpResponse response = null;
                try {
                    response = this.httpClient.execute(post);
                }
                catch (IOException e) {
                    LOGGER.warn("Exception trying to parse", e);
                    this.waitForServer();
                    continue;
                }
                String msg = "";
                try {
                    msg = EntityUtils.toString(response.getEntity(), StandardCharsets.UTF_8);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                long elapsed = System.currentTimeMillis() - start;
                TikaEmitterResult.STATUS status = TikaEmitterResult.STATUS.OK;
                if (response.getStatusLine().getStatusCode() != 200) {
                    status = TikaEmitterResult.STATUS.NOT_OK;
                }
                return new TikaEmitterResult(status, elapsed, msg);
            }
        }
        catch (TimeoutWaitingForTikaException e) {
            long elapsed = System.currentTimeMillis() - start;
            return new TikaEmitterResult(TikaEmitterResult.STATUS.TIMED_OUT_WAITING_FOR_TIKA, elapsed, "");
        }
        long elapsed = System.currentTimeMillis() - start;
        return new TikaEmitterResult(TikaEmitterResult.STATUS.EXCEEDED_MAX_RETRIES, elapsed, "");
    }

    private void waitForServer() throws TimeoutWaitingForTikaException {
        long start = System.currentTimeMillis();
        long elapsed = System.currentTimeMillis() - start;
        LOGGER.info("server unreachable; waiting for it to restart");
        while (elapsed < 120000L) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            HttpGet get = new HttpGet(this.tikaUrl);
            try {
                HttpResponse response = this.httpClient.execute(get);
                if (response.getStatusLine().getStatusCode() == 200) {
                    LOGGER.debug("server back up");
                    return;
                }
            }
            catch (IOException e) {
                elapsed = System.currentTimeMillis() - start;
                LOGGER.debug("waiting for server; failed to reach it: {} ms", (Object)elapsed);
            }
            elapsed = System.currentTimeMillis() - start;
        }
        LOGGER.warn("Timeout waiting for tika server {} in {} ms", (Object)this.tikaUrl, (Object)elapsed);
        throw new TimeoutWaitingForTikaException("");
    }

    static class TimeoutWaitingForTikaException
    extends TikaException {
        public TimeoutWaitingForTikaException(String msg) {
            super(msg);
        }
    }
}

