/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.serialization;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.StreamReadConstraints;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.input.CloseShieldReader;
import org.apache.commons.io.output.CloseShieldWriter;
import org.apache.tika.config.TikaConfig;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.metadata.TikaCoreProperties;
import org.apache.tika.serialization.JsonMetadata;

public class JsonMetadataList {
    static volatile boolean PRETTY_PRINT = false;

    public static void toJson(List<Metadata> metadataList, Writer writer, boolean prettyPrint) throws IOException {
        if (metadataList == null) {
            writer.write("null");
            return;
        }
        try (JsonGenerator jsonGenerator = new JsonFactory().setStreamReadConstraints(StreamReadConstraints.builder().maxStringLength(TikaConfig.getMaxJsonStringFieldLength()).build()).createGenerator((Writer)CloseShieldWriter.wrap((Writer)writer));){
            if (prettyPrint) {
                jsonGenerator.useDefaultPrettyPrinter();
            }
            jsonGenerator.writeStartArray();
            for (Metadata m : metadataList) {
                JsonMetadata.writeMetadataObject(m, jsonGenerator, prettyPrint);
            }
            jsonGenerator.writeEndArray();
        }
    }

    public static void toJson(List<Metadata> metadataList, Writer writer) throws IOException {
        JsonMetadataList.toJson(metadataList, writer, PRETTY_PRINT);
    }

    public static List<Metadata> fromJson(Reader reader) throws IOException {
        Metadata last;
        String embResourcePath;
        ArrayList<Metadata> ms = null;
        if (reader == null) {
            return ms;
        }
        ms = new ArrayList<Metadata>();
        try (JsonParser jParser = new JsonFactory().setStreamReadConstraints(StreamReadConstraints.builder().maxStringLength(TikaConfig.getMaxJsonStringFieldLength()).build()).createParser((Reader)CloseShieldReader.wrap((Reader)reader));){
            JsonToken token = jParser.nextToken();
            if (token != JsonToken.START_ARRAY) {
                throw new IOException("metadata list must start with an array, but I see: " + token.name());
            }
            token = jParser.nextToken();
            while (token != JsonToken.END_ARRAY) {
                Metadata m = JsonMetadata.readMetadataObject(jParser);
                ms.add(m);
                token = jParser.nextToken();
            }
        }
        if (ms == null) {
            return null;
        }
        if (ms.size() > 1 && (embResourcePath = (last = (Metadata)ms.get(ms.size() - 1)).get(TikaCoreProperties.EMBEDDED_RESOURCE_PATH)) == null && ((Metadata)ms.get(0)).get(TikaCoreProperties.EMBEDDED_RESOURCE_PATH) != null) {
            ms.add(0, (Metadata)ms.remove(ms.size() - 1));
        }
        return ms;
    }

    public static void setPrettyPrinting(boolean prettyPrint) {
        PRETTY_PRINT = prettyPrint;
    }
}

