/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.serialization;

import com.fasterxml.jackson.databind.JsonNode;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.tika.serialization.TikaJsonSerializer;

public class TikaJsonDeserializer {
    public static Optional deserializeObject(JsonNode root) {
        if (!root.isObject()) {
            throw new IllegalArgumentException("root needs to be an object");
        }
        if (!root.has(TikaJsonSerializer.INSTANTIATED_CLASS_KEY)) {
            throw new IllegalArgumentException("need to specify: " + TikaJsonSerializer.INSTANTIATED_CLASS_KEY);
        }
        String className = root.get(TikaJsonSerializer.INSTANTIATED_CLASS_KEY).asText();
        try {
            return Optional.of(TikaJsonDeserializer.deserialize(Class.forName(className), root));
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static <T> T deserialize(Class<? extends T> clazz, JsonNode root) throws ReflectiveOperationException {
        T obj = clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        Map<String, List<Method>> setters = TikaJsonDeserializer.getSetters(obj);
        if (!root.isObject()) {
            throw new IllegalArgumentException("must be object");
        }
        Iterator fields = root.fields();
        while (fields.hasNext()) {
            Map.Entry e = (Map.Entry)fields.next();
            String name = (String)e.getKey();
            JsonNode child = (JsonNode)e.getValue();
            if (TikaJsonSerializer.INSTANTIATED_CLASS_KEY.equals(name)) continue;
            TikaJsonDeserializer.setValue(name, child, obj, setters);
        }
        return obj;
    }

    private static Map<String, List<Method>> getSetters(Object obj) {
        HashMap<String, List<Method>> setters = new HashMap<String, List<Method>>();
        for (Method m : obj.getClass().getMethods()) {
            String n = m.getName();
            if (!n.startsWith(TikaJsonSerializer.SET) || n.length() <= 3 || !Character.isUpperCase(n.charAt(3)) || m.getParameters().length != 1) continue;
            String paramName = TikaJsonSerializer.getParam(TikaJsonSerializer.SET, n);
            ArrayList<Method> methods = (ArrayList<Method>)setters.get(paramName);
            if (methods == null) {
                methods = new ArrayList<Method>();
                setters.put(paramName, methods);
            }
            methods.add(m);
        }
        return setters;
    }

    private static void setValue(String name, JsonNode node, Object obj, Map<String, List<Method>> setters) throws ReflectiveOperationException {
        List<Method> mySetters = setters.get(name);
        if (mySetters == null || mySetters.size() == 0) {
            throw new IllegalArgumentException("can't find any setter for " + name);
        }
        if (node.isNull()) {
            TikaJsonDeserializer.setNull(name, node, obj, mySetters);
        } else if (node.isNumber()) {
            TikaJsonDeserializer.setNumericValue(name, node, obj, mySetters);
        } else if (node.isTextual()) {
            TikaJsonDeserializer.setStringValue(name, node.asText(), obj, mySetters);
        } else if (node.isArray()) {
            TikaJsonDeserializer.setArray(name, node, obj, mySetters);
        } else if (node.isObject()) {
            TikaJsonDeserializer.setObject(name, node, obj, mySetters);
        } else if (node.isBoolean()) {
            TikaJsonDeserializer.setBoolean(name, node, obj, mySetters);
        }
    }

    private static void setArray(String name, JsonNode node, Object obj, List<Method> mySetters) {
        for (Method setter : mySetters) {
            try {
                TikaJsonDeserializer.tryArray(name, node, obj, setter);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new IllegalArgumentException("couldn't create array for " + name);
            }
        }
    }

    private static void tryArray(String name, JsonNode node, Object obj, Method setter) throws InvocationTargetException, IllegalAccessException {
        Class<?> argClass = setter.getParameterTypes()[0];
        Class<?> componentType = argClass.getComponentType();
        if (argClass.isArray()) {
            int len = node.size();
            Object arrayObject = Array.newInstance(componentType, len);
            for (int i = 0; i < len; ++i) {
                Array.set(arrayObject, i, TikaJsonDeserializer.getVal(componentType, node.get(i)));
            }
            setter.invoke(obj, arrayObject);
        } else if (List.class.isAssignableFrom(argClass)) {
            Type listType = setter.getGenericParameterTypes()[0];
            Type elementType = null;
            if (listType instanceof ParameterizedType) {
                elementType = ((ParameterizedType)listType).getActualTypeArguments()[0];
            }
            if (elementType == null) {
                throw new IllegalArgumentException("Can't infer parameterized type for list in: " + node);
            }
            int len = node.size();
            ArrayList<Type> list = new ArrayList<Type>();
            for (int i = 0; i < len; ++i) {
                list.add(TikaJsonDeserializer.getVal(elementType, node.get(i)));
            }
            setter.invoke(obj, list);
        }
    }

    private static <T> T getVal(T clazz, JsonNode node) {
        if (clazz.equals(String.class)) {
            return (T)node.asText();
        }
        if (clazz.equals(Integer.class) || clazz.equals(Integer.TYPE)) {
            return (T)Integer.valueOf(node.intValue());
        }
        if (clazz.equals(Long.class) || clazz.equals(Long.TYPE)) {
            return (T)Long.valueOf(node.longValue());
        }
        if (clazz.equals(Float.class) || clazz.equals(Float.TYPE)) {
            return (T)Float.valueOf(node.floatValue());
        }
        if (clazz.equals(Double.class) || clazz.equals(Double.TYPE)) {
            return (T)Double.valueOf(node.doubleValue());
        }
        if (node.isObject()) {
            if (node.has(TikaJsonSerializer.INSTANTIATED_CLASS_KEY)) {
                Optional optional = TikaJsonDeserializer.deserializeObject(node);
                if (optional.isPresent()) {
                    return optional.get();
                }
            } else {
                throw new IllegalArgumentException("I see a json object, but I don't see " + TikaJsonSerializer.INSTANTIATED_CLASS_KEY + ": " + node);
            }
        }
        throw new IllegalArgumentException("I regret I don't yet support: " + clazz);
    }

    private static void setObject(String name, JsonNode node, Object obj, List<Method> mySetters) {
        if (!node.has(TikaJsonSerializer.INSTANTIATED_CLASS_KEY)) {
            TikaJsonDeserializer.setMap(name, node, obj, mySetters);
            return;
        }
        Optional object = TikaJsonDeserializer.deserializeObject(node);
        if (object.isEmpty()) {
            return;
        }
        for (Method m : mySetters) {
            Class<?> argClass = m.getParameters()[0].getType();
            if (!argClass.isAssignableFrom(object.get().getClass())) continue;
            try {
                m.invoke(obj, object.get());
                return;
            }
            catch (IllegalAccessException | InvocationTargetException reflectiveOperationException) {
            }
        }
        throw new IllegalArgumentException("can't set object on " + name);
    }

    private static void setMap(String name, JsonNode node, Object obj, List<Method> setters) {
        HashMap<String, String> val = new HashMap<String, String>();
        Iterator it = node.fields();
        while (it.hasNext()) {
            Map.Entry e = (Map.Entry)it.next();
            val.put((String)e.getKey(), ((JsonNode)e.getValue()).textValue());
        }
        for (Method m : setters) {
            try {
                m.invoke(obj, val);
                return;
            }
            catch (ReflectiveOperationException reflectiveOperationException) {
            }
        }
        throw new IllegalArgumentException("can't find map setter for: " + name);
    }

    private static void setBoolean(String name, JsonNode node, Object obj, List<Method> setters) throws ReflectiveOperationException {
        for (Method m : setters) {
            Class<?> argClass = m.getParameters()[0].getType();
            if (!argClass.equals(Boolean.class) && !argClass.equals(Boolean.TYPE)) continue;
            m.invoke(obj, node.booleanValue());
            return;
        }
        throw new IllegalArgumentException("can't set boolean on " + name);
    }

    private static void setNull(String name, JsonNode node, Object obj, List<Method> setters) {
        for (Method m : setters) {
            Class<?> argClass = m.getParameters()[0].getType();
            if (TikaJsonSerializer.PRIMITIVES.contains(argClass)) continue;
            try {
                m.invoke(obj, argClass.cast(null));
                return;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        throw new IllegalArgumentException("can't set null on " + name);
    }

    private static void setStringValue(String name, String txt, Object obj, List<Method> setters) throws ReflectiveOperationException {
        for (Method m : setters) {
            Class<?> argClass = m.getParameters()[0].getType();
            if (!argClass.equals(String.class)) continue;
            m.invoke(obj, txt);
            return;
        }
        Method intMethod = null;
        Method longMethod = null;
        Method doubleMethod = null;
        Method floatMethod = null;
        Method shortMethod = null;
        Method boolMethod = null;
        for (Method m : setters) {
            Class<?> argClass = m.getParameters()[0].getType();
            if (argClass.equals(Integer.class) || argClass.equals(Integer.TYPE)) {
                intMethod = m;
                continue;
            }
            if (argClass.equals(Long.class) || argClass.equals(Long.TYPE)) {
                longMethod = m;
                continue;
            }
            if (argClass.equals(Float.class) || argClass.equals(Float.TYPE)) {
                floatMethod = m;
                continue;
            }
            if (argClass.equals(Double.class) || argClass.equals(Double.TYPE)) {
                doubleMethod = m;
                continue;
            }
            if (argClass.equals(Short.class) || argClass.equals(Short.TYPE)) {
                shortMethod = m;
                continue;
            }
            if (!argClass.equals(Boolean.class) && !argClass.equals(Boolean.TYPE)) continue;
            boolMethod = m;
        }
        if (shortMethod != null) {
            try {
                short val = Short.parseShort(txt);
                shortMethod.invoke(obj, val);
                return;
            }
            catch (NumberFormatException val) {}
        } else if (intMethod != null) {
            try {
                int val = Integer.parseInt(txt);
                intMethod.invoke(obj, val);
                return;
            }
            catch (NumberFormatException val) {}
        } else if (floatMethod != null) {
            try {
                float val = Float.parseFloat(txt);
                floatMethod.invoke(obj, Float.valueOf(val));
                return;
            }
            catch (NumberFormatException val) {}
        } else if (longMethod != null) {
            try {
                long val = Long.parseLong(txt);
                longMethod.invoke(obj, val);
                return;
            }
            catch (NumberFormatException val) {}
        } else if (doubleMethod != null) {
            try {
                double val = Double.parseDouble(txt);
                doubleMethod.invoke(obj, val);
                return;
            }
            catch (NumberFormatException numberFormatException) {}
        } else if (boolMethod != null) {
            if (txt.equalsIgnoreCase("true")) {
                boolMethod.invoke(obj, true);
            } else if (txt.equalsIgnoreCase("false")) {
                boolMethod.invoke(obj, false);
            }
        }
        throw new IllegalArgumentException("I regret I couldn't find a setter for: " + name);
    }

    private static void setNumericValue(String name, JsonNode node, Object obj, List<Method> setters) throws ReflectiveOperationException {
        Class<?> argClass;
        for (Method m : setters) {
            argClass = m.getParameters()[0].getType();
            if ((argClass.equals(Integer.TYPE) || argClass.equals(Integer.class)) && node.isInt()) {
                m.invoke(obj, node.intValue());
                return;
            }
            if ((argClass.equals(Long.TYPE) || argClass.equals(Long.class)) && node.isLong()) {
                m.invoke(obj, node.asLong());
                return;
            }
            if ((argClass.equals(Float.TYPE) || argClass.equals(Float.class)) && node.isFloat()) {
                m.invoke(obj, Float.valueOf(node.floatValue()));
                return;
            }
            if ((argClass.equals(Double.TYPE) || argClass.equals(Double.class)) && node.isDouble()) {
                m.invoke(obj, node.doubleValue());
                return;
            }
            if (!argClass.equals(Short.TYPE) && !argClass.equals(Short.class) || !node.isShort()) continue;
            m.invoke(obj, node.shortValue());
            return;
        }
        for (Method m : setters) {
            argClass = m.getParameters()[0].getType();
            if ((argClass.equals(Long.TYPE) || argClass.equals(Long.class)) && node.isInt()) {
                m.invoke(obj, node.asLong());
                return;
            }
            if (!argClass.equals(Double.TYPE) && !argClass.equals(Double.class) || !node.isFloat()) continue;
            m.invoke(obj, Float.valueOf(node.floatValue()));
            return;
        }
        for (Method m : setters) {
            int val;
            argClass = m.getParameters()[0].getType();
            if ((argClass.equals(Integer.TYPE) || argClass.equals(Integer.class)) && node.isLong()) {
                long val2 = node.longValue();
                if (val2 < Integer.MAX_VALUE && val2 > Integer.MIN_VALUE) {
                    m.invoke(obj, node.intValue());
                }
                return;
            }
            if ((argClass.equals(Float.TYPE) || argClass.equals(Float.class)) && node.isDouble()) {
                m.invoke(obj, Float.valueOf(node.floatValue()));
                return;
            }
            if (!argClass.equals(Short.TYPE) && !argClass.equals(Short.class) || !node.isInt() || (val = node.intValue()) > Short.MAX_VALUE || val < Short.MIN_VALUE) continue;
            m.invoke(obj, node.shortValue());
            return;
        }
        for (Method m : setters) {
            argClass = m.getParameters()[0].getType();
            if (!argClass.equals(String.class)) continue;
            m.invoke(obj, node.asText());
            return;
        }
        throw new IllegalArgumentException("Couldn't find numeric setter for: " + name);
    }
}

