/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.server.quorum;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import javax.security.sasl.SaslException;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.common.Time;
import org.apache.zookeeper.jmx.MBeanRegistry;
import org.apache.zookeeper.server.ExitCode;
import org.apache.zookeeper.server.FinalRequestProcessor;
import org.apache.zookeeper.server.Request;
import org.apache.zookeeper.server.RequestProcessor;
import org.apache.zookeeper.server.ServerMetrics;
import org.apache.zookeeper.server.ZKDatabase;
import org.apache.zookeeper.server.ZooKeeperCriticalThread;
import org.apache.zookeeper.server.ZooTrace;
import org.apache.zookeeper.server.quorum.BufferStats;
import org.apache.zookeeper.server.quorum.LeaderBean;
import org.apache.zookeeper.server.quorum.LeaderZooKeeperServer;
import org.apache.zookeeper.server.quorum.LearnerHandler;
import org.apache.zookeeper.server.quorum.LearnerHandlerBean;
import org.apache.zookeeper.server.quorum.LearnerMaster;
import org.apache.zookeeper.server.quorum.LearnerSyncRequest;
import org.apache.zookeeper.server.quorum.QuorumPacket;
import org.apache.zookeeper.server.quorum.QuorumPeer;
import org.apache.zookeeper.server.quorum.StateSummary;
import org.apache.zookeeper.server.quorum.SyncedLearnerTracker;
import org.apache.zookeeper.server.quorum.UnifiedServerSocket;
import org.apache.zookeeper.server.quorum.auth.QuorumAuthServer;
import org.apache.zookeeper.server.quorum.flexible.QuorumVerifier;
import org.apache.zookeeper.server.util.SerializeUtils;
import org.apache.zookeeper.server.util.ZxidUtils;
import org.apache.zookeeper.util.ServiceUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Leader
extends LearnerMaster {
    private static final Logger LOG = LoggerFactory.getLogger(Leader.class);
    private static final boolean nodelay = System.getProperty("leader.nodelay", "true").equals("true");
    private static final String ACK_LOGGING_FREQUENCY = "zookeeper.leader.ackLoggingFrequency";
    private static int ackLoggingFrequency;
    final LeaderZooKeeperServer zk;
    final QuorumPeer self;
    protected boolean quorumFormed = false;
    volatile LearnerCnxAcceptor cnxAcceptor = null;
    private final HashSet<LearnerHandler> learners = new HashSet();
    private final BufferStats proposalStats;
    private final ConcurrentHashMap<LearnerHandler, LearnerHandlerBean> connectionBeans = new ConcurrentHashMap();
    private final HashSet<LearnerHandler> forwardingFollowers = new HashSet();
    private final HashSet<LearnerHandler> observingLearners = new HashSet();
    private final Map<Long, List<LearnerSyncRequest>> pendingSyncs = new HashMap<Long, List<LearnerSyncRequest>>();
    final AtomicLong followerCounter = new AtomicLong(-1L);
    private final List<ServerSocket> serverSockets = new LinkedList<ServerSocket>();
    static final int DIFF = 13;
    static final int TRUNC = 14;
    static final int SNAP = 15;
    static final int OBSERVERINFO = 16;
    static final int NEWLEADER = 10;
    static final int FOLLOWERINFO = 11;
    static final int UPTODATE = 12;
    public static final int LEADERINFO = 17;
    public static final int ACKEPOCH = 18;
    static final int REQUEST = 1;
    public static final int PROPOSAL = 2;
    static final int ACK = 3;
    static final int COMMIT = 4;
    static final int PING = 5;
    static final int REVALIDATE = 6;
    static final int SYNC = 7;
    static final int INFORM = 8;
    static final int COMMITANDACTIVATE = 9;
    static final int INFORMANDACTIVATE = 19;
    final ConcurrentMap<Long, Proposal> outstandingProposals = new ConcurrentHashMap<Long, Proposal>();
    private final ConcurrentLinkedQueue<Proposal> toBeApplied = new ConcurrentLinkedQueue();
    protected final Proposal newLeaderProposal = new Proposal();
    StateSummary leaderStateSummary;
    long epoch = -1L;
    boolean waitingForNewEpoch = true;
    boolean allowedToCommit = true;
    private long leaderStartTime;
    boolean isShutdown;
    long lastCommitted = -1L;
    long lastProposed;
    protected final Set<Long> connectingFollowers = new HashSet<Long>();
    private volatile boolean quitWaitForEpoch = false;
    private volatile long timeStartWaitForEpoch = -1L;
    private volatile SyncedLearnerTracker voteSet;
    public static final String MAX_TIME_TO_WAIT_FOR_EPOCH = "zookeeper.leader.maxTimeToWaitForEpoch";
    private static int maxTimeToWaitForEpoch;
    protected final Set<Long> electingFollowers = new HashSet<Long>();
    protected boolean electionFinished = false;

    public static void setAckLoggingFrequency(int frequency) {
        ackLoggingFrequency = frequency;
    }

    public static int getAckLoggingFrequency() {
        return ackLoggingFrequency;
    }

    public BufferStats getProposalStats() {
        return this.proposalStats;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<LearnerHandler> getLearners() {
        HashSet<LearnerHandler> hashSet = this.learners;
        synchronized (hashSet) {
            return new ArrayList<LearnerHandler>(this.learners);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<LearnerHandler> getForwardingFollowers() {
        HashSet<LearnerHandler> hashSet = this.forwardingFollowers;
        synchronized (hashSet) {
            return new ArrayList<LearnerHandler>(this.forwardingFollowers);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<LearnerHandler> getNonVotingFollowers() {
        ArrayList<LearnerHandler> nonVotingFollowers = new ArrayList<LearnerHandler>();
        HashSet<LearnerHandler> hashSet = this.forwardingFollowers;
        synchronized (hashSet) {
            for (LearnerHandler lh : this.forwardingFollowers) {
                if (this.isParticipant(lh.getSid())) continue;
                nonVotingFollowers.add(lh);
            }
        }
        return nonVotingFollowers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addForwardingFollower(LearnerHandler lh) {
        HashSet<LearnerHandler> hashSet = this.forwardingFollowers;
        synchronized (hashSet) {
            this.forwardingFollowers.add(lh);
            this.self.getQuorumVerifier().updateNeedOracle(new ArrayList<LearnerHandler>(this.forwardingFollowers));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<LearnerHandler> getObservingLearners() {
        HashSet<LearnerHandler> hashSet = this.observingLearners;
        synchronized (hashSet) {
            return new ArrayList<LearnerHandler>(this.observingLearners);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addObserverLearnerHandler(LearnerHandler lh) {
        HashSet<LearnerHandler> hashSet = this.observingLearners;
        synchronized (hashSet) {
            this.observingLearners.add(lh);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterable<Map<String, Object>> getObservingLearnersInfo() {
        HashSet<Map<String, Object>> info = new HashSet<Map<String, Object>>();
        HashSet<LearnerHandler> hashSet = this.observingLearners;
        synchronized (hashSet) {
            for (LearnerHandler lh : this.observingLearners) {
                info.add(lh.getLearnerHandlerInfo());
            }
        }
        return info;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetObserverConnectionStats() {
        HashSet<LearnerHandler> hashSet = this.observingLearners;
        synchronized (hashSet) {
            for (LearnerHandler lh : this.observingLearners) {
                lh.resetObserverConnectionStats();
            }
        }
    }

    public synchronized int getNumPendingSyncs() {
        return this.pendingSyncs.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addLearnerHandler(LearnerHandler learner) {
        HashSet<LearnerHandler> hashSet = this.learners;
        synchronized (hashSet) {
            this.learners.add(learner);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeLearnerHandler(LearnerHandler peer) {
        HashSet<LearnerHandler> hashSet = this.forwardingFollowers;
        synchronized (hashSet) {
            this.forwardingFollowers.remove(peer);
        }
        hashSet = this.learners;
        synchronized (hashSet) {
            this.learners.remove(peer);
        }
        hashSet = this.observingLearners;
        synchronized (hashSet) {
            this.observingLearners.remove(peer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isLearnerSynced(LearnerHandler peer) {
        HashSet<LearnerHandler> hashSet = this.forwardingFollowers;
        synchronized (hashSet) {
            return this.forwardingFollowers.contains(peer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isQuorumSynced(QuorumVerifier qv) {
        HashSet<Long> ids = new HashSet<Long>();
        if (qv.getVotingMembers().containsKey(this.self.getMyId())) {
            ids.add(this.self.getMyId());
        }
        HashSet<LearnerHandler> hashSet = this.forwardingFollowers;
        synchronized (hashSet) {
            for (LearnerHandler learnerHandler : this.forwardingFollowers) {
                if (!learnerHandler.synced() || !qv.getVotingMembers().containsKey(learnerHandler.getSid())) continue;
                ids.add(learnerHandler.getSid());
            }
        }
        return qv.containsQuorum(ids);
    }

    public Leader(QuorumPeer self, LeaderZooKeeperServer zk) throws IOException {
        this.self = self;
        this.proposalStats = new BufferStats();
        Set<InetSocketAddress> addresses = self.getQuorumListenOnAllIPs() ? self.getQuorumAddress().getWildcardAddresses() : self.getQuorumAddress().getAllAddresses();
        addresses.stream().map(address -> this.createServerSocket((InetSocketAddress)address, self.shouldUsePortUnification(), self.isSslQuorum())).filter(Optional::isPresent).map(Optional::get).forEach(this.serverSockets::add);
        if (this.serverSockets.isEmpty()) {
            throw new IOException("Leader failed to initialize any of the following sockets: " + addresses);
        }
        this.zk = zk;
    }

    InetSocketAddress recreateInetSocketAddr(String hostString, int port) {
        return new InetSocketAddress(hostString, port);
    }

    Optional<ServerSocket> createServerSocket(InetSocketAddress address, boolean portUnification, boolean sslQuorum) {
        try {
            ServerSocket serverSocket = portUnification || sslQuorum ? new UnifiedServerSocket(this.self.getX509Util(), portUnification) : new ServerSocket();
            serverSocket.setReuseAddress(true);
            serverSocket.bind(this.recreateInetSocketAddr(address.getHostString(), address.getPort()));
            return Optional.of(serverSocket);
        }
        catch (IOException e) {
            LOG.error("Couldn't bind to {}", (Object)address.toString(), (Object)e);
            return Optional.empty();
        }
    }

    public long getUptime() {
        if (this.leaderStartTime > 0L) {
            return Time.currentElapsedTime() - this.leaderStartTime;
        }
        return 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void lead() throws IOException, InterruptedException {
        this.self.end_fle = Time.currentElapsedTime();
        long electionTimeTaken = this.self.end_fle - this.self.start_fle;
        this.self.setElectionTimeTaken(electionTimeTaken);
        ServerMetrics.getMetrics().ELECTION_TIME.add(electionTimeTaken);
        LOG.info("LEADING - LEADER ELECTION TOOK - {} {}", (Object)electionTimeTaken, (Object)"MS");
        this.self.start_fle = 0L;
        this.self.end_fle = 0L;
        this.zk.registerJMX(new LeaderBean(this, this.zk), this.self.jmxLocalPeerBean);
        try {
            this.self.setZabState(QuorumPeer.ZabState.DISCOVERY);
            this.self.tick.set(0);
            this.zk.loadData();
            this.leaderStateSummary = new StateSummary(this.self.getCurrentEpoch(), this.zk.getLastProcessedZxid());
            this.cnxAcceptor = new LearnerCnxAcceptor();
            this.cnxAcceptor.start();
            long epoch = this.getEpochToPropose(this.self.getMyId(), this.self.getAcceptedEpoch());
            this.zk.setZxid(ZxidUtils.makeZxid(epoch, 0L));
            Leader leader = this;
            synchronized (leader) {
                this.lastProposed = this.zk.getZxid();
            }
            this.newLeaderProposal.packet = new QuorumPacket(10, this.zk.getZxid(), null, null);
            if ((this.newLeaderProposal.packet.getZxid() & 0xFFFFFFFFL) != 0L) {
                LOG.info("NEWLEADER proposal has Zxid of {}", (Object)Long.toHexString(this.newLeaderProposal.packet.getZxid()));
            }
            QuorumVerifier lastSeenQV = this.self.getLastSeenQuorumVerifier();
            QuorumVerifier curQV = this.self.getQuorumVerifier();
            if (curQV.getVersion() == 0L && curQV.getVersion() == lastSeenQV.getVersion()) {
                try {
                    LOG.debug(String.format("set lastSeenQuorumVerifier to currentQuorumVerifier (%s)", curQV.toString()));
                    QuorumVerifier newQV = this.self.configFromString(curQV.toString());
                    newQV.setVersion(this.zk.getZxid());
                    this.self.setLastSeenQuorumVerifier(newQV, true);
                }
                catch (Exception e) {
                    throw new IOException(e);
                }
            }
            this.newLeaderProposal.addQuorumVerifier(this.self.getQuorumVerifier());
            if (this.self.getLastSeenQuorumVerifier().getVersion() > this.self.getQuorumVerifier().getVersion()) {
                this.newLeaderProposal.addQuorumVerifier(this.self.getLastSeenQuorumVerifier());
            }
            this.waitForEpochAck(this.self.getMyId(), this.leaderStateSummary);
            this.self.setCurrentEpoch(epoch);
            this.self.setLeaderAddressAndId(this.self.getQuorumAddress(), this.self.getMyId());
            this.self.setZabState(QuorumPeer.ZabState.SYNCHRONIZATION);
            try {
                this.waitForNewLeaderAck(this.self.getMyId(), this.zk.getZxid());
            }
            catch (InterruptedException e) {
                this.shutdown("Waiting for a quorum of followers, only synced with sids: [ " + this.newLeaderProposal.ackSetsToString() + " ]");
                HashSet<Long> followerSet = new HashSet<Long>();
                for (LearnerHandler f : this.getLearners()) {
                    if (!this.self.getQuorumVerifier().getVotingMembers().containsKey(f.getSid())) continue;
                    followerSet.add(f.getSid());
                }
                boolean initTicksShouldBeIncreased = true;
                for (SyncedLearnerTracker.QuorumVerifierAcksetPair qvAckset : this.newLeaderProposal.qvAcksetPairs) {
                    if (qvAckset.getQuorumVerifier().containsQuorum(followerSet)) continue;
                    initTicksShouldBeIncreased = false;
                    break;
                }
                if (initTicksShouldBeIncreased) {
                    LOG.warn("Enough followers present. Perhaps the initTicks need to be increased.");
                }
                this.zk.unregisterJMX(this);
                return;
            }
            this.startZkServer();
            String initialZxid = System.getProperty("zookeeper.testingonly.initialZxid");
            if (initialZxid != null) {
                long zxid = Long.parseLong(initialZxid);
                this.zk.setZxid(this.zk.getZxid() & 0xFFFFFFFF00000000L | zxid);
            }
            if (!System.getProperty("zookeeper.leaderServes", "yes").equals("no")) {
                this.self.setZooKeeperServer(this.zk);
            }
            this.self.setZabState(QuorumPeer.ZabState.BROADCAST);
            this.self.adminServer.setZooKeeperServer(this.zk);
            boolean tickSkip = true;
            String shutdownMessage = null;
            block16: while (true) {
                Object object = this;
                synchronized (object) {
                    long start;
                    long cur = start = Time.currentElapsedTime();
                    long end = start + (long)(this.self.tickTime / 2);
                    while (cur < end) {
                        this.wait(end - cur);
                        cur = Time.currentElapsedTime();
                    }
                    if (!tickSkip) {
                        this.self.tick.incrementAndGet();
                    }
                    SyncedLearnerTracker syncedAckSet = new SyncedLearnerTracker();
                    syncedAckSet.addQuorumVerifier(this.self.getQuorumVerifier());
                    if (this.self.getLastSeenQuorumVerifier() != null && this.self.getLastSeenQuorumVerifier().getVersion() > this.self.getQuorumVerifier().getVersion()) {
                        syncedAckSet.addQuorumVerifier(this.self.getLastSeenQuorumVerifier());
                    }
                    syncedAckSet.addAck(this.self.getMyId());
                    for (LearnerHandler f : this.getLearners()) {
                        if (!f.synced()) continue;
                        syncedAckSet.addAck(f.getSid());
                    }
                    if (!this.isRunning()) {
                        shutdownMessage = "Unexpected internal error";
                        break;
                    }
                    if (!(tickSkip || syncedAckSet.hasAllQuorums() || this.self.getQuorumVerifier().overrideQuorumDecision(this.getForwardingFollowers()) && this.self.getQuorumVerifier().revalidateOutstandingProp(this, new ArrayList<Proposal>(this.outstandingProposals.values()), this.lastCommitted))) {
                        shutdownMessage = "Not sufficient followers synced, only synced with sids: [ " + syncedAckSet.ackSetsToString() + " ]";
                        break;
                    }
                    tickSkip = !tickSkip;
                }
                object = this.getLearners().iterator();
                while (true) {
                    if (!object.hasNext()) continue block16;
                    LearnerHandler f = (LearnerHandler)object.next();
                    f.ping();
                }
                break;
            }
            if (shutdownMessage != null) {
                this.shutdown(shutdownMessage);
            }
        }
        finally {
            this.zk.unregisterJMX(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void shutdown(String reason) {
        LOG.info("Shutting down");
        if (this.isShutdown) {
            return;
        }
        LOG.info("Shutdown called. For the reason {}", (Object)reason);
        if (this.cnxAcceptor != null) {
            this.cnxAcceptor.halt();
        } else {
            this.closeSockets();
        }
        this.self.setZooKeeperServer(null);
        this.self.adminServer.setZooKeeperServer(null);
        this.self.closeAllConnections();
        if (this.zk != null) {
            this.zk.shutdown();
        }
        HashSet<LearnerHandler> hashSet = this.learners;
        synchronized (hashSet) {
            Iterator<LearnerHandler> it = this.learners.iterator();
            while (it.hasNext()) {
                LearnerHandler f = it.next();
                it.remove();
                f.shutdown();
            }
        }
        this.isShutdown = true;
    }

    synchronized void closeSockets() {
        for (ServerSocket serverSocket : this.serverSockets) {
            if (serverSocket.isClosed()) continue;
            try {
                serverSocket.close();
            }
            catch (IOException e) {
                LOG.warn("Ignoring unexpected exception during close {}", (Object)serverSocket, (Object)e);
            }
        }
    }

    private long getDesignatedLeader(Proposal reconfigProposal, long zxid) {
        SyncedLearnerTracker.QuorumVerifierAcksetPair newQVAcksetPair = (SyncedLearnerTracker.QuorumVerifierAcksetPair)reconfigProposal.qvAcksetPairs.get(reconfigProposal.qvAcksetPairs.size() - 1);
        if (newQVAcksetPair.getQuorumVerifier().getVotingMembers().containsKey(this.self.getMyId()) && newQVAcksetPair.getQuorumVerifier().getVotingMembers().get((Object)Long.valueOf((long)this.self.getMyId())).addr.equals(this.self.getQuorumAddress())) {
            return this.self.getMyId();
        }
        HashSet<Long> candidates = new HashSet<Long>(newQVAcksetPair.getAckset());
        candidates.remove(this.self.getMyId());
        long curCandidate = candidates.iterator().next();
        long curZxid = zxid + 1L;
        Proposal p = (Proposal)this.outstandingProposals.get(curZxid);
        while (p != null && !candidates.isEmpty()) {
            for (SyncedLearnerTracker.QuorumVerifierAcksetPair qvAckset : p.qvAcksetPairs) {
                candidates.retainAll(qvAckset.getAckset());
                if (candidates.isEmpty()) {
                    return curCandidate;
                }
                curCandidate = candidates.iterator().next();
                if (candidates.size() != 1) continue;
                return curCandidate;
            }
            p = (Proposal)this.outstandingProposals.get(++curZxid);
        }
        return curCandidate;
    }

    public synchronized boolean tryToCommit(Proposal p, long zxid, SocketAddress followerAddr) {
        if (this.outstandingProposals.containsKey(zxid - 1L)) {
            return false;
        }
        if (!p.hasAllQuorums()) {
            return false;
        }
        if (zxid != this.lastCommitted + 1L) {
            LOG.warn("Commiting zxid 0x{} from {} not first!", (Object)Long.toHexString(zxid), (Object)followerAddr);
            LOG.warn("First is 0x{}", (Object)Long.toHexString(this.lastCommitted + 1L));
        }
        this.outstandingProposals.remove(zxid);
        if (p.request != null) {
            this.toBeApplied.add(p);
        }
        if (p.request == null) {
            LOG.warn("Going to commit null: {}", (Object)p);
        } else if (p.request.getHdr().getType() == 16) {
            LOG.debug("Committing a reconfiguration! {}", (Object)this.outstandingProposals.size());
            Long designatedLeader = this.getDesignatedLeader(p, zxid);
            QuorumVerifier newQV = ((SyncedLearnerTracker.QuorumVerifierAcksetPair)p.qvAcksetPairs.get(p.qvAcksetPairs.size() - 1)).getQuorumVerifier();
            this.self.processReconfig(newQV, designatedLeader, this.zk.getZxid(), true);
            if (designatedLeader.longValue() != this.self.getMyId()) {
                LOG.info(String.format("Committing a reconfiguration (reconfigEnabled=%s); this leader is not the designated leader anymore, setting allowedToCommit=false", this.self.isReconfigEnabled()));
                this.allowedToCommit = false;
            }
            this.commitAndActivate(zxid, designatedLeader);
            this.informAndActivate(p, designatedLeader);
        } else {
            p.request.logLatency(ServerMetrics.getMetrics().QUORUM_ACK_LATENCY);
            this.commit(zxid);
            this.inform(p);
        }
        this.zk.commitProcessor.commit(p.request);
        if (this.pendingSyncs.containsKey(zxid)) {
            for (LearnerSyncRequest r : this.pendingSyncs.remove(zxid)) {
                this.sendSync(r);
            }
        }
        return true;
    }

    @Override
    public synchronized void processAck(long sid, long zxid, SocketAddress followerAddr) {
        if (!this.allowedToCommit) {
            return;
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace("Ack zxid: 0x{}", (Object)Long.toHexString(zxid));
            for (Proposal p : this.outstandingProposals.values()) {
                long packetZxid = p.packet.getZxid();
                LOG.trace("outstanding proposal: 0x{}", (Object)Long.toHexString(packetZxid));
            }
            LOG.trace("outstanding proposals all");
        }
        if ((zxid & 0xFFFFFFFFL) == 0L) {
            return;
        }
        if (this.outstandingProposals.size() == 0) {
            LOG.debug("outstanding is 0");
            return;
        }
        if (this.lastCommitted >= zxid) {
            LOG.debug("proposal has already been committed, pzxid: 0x{} zxid: 0x{}", (Object)Long.toHexString(this.lastCommitted), (Object)Long.toHexString(zxid));
            return;
        }
        Proposal p = (Proposal)this.outstandingProposals.get(zxid);
        if (p == null) {
            LOG.warn("Trying to commit future proposal: zxid 0x{} from {}", (Object)Long.toHexString(zxid), (Object)followerAddr);
            return;
        }
        if (ackLoggingFrequency > 0 && zxid % (long)ackLoggingFrequency == 0L) {
            p.request.logLatency(ServerMetrics.getMetrics().ACK_LATENCY, Long.toString(sid));
        }
        p.addAck(sid);
        boolean hasCommitted = this.tryToCommit(p, zxid, followerAddr);
        if (hasCommitted && p.request != null && p.request.getHdr().getType() == 16) {
            long curZxid = zxid;
            while (this.allowedToCommit && hasCommitted && p != null) {
                if ((p = (Proposal)this.outstandingProposals.get(++curZxid)) == null) continue;
                hasCommitted = this.tryToCommit(p, curZxid, null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void sendPacket(QuorumPacket qp) {
        HashSet<LearnerHandler> hashSet = this.forwardingFollowers;
        synchronized (hashSet) {
            for (LearnerHandler f : this.forwardingFollowers) {
                f.queuePacket(qp);
            }
        }
    }

    void sendObserverPacket(QuorumPacket qp) {
        for (LearnerHandler f : this.getObservingLearners()) {
            f.queuePacket(qp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commit(long zxid) {
        Leader leader = this;
        synchronized (leader) {
            this.lastCommitted = zxid;
        }
        QuorumPacket qp = new QuorumPacket(4, zxid, null, null);
        this.sendPacket(qp);
        ServerMetrics.getMetrics().COMMIT_COUNT.add(1L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commitAndActivate(long zxid, long designatedLeader) {
        Leader leader = this;
        synchronized (leader) {
            this.lastCommitted = zxid;
        }
        byte[] data = new byte[8];
        ByteBuffer buffer = ByteBuffer.wrap(data);
        buffer.putLong(designatedLeader);
        QuorumPacket qp = new QuorumPacket(9, zxid, data, null);
        this.sendPacket(qp);
    }

    public void inform(Proposal proposal) {
        QuorumPacket qp = new QuorumPacket(8, proposal.request.zxid, proposal.packet.getData(), null);
        this.sendObserverPacket(qp);
    }

    public static QuorumPacket buildInformAndActivePacket(long zxid, long designatedLeader, byte[] proposalData) {
        byte[] data = new byte[proposalData.length + 8];
        ByteBuffer buffer = ByteBuffer.wrap(data);
        buffer.putLong(designatedLeader);
        buffer.put(proposalData);
        return new QuorumPacket(19, zxid, data, null);
    }

    public void informAndActivate(Proposal proposal, long designatedLeader) {
        this.sendObserverPacket(Leader.buildInformAndActivePacket(proposal.request.zxid, designatedLeader, proposal.packet.getData()));
    }

    @Override
    public synchronized long getLastProposed() {
        return this.lastProposed;
    }

    public long getEpoch() {
        return ZxidUtils.getEpochFromZxid(this.lastProposed);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Proposal propose(Request request) throws XidRolloverException {
        if (request.isThrottled()) {
            LOG.error("Throttled request send as proposal: {}. Exiting.", (Object)request);
            ServiceUtils.requestSystemExit(ExitCode.UNEXPECTED_ERROR.getValue());
        }
        if ((request.zxid & 0xFFFFFFFFL) == 0xFFFFFFFFL) {
            String msg = "zxid lower 32 bits have rolled over, forcing re-election, and therefore new epoch start";
            this.shutdown(msg);
            throw new XidRolloverException(msg);
        }
        byte[] data = SerializeUtils.serializeRequest(request);
        this.proposalStats.setLastBufferSize(data.length);
        QuorumPacket pp = new QuorumPacket(2, request.zxid, data, null);
        Proposal p = new Proposal();
        p.packet = pp;
        p.request = request;
        Leader leader = this;
        synchronized (leader) {
            p.addQuorumVerifier(this.self.getQuorumVerifier());
            if (request.getHdr().getType() == 16) {
                this.self.setLastSeenQuorumVerifier(request.qv, true);
            }
            if (this.self.getQuorumVerifier().getVersion() < this.self.getLastSeenQuorumVerifier().getVersion()) {
                p.addQuorumVerifier(this.self.getLastSeenQuorumVerifier());
            }
            LOG.debug("Proposing:: {}", (Object)request);
            this.lastProposed = p.packet.getZxid();
            this.outstandingProposals.put(this.lastProposed, p);
            this.sendPacket(pp);
        }
        ServerMetrics.getMetrics().PROPOSAL_COUNT.add(1L);
        return p;
    }

    public synchronized void processSync(LearnerSyncRequest r) {
        if (this.outstandingProposals.isEmpty()) {
            this.sendSync(r);
        } else {
            this.pendingSyncs.computeIfAbsent(this.lastProposed, k -> new ArrayList()).add(r);
        }
    }

    public void sendSync(LearnerSyncRequest r) {
        QuorumPacket qp = new QuorumPacket(7, 0L, null, null);
        r.fh.queuePacket(qp);
    }

    @Override
    public synchronized long startForwarding(LearnerHandler handler, long lastSeenZxid) {
        if (this.lastProposed > lastSeenZxid) {
            for (Proposal p : this.toBeApplied) {
                if (p.packet.getZxid() <= lastSeenZxid) continue;
                handler.queuePacket(p.packet);
                QuorumPacket qp = new QuorumPacket(4, p.packet.getZxid(), null, null);
                handler.queuePacket(qp);
            }
            if (handler.getLearnerType() == QuorumPeer.LearnerType.PARTICIPANT) {
                ArrayList zxids = new ArrayList(this.outstandingProposals.keySet());
                Collections.sort(zxids);
                for (Long zxid : zxids) {
                    if (zxid <= lastSeenZxid) continue;
                    handler.queuePacket(((Proposal)this.outstandingProposals.get((Object)zxid)).packet);
                }
            }
        }
        if (handler.getLearnerType() == QuorumPeer.LearnerType.PARTICIPANT) {
            this.addForwardingFollower(handler);
        } else {
            this.addObserverLearnerHandler(handler);
        }
        return this.lastProposed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void waitForStartup() throws InterruptedException {
        LeaderZooKeeperServer leaderZooKeeperServer = this.zk;
        synchronized (leaderZooKeeperServer) {
            while (!this.zk.isRunning() && !Thread.currentThread().isInterrupted()) {
                this.zk.wait(20L);
            }
        }
    }

    public static void setMaxTimeToWaitForEpoch(int maxTimeToWaitForEpoch) {
        Leader.maxTimeToWaitForEpoch = maxTimeToWaitForEpoch;
        LOG.info("Set {} to {}ms", (Object)MAX_TIME_TO_WAIT_FOR_EPOCH, (Object)Leader.maxTimeToWaitForEpoch);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void quitLeading() {
        Set<Long> set = this.connectingFollowers;
        synchronized (set) {
            this.quitWaitForEpoch = true;
            this.connectingFollowers.notifyAll();
        }
        ServerMetrics.getMetrics().QUIT_LEADING_DUE_TO_DISLOYAL_VOTER.add(1L);
        LOG.info("Quit leading due to voter changed mind.");
    }

    public void setLeadingVoteSet(SyncedLearnerTracker voteSet) {
        this.voteSet = voteSet;
    }

    public void reportLookingSid(long sid) {
        if (maxTimeToWaitForEpoch < 0 || this.timeStartWaitForEpoch < 0L || !this.waitingForNewEpoch) {
            return;
        }
        if (this.voteSet == null || !this.voteSet.hasSid(sid)) {
            return;
        }
        if (Time.currentElapsedTime() - this.timeStartWaitForEpoch > (long)maxTimeToWaitForEpoch) {
            this.quitLeading();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getEpochToPropose(long sid, long lastAcceptedEpoch) throws InterruptedException, IOException {
        Set<Long> set = this.connectingFollowers;
        synchronized (set) {
            if (!this.waitingForNewEpoch) {
                return this.epoch;
            }
            if (lastAcceptedEpoch >= this.epoch) {
                this.epoch = lastAcceptedEpoch + 1L;
            }
            if (this.isParticipant(sid)) {
                this.connectingFollowers.add(sid);
            }
            QuorumVerifier verifier = this.self.getQuorumVerifier();
            if (this.connectingFollowers.contains(this.self.getMyId()) && verifier.containsQuorum(this.connectingFollowers)) {
                this.waitingForNewEpoch = false;
                this.self.setAcceptedEpoch(this.epoch);
                this.connectingFollowers.notifyAll();
            } else {
                long start = Time.currentElapsedTime();
                if (sid == this.self.getMyId()) {
                    this.timeStartWaitForEpoch = start;
                }
                long cur = start;
                long end = start + (long)(this.self.getInitLimit() * this.self.getTickTime());
                while (this.waitingForNewEpoch && cur < end && !this.quitWaitForEpoch) {
                    this.connectingFollowers.wait(end - cur);
                    cur = Time.currentElapsedTime();
                }
                if (this.waitingForNewEpoch) {
                    throw new InterruptedException("Timeout while waiting for epoch from quorum");
                }
            }
            return this.epoch;
        }
    }

    @Override
    public ZKDatabase getZKDatabase() {
        return this.zk.getZKDatabase();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void waitForEpochAck(long id, StateSummary ss) throws IOException, InterruptedException {
        Set<Long> set = this.electingFollowers;
        synchronized (set) {
            if (this.electionFinished) {
                return;
            }
            if (ss.getCurrentEpoch() != -1L) {
                if (ss.isMoreRecentThan(this.leaderStateSummary)) {
                    throw new IOException("Follower is ahead of the leader, leader summary: " + this.leaderStateSummary.getCurrentEpoch() + " (current epoch), " + this.leaderStateSummary.getLastZxid() + " (last zxid)");
                }
                if (ss.getLastZxid() != -1L && this.isParticipant(id)) {
                    this.electingFollowers.add(id);
                }
            }
            QuorumVerifier verifier = this.self.getQuorumVerifier();
            if (this.electingFollowers.contains(this.self.getMyId()) && verifier.containsQuorum(this.electingFollowers)) {
                this.electionFinished = true;
                this.electingFollowers.notifyAll();
            } else {
                long start;
                long cur = start = Time.currentElapsedTime();
                long end = start + (long)(this.self.getInitLimit() * this.self.getTickTime());
                while (!this.electionFinished && cur < end) {
                    this.electingFollowers.wait(end - cur);
                    cur = Time.currentElapsedTime();
                }
                if (!this.electionFinished) {
                    throw new InterruptedException("Timeout while waiting for epoch to be acked by quorum");
                }
            }
        }
    }

    private String getSidSetString(Set<Long> sidSet) {
        StringBuilder sids = new StringBuilder();
        Iterator<Long> iter = sidSet.iterator();
        while (iter.hasNext()) {
            sids.append(iter.next());
            if (!iter.hasNext()) break;
            sids.append(",");
        }
        return sids.toString();
    }

    private synchronized void startZkServer() {
        this.lastCommitted = this.zk.getZxid();
        LOG.info("Have quorum of supporters, sids: [{}]; starting up and setting last processed zxid: 0x{}", (Object)this.newLeaderProposal.ackSetsToString(), (Object)Long.toHexString(this.zk.getZxid()));
        if (this.self.isReconfigEnabled()) {
            QuorumVerifier newQV = this.self.getLastSeenQuorumVerifier();
            Long designatedLeader = this.getDesignatedLeader(this.newLeaderProposal, this.zk.getZxid());
            this.self.processReconfig(newQV, designatedLeader, this.zk.getZxid(), true);
            if (designatedLeader.longValue() != this.self.getMyId()) {
                LOG.warn("This leader is not the designated leader, it will be initialized with allowedToCommit = false");
                this.allowedToCommit = false;
            }
        } else {
            LOG.info("Dynamic reconfig feature is disabled, skip designatedLeader calculation and reconfig processing.");
        }
        this.leaderStartTime = Time.currentElapsedTime();
        this.zk.startup();
        this.self.updateElectionVote(this.getEpoch());
        this.zk.getZKDatabase().setlastProcessedZxid(this.zk.getZxid());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void waitForNewLeaderAck(long sid, long zxid) throws InterruptedException {
        ArrayList arrayList = this.newLeaderProposal.qvAcksetPairs;
        synchronized (arrayList) {
            if (this.quorumFormed) {
                return;
            }
            long currentZxid = this.newLeaderProposal.packet.getZxid();
            if (zxid != currentZxid) {
                LOG.error("NEWLEADER ACK from sid: {} is from a different epoch - current 0x{} received 0x{}", sid, Long.toHexString(currentZxid), Long.toHexString(zxid));
                return;
            }
            this.newLeaderProposal.addAck(sid);
            if (this.newLeaderProposal.hasAllQuorums()) {
                this.quorumFormed = true;
                this.newLeaderProposal.qvAcksetPairs.notifyAll();
            } else {
                long start;
                long cur = start = Time.currentElapsedTime();
                long end = start + (long)(this.self.getInitLimit() * this.self.getTickTime());
                while (!this.quorumFormed && cur < end) {
                    this.newLeaderProposal.qvAcksetPairs.wait(end - cur);
                    cur = Time.currentElapsedTime();
                }
                if (!this.quorumFormed) {
                    throw new InterruptedException("Timeout while waiting for NEWLEADER to be acked by quorum");
                }
            }
        }
    }

    public static String getPacketType(int packetType) {
        switch (packetType) {
            case 13: {
                return "DIFF";
            }
            case 14: {
                return "TRUNC";
            }
            case 15: {
                return "SNAP";
            }
            case 16: {
                return "OBSERVERINFO";
            }
            case 10: {
                return "NEWLEADER";
            }
            case 11: {
                return "FOLLOWERINFO";
            }
            case 12: {
                return "UPTODATE";
            }
            case 17: {
                return "LEADERINFO";
            }
            case 18: {
                return "ACKEPOCH";
            }
            case 1: {
                return "REQUEST";
            }
            case 2: {
                return "PROPOSAL";
            }
            case 3: {
                return "ACK";
            }
            case 4: {
                return "COMMIT";
            }
            case 9: {
                return "COMMITANDACTIVATE";
            }
            case 5: {
                return "PING";
            }
            case 6: {
                return "REVALIDATE";
            }
            case 7: {
                return "SYNC";
            }
            case 8: {
                return "INFORM";
            }
            case 19: {
                return "INFORMANDACTIVATE";
            }
        }
        return "UNKNOWN";
    }

    private boolean isRunning() {
        return this.self.isRunning() && this.zk.isRunning();
    }

    private boolean isParticipant(long sid) {
        return this.self.getQuorumVerifier().getVotingMembers().containsKey(sid);
    }

    @Override
    public int getCurrentTick() {
        return this.self.tick.get();
    }

    @Override
    public int syncTimeout() {
        return this.self.tickTime * this.self.syncLimit;
    }

    @Override
    public int getTickOfNextAckDeadline() {
        return this.self.tick.get() + this.self.syncLimit;
    }

    @Override
    public int getTickOfInitialAckDeadline() {
        return this.self.tick.get() + this.self.initLimit + this.self.syncLimit;
    }

    @Override
    public long getAndDecrementFollowerCounter() {
        return this.followerCounter.getAndDecrement();
    }

    @Override
    public void touch(long sess, int to) {
        this.zk.touch(sess, to);
    }

    @Override
    public void submitLearnerRequest(Request si) {
        this.zk.submitLearnerRequest(si);
    }

    @Override
    public long getQuorumVerifierVersion() {
        return this.self.getQuorumVerifier().getVersion();
    }

    @Override
    public String getPeerInfo(long sid) {
        QuorumPeer.QuorumServer server = this.self.getView().get(sid);
        return server == null ? "" : server.toString();
    }

    @Override
    public byte[] getQuorumVerifierBytes() {
        return this.self.getLastSeenQuorumVerifier().toString().getBytes(StandardCharsets.UTF_8);
    }

    @Override
    public QuorumAuthServer getQuorumAuthServer() {
        return this.self == null ? null : this.self.authServer;
    }

    @Override
    public void revalidateSession(QuorumPacket qp, LearnerHandler learnerHandler) throws IOException {
        ByteArrayInputStream bis = new ByteArrayInputStream(qp.getData());
        DataInputStream dis = new DataInputStream(bis);
        long id = dis.readLong();
        int to = dis.readInt();
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(bos);
        dos.writeLong(id);
        boolean valid = this.zk.checkIfValidGlobalSession(id, to);
        if (valid) {
            try {
                this.zk.setOwner(id, learnerHandler);
            }
            catch (KeeperException.SessionExpiredException e) {
                LOG.error("Somehow session 0x{} expired right after being renewed! (impossible)", (Object)Long.toHexString(id), (Object)e);
            }
        }
        if (LOG.isTraceEnabled()) {
            ZooTrace.logTraceMessage(LOG, 32L, "Session 0x" + Long.toHexString(id) + " is valid: " + valid);
        }
        dos.writeBoolean(valid);
        qp.setData(bos.toByteArray());
        learnerHandler.queuePacket(qp);
    }

    @Override
    public void registerLearnerHandlerBean(LearnerHandler learnerHandler, Socket socket) {
        LearnerHandlerBean bean = new LearnerHandlerBean(learnerHandler, socket);
        if (this.zk.registerJMX(bean)) {
            this.connectionBeans.put(learnerHandler, bean);
        }
    }

    @Override
    public void unregisterLearnerHandlerBean(LearnerHandler learnerHandler) {
        LearnerHandlerBean bean = this.connectionBeans.remove(learnerHandler);
        if (bean != null) {
            MBeanRegistry.getInstance().unregister(bean);
        }
    }

    static {
        LOG.info("TCP NoDelay set to: {}", (Object)nodelay);
        ackLoggingFrequency = Integer.getInteger(ACK_LOGGING_FREQUENCY, 1000);
        LOG.info("{} = {}", (Object)ACK_LOGGING_FREQUENCY, (Object)ackLoggingFrequency);
        maxTimeToWaitForEpoch = Integer.getInteger(MAX_TIME_TO_WAIT_FOR_EPOCH, -1);
        LOG.info("{} = {}ms", (Object)MAX_TIME_TO_WAIT_FOR_EPOCH, (Object)maxTimeToWaitForEpoch);
    }

    public static class XidRolloverException
    extends Exception {
        public XidRolloverException(String message) {
            super(message);
        }
    }

    static class ToBeAppliedRequestProcessor
    implements RequestProcessor {
        private final RequestProcessor next;
        private final Leader leader;

        ToBeAppliedRequestProcessor(RequestProcessor next, Leader leader) {
            if (!(next instanceof FinalRequestProcessor)) {
                throw new RuntimeException(ToBeAppliedRequestProcessor.class.getName() + " must be connected to " + FinalRequestProcessor.class.getName() + " not " + next.getClass().getName());
            }
            this.leader = leader;
            this.next = next;
        }

        @Override
        public void processRequest(Request request) throws RequestProcessor.RequestProcessorException {
            this.next.processRequest(request);
            if (request.getHdr() != null) {
                long zxid = request.getHdr().getZxid();
                Iterator iter = this.leader.toBeApplied.iterator();
                if (iter.hasNext()) {
                    Proposal p = (Proposal)iter.next();
                    if (p.request != null && p.request.zxid == zxid) {
                        iter.remove();
                        return;
                    }
                }
                LOG.error("Committed request not found on toBeApplied: {}", (Object)request);
            }
        }

        @Override
        public void shutdown() {
            LOG.info("Shutting down");
            this.next.shutdown();
        }
    }

    class LearnerCnxAcceptor
    extends ZooKeeperCriticalThread {
        private final AtomicBoolean stop;
        private final AtomicBoolean fail;

        LearnerCnxAcceptor() {
            super("LearnerCnxAcceptor-" + Leader.this.serverSockets.stream().map(ServerSocket::getLocalSocketAddress).map(Objects::toString).collect(Collectors.joining("|")), Leader.this.zk.getZooKeeperServerListener());
            this.stop = new AtomicBoolean(false);
            this.fail = new AtomicBoolean(false);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (!this.stop.get() && !Leader.this.serverSockets.isEmpty()) {
                ExecutorService executor = Executors.newFixedThreadPool(Leader.this.serverSockets.size());
                CountDownLatch latch = new CountDownLatch(Leader.this.serverSockets.size());
                Leader.this.serverSockets.forEach(serverSocket -> executor.submit(new LearnerCnxAcceptorHandler((ServerSocket)serverSocket, latch)));
                try {
                    latch.await();
                }
                catch (InterruptedException ie) {
                    LOG.error("Interrupted while sleeping in LearnerCnxAcceptor.", ie);
                }
                finally {
                    Leader.this.closeSockets();
                    executor.shutdown();
                    try {
                        if (!executor.awaitTermination(1L, TimeUnit.SECONDS)) {
                            LOG.error("not all the LearnerCnxAcceptorHandler terminated properly");
                        }
                    }
                    catch (InterruptedException ie) {
                        LOG.error("Interrupted while terminating LearnerCnxAcceptor.", ie);
                    }
                }
            }
        }

        public void halt() {
            this.stop.set(true);
            Leader.this.closeSockets();
        }

        class LearnerCnxAcceptorHandler
        implements Runnable {
            private ServerSocket serverSocket;
            private CountDownLatch latch;

            LearnerCnxAcceptorHandler(ServerSocket serverSocket, CountDownLatch latch) {
                this.serverSocket = serverSocket;
                this.latch = latch;
            }

            @Override
            public void run() {
                try {
                    Thread.currentThread().setName("LearnerCnxAcceptorHandler-" + this.serverSocket.getLocalSocketAddress());
                    while (!LearnerCnxAcceptor.this.stop.get()) {
                        this.acceptConnections();
                    }
                }
                catch (Exception e) {
                    LOG.warn("Exception while accepting follower", e);
                    if (LearnerCnxAcceptor.this.fail.compareAndSet(false, true)) {
                        LearnerCnxAcceptor.this.handleException(LearnerCnxAcceptor.this.getName(), e);
                        LearnerCnxAcceptor.this.halt();
                    }
                }
                finally {
                    this.latch.countDown();
                }
            }

            private void acceptConnections() throws IOException {
                block19: {
                    Socket socket = null;
                    boolean error = false;
                    try {
                        socket = this.serverSocket.accept();
                        socket.setSoTimeout(Leader.this.self.tickTime * Leader.this.self.initLimit);
                        socket.setTcpNoDelay(nodelay);
                        BufferedInputStream is = new BufferedInputStream(socket.getInputStream());
                        LearnerHandler fh = new LearnerHandler(socket, is, Leader.this);
                        fh.start();
                    }
                    catch (SocketException e) {
                        error = true;
                        if (LearnerCnxAcceptor.this.stop.get()) {
                            LOG.warn("Exception while shutting down acceptor.", e);
                            break block19;
                        }
                        throw e;
                    }
                    catch (SaslException e) {
                        LOG.error("Exception while connecting to quorum learner", e);
                        error = true;
                    }
                    catch (Exception e) {
                        error = true;
                        throw e;
                    }
                    finally {
                        if (error && socket != null && !socket.isClosed()) {
                            try {
                                socket.close();
                            }
                            catch (IOException e) {
                                LOG.warn("Error closing socket: " + socket, e);
                            }
                        }
                    }
                }
            }
        }
    }

    public static class Proposal
    extends SyncedLearnerTracker {
        public QuorumPacket packet;
        public Request request;

        public String toString() {
            return this.packet.getType() + ", " + this.packet.getZxid() + ", " + this.request;
        }
    }
}

