/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.io.eval;

import java.io.IOException;
import java.util.Locale;
import org.apache.commons.math3.util.CombinatoricsUtils;
import org.apache.solr.client.solrj.io.eval.ManyValueWorker;
import org.apache.solr.client.solrj.io.eval.RecursiveNumericEvaluator;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpression;
import org.apache.solr.client.solrj.io.stream.expr.StreamFactory;

public class BinomialCoefficientEvaluator
extends RecursiveNumericEvaluator
implements ManyValueWorker {
    protected static final long serialVersionUID = 1L;

    public BinomialCoefficientEvaluator(StreamExpression expression, StreamFactory factory) throws IOException {
        super(expression, factory);
        if (2 != this.containedEvaluators.size()) {
            throw new IOException(String.format(Locale.ROOT, "Invalid expression %s - expecting two values but found %d", expression, this.containedEvaluators.size()));
        }
    }

    @Override
    public Object doWork(Object ... values) throws IOException {
        if (2 != values.length) {
            throw new IOException(String.format(Locale.ROOT, "%s(...) only works with 2 values but %d were provided", this.constructingFactory.getFunctionName(this.getClass()), values.length));
        }
        int set = ((Number)values[0]).intValue();
        int subset = ((Number)values[1]).intValue();
        return CombinatoricsUtils.binomialCoefficient(set, subset);
    }
}

