/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.client;

import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Base64;
import java.util.HashSet;
import java.util.Set;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.SecretKeySpec;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import org.apache.http.Header;
import org.apache.http.HeaderElement;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.ProtocolException;
import org.apache.http.auth.AuthSchemeProvider;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.NTCredentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.ConnectionKeepAliveStrategy;
import org.apache.http.conn.socket.ConnectionSocketFactory;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.TrustStrategy;
import org.apache.http.impl.auth.BasicSchemeFactory;
import org.apache.http.impl.auth.NTLMSchemeFactory;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.client.LaxRedirectStrategy;
import org.apache.http.impl.conn.DefaultProxyRoutePlanner;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.message.BasicHeaderElementIterator;
import org.apache.http.protocol.HttpContext;
import org.apache.http.ssl.SSLContexts;
import org.apache.tika.exception.TikaConfigException;
import org.apache.tika.utils.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpClientFactory {
    public static final String AES_ENV_VAR = "AES_KEY";
    private static final String CIPHER_TYPE = "AES/GCM/PKCS5Padding";
    private static final Logger LOG = LoggerFactory.getLogger(HttpClientFactory.class);
    private AES aes = null;
    private String proxyHost;
    private int proxyPort;
    private Set<String> allowedHostsForRedirect = new HashSet<String>();
    private int maxConnectionsPerRoute = 1000;
    private int maxConnections = 2000;
    private int requestTimeout = 120000;
    private int connectTimeout = 120000;
    private int socketTimeout = 120000;
    private int keepAliveOnBadKeepAliveValueMs = 1000;
    private String userName;
    private String password;
    private String ntDomain;
    private String authScheme = "basic";
    private boolean credentialsAESEncrypted = false;
    private boolean disableContentCompression = false;

    public String getProxyHost() {
        return this.proxyHost;
    }

    public void setProxyHost(String proxyHost) {
        this.proxyHost = proxyHost;
    }

    public int getProxyPort() {
        return this.proxyPort;
    }

    public void setProxyPort(int proxyPort) {
        this.proxyPort = proxyPort;
    }

    public Set<String> getAllowedHostsForRedirect() {
        return this.allowedHostsForRedirect;
    }

    public void setAllowedHostsForRedirect(Set<String> allowedHostsForRedirect) {
        this.allowedHostsForRedirect = allowedHostsForRedirect;
    }

    public int getMaxConnectionsPerRoute() {
        return this.maxConnectionsPerRoute;
    }

    public void setMaxConnectionsPerRoute(int maxConnectionsPerRoute) {
        this.maxConnectionsPerRoute = maxConnectionsPerRoute;
    }

    public int getMaxConnections() {
        return this.maxConnections;
    }

    public void setMaxConnections(int maxConnections) {
        this.maxConnections = maxConnections;
    }

    public int getRequestTimeout() {
        return this.requestTimeout;
    }

    public void setRequestTimeout(int requestTimeout) {
        this.requestTimeout = requestTimeout;
    }

    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    public void setConnectTimeout(int connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    public int getSocketTimeout() {
        return this.socketTimeout;
    }

    public void setSocketTimeout(int socketTimeout) {
        this.socketTimeout = socketTimeout;
    }

    public int getKeepAliveOnBadKeepAliveValueMs() {
        return this.keepAliveOnBadKeepAliveValueMs;
    }

    public void setKeepAliveOnBadKeepAliveValueMs(int keepAliveOnBadKeepAliveValueMs) {
        this.keepAliveOnBadKeepAliveValueMs = keepAliveOnBadKeepAliveValueMs;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getNtDomain() {
        return this.ntDomain;
    }

    public void setNtDomain(String ntDomain) {
        this.ntDomain = ntDomain;
    }

    public String getAuthScheme() {
        return this.authScheme;
    }

    public void setAuthScheme(String authScheme) {
        this.authScheme = authScheme;
    }

    public void setCredentialsAESEncrypted(boolean credentialsAESEncrypted) throws TikaConfigException {
        if (credentialsAESEncrypted) {
            if (System.getenv(AES_ENV_VAR) == null) {
                throw new TikaConfigException("must specify aes key in the environment variable: AES_KEY");
            }
            if (credentialsAESEncrypted) {
                this.aes = new AES();
            }
        }
        this.credentialsAESEncrypted = credentialsAESEncrypted;
    }

    public void setDisableContentCompression(boolean disableContentCompression) {
        this.disableContentCompression = disableContentCompression;
    }

    public HttpClientFactory copy() throws TikaConfigException {
        HttpClientFactory cp = new HttpClientFactory();
        cp.setAllowedHostsForRedirect(new HashSet<String>(this.allowedHostsForRedirect));
        cp.setAuthScheme(this.authScheme);
        cp.setConnectTimeout(this.connectTimeout);
        cp.setCredentialsAESEncrypted(this.credentialsAESEncrypted);
        cp.setDisableContentCompression(this.disableContentCompression);
        cp.setKeepAliveOnBadKeepAliveValueMs(this.keepAliveOnBadKeepAliveValueMs);
        cp.setMaxConnectionsPerRoute(this.maxConnectionsPerRoute);
        cp.setMaxConnections(this.maxConnections);
        cp.setNtDomain(this.ntDomain);
        cp.setPassword(this.password);
        cp.setProxyHost(this.proxyHost);
        cp.setProxyPort(this.proxyPort);
        cp.setRequestTimeout(this.requestTimeout);
        cp.setSocketTimeout(this.socketTimeout);
        return cp;
    }

    public HttpClient build() throws TikaConfigException {
        LOG.info("http client does not verify ssl at this point.  If you need that, please open a ticket.");
        TrustStrategy acceptingTrustStrategy = (cert, authType) -> true;
        SSLContext sslContext = null;
        try {
            sslContext = SSLContexts.custom().loadTrustMaterial(null, acceptingTrustStrategy).build();
        }
        catch (KeyManagementException | KeyStoreException | NoSuchAlgorithmException e) {
            throw new TikaConfigException("", (Throwable)e);
        }
        SSLConnectionSocketFactory sslsf = new SSLConnectionSocketFactory(sslContext, (HostnameVerifier)NoopHostnameVerifier.INSTANCE);
        Registry<ConnectionSocketFactory> socketFactoryRegistry = RegistryBuilder.create().register("https", sslsf).register("http", (SSLConnectionSocketFactory)((Object)new PlainConnectionSocketFactory())).build();
        PoolingHttpClientConnectionManager manager = new PoolingHttpClientConnectionManager(socketFactoryRegistry);
        manager.setDefaultMaxPerRoute(this.maxConnectionsPerRoute);
        manager.setMaxTotal(this.maxConnections);
        HttpClientBuilder builder = HttpClients.custom();
        if (this.disableContentCompression) {
            builder.disableContentCompression();
        }
        this.addCredentialsProvider(builder);
        this.addProxy(builder);
        return builder.setConnectionManager(manager).setRedirectStrategy(new CustomRedirectStrategy(this.allowedHostsForRedirect)).setDefaultRequestConfig(RequestConfig.custom().setTargetPreferredAuthSchemes(Arrays.asList("Basic", "NTLM")).setConnectionRequestTimeout(this.requestTimeout).setConnectionRequestTimeout(this.connectTimeout).setSocketTimeout(this.socketTimeout).build()).setKeepAliveStrategy(this.getKeepAliveStrategy()).setSSLSocketFactory(sslsf).setSSLHostnameVerifier(NoopHostnameVerifier.INSTANCE).build();
    }

    private void addProxy(HttpClientBuilder builder) {
        if (!StringUtils.isBlank((String)this.proxyHost)) {
            HttpHost proxy = new HttpHost(this.proxyHost, this.proxyPort);
            DefaultProxyRoutePlanner proxyRoutePlanner = new DefaultProxyRoutePlanner(proxy);
            builder.setRoutePlanner(proxyRoutePlanner);
        }
    }

    private void addCredentialsProvider(HttpClientBuilder builder) throws TikaConfigException {
        if (StringUtils.isBlank((String)this.userName) && StringUtils.isBlank((String)this.password)) {
            return;
        }
        if (StringUtils.isBlank((String)this.userName) && StringUtils.isBlank((String)this.password) || StringUtils.isBlank((String)this.password) && StringUtils.isBlank((String)this.userName)) {
            throw new IllegalArgumentException("can't have one of 'username', 'password' null and the other not");
        }
        String finalUserName = this.decrypt(this.userName);
        String finalPassword = this.decrypt(this.password);
        String finalDomain = this.decrypt(this.ntDomain);
        BasicCredentialsProvider provider = new BasicCredentialsProvider();
        Credentials credentials = null;
        Registry<AuthSchemeProvider> authSchemeRegistry = null;
        if (this.authScheme.equals("basic")) {
            credentials = new UsernamePasswordCredentials(finalUserName, finalPassword);
            authSchemeRegistry = RegistryBuilder.create().register("basic", new BasicSchemeFactory()).build();
        } else if (this.authScheme.equals("ntlm")) {
            if (StringUtils.isBlank((String)this.ntDomain)) {
                throw new IllegalArgumentException("must specify 'ntDomain'");
            }
            credentials = new NTCredentials(finalUserName, finalPassword, null, finalDomain);
            authSchemeRegistry = RegistryBuilder.create().register("ntlm", new NTLMSchemeFactory()).build();
        }
        provider.setCredentials(AuthScope.ANY, credentials);
        builder.setDefaultCredentialsProvider(provider);
        builder.setDefaultAuthSchemeRegistry(authSchemeRegistry);
    }

    private String decrypt(String encrypted) throws TikaConfigException {
        if (this.aes == null || encrypted == null) {
            return encrypted;
        }
        return this.aes.decrypt(encrypted);
    }

    public ConnectionKeepAliveStrategy getKeepAliveStrategy() {
        return (response, context) -> {
            BasicHeaderElementIterator it = new BasicHeaderElementIterator(response.headerIterator("Keep-Alive"));
            while (it.hasNext()) {
                HeaderElement he = it.nextElement();
                String param = he.getName();
                String value = he.getValue();
                if (value == null || param == null || !param.equalsIgnoreCase("timeout")) continue;
                try {
                    return Long.parseLong(value) * 1000L;
                }
                catch (NumberFormatException numberFormatException) {
                }
            }
            return this.keepAliveOnBadKeepAliveValueMs;
        };
    }

    private static class AES {
        private final SecretKeySpec secretKey = AES.setKey(System.getenv("AES_KEY"));

        private AES() throws TikaConfigException {
        }

        private static SecretKeySpec setKey(String myKey) throws TikaConfigException {
            try {
                byte[] key = myKey.getBytes(StandardCharsets.UTF_8);
                MessageDigest sha = MessageDigest.getInstance("SHA-1");
                key = sha.digest(key);
                key = Arrays.copyOf(key, 16);
                return new SecretKeySpec(key, "AES");
            }
            catch (NoSuchAlgorithmException e) {
                throw new TikaConfigException("bad key", (Throwable)e);
            }
        }

        public String encrypt(String strToEncrypt) throws TikaConfigException {
            try {
                Cipher cipher = Cipher.getInstance(HttpClientFactory.CIPHER_TYPE);
                cipher.init(1, this.secretKey);
                return Base64.getEncoder().encodeToString(cipher.doFinal(strToEncrypt.getBytes(StandardCharsets.UTF_8)));
            }
            catch (InvalidKeyException | NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException e) {
                throw new TikaConfigException("bad encryption info", (Throwable)e);
            }
        }

        public String decrypt(String strToDecrypt) throws TikaConfigException {
            try {
                Cipher cipher = Cipher.getInstance(HttpClientFactory.CIPHER_TYPE);
                cipher.init(2, this.secretKey);
                return new String(cipher.doFinal(Base64.getDecoder().decode(strToDecrypt)), StandardCharsets.UTF_8);
            }
            catch (InvalidKeyException | NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException e) {
                throw new TikaConfigException("bad encryption info", (Throwable)e);
            }
        }
    }

    private static class CustomRedirectStrategy
    extends LaxRedirectStrategy {
        private static final Logger LOG = LoggerFactory.getLogger(CustomRedirectStrategy.class);
        private final Set<String> allowedHosts;

        public CustomRedirectStrategy(Set<String> allowedHosts) {
            this.allowedHosts = allowedHosts;
        }

        @Override
        protected URI createLocationURI(String location) throws ProtocolException {
            String newLocation = location;
            try {
                new URI(newLocation);
            }
            catch (URISyntaxException ex) {
                LOG.warn("Redirected URL: [ " + newLocation + " ] will be encoded");
                try {
                    newLocation = URLEncoder.encode(newLocation, StandardCharsets.UTF_8.name());
                }
                catch (UnsupportedEncodingException e) {
                    LOG.warn("Well, that didn't work out... :(");
                }
            }
            return super.createLocationURI(newLocation);
        }

        @Override
        public boolean isRedirected(HttpRequest request, HttpResponse response, HttpContext context) throws ProtocolException {
            boolean isRedirectedSuper = super.isRedirected(request, response, context);
            if (isRedirectedSuper) {
                URI uri;
                Header locationHeader = response.getFirstHeader("Location");
                String location = locationHeader.getValue();
                if (StringUtils.isBlank((String)location)) {
                    return false;
                }
                try {
                    uri = new URI(location);
                }
                catch (URISyntaxException e) {
                    return true;
                }
                if (!this.allowedHosts.isEmpty() && !this.allowedHosts.contains(uri.getHost())) {
                    LOG.info("Not allowing external redirect. OriginalUrl={}, RedirectLocation={}", (Object)request.getRequestLine().getUri(), (Object)location);
                    return false;
                }
            }
            return isRedirectedSuper;
        }
    }
}

