/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.io.eval;

import java.io.IOException;
import java.util.Locale;
import org.apache.commons.math3.geometry.euclidean.twod.Euclidean2D;
import org.apache.commons.math3.geometry.euclidean.twod.Vector2D;
import org.apache.commons.math3.geometry.euclidean.twod.hull.ConvexHull2D;
import org.apache.commons.math3.geometry.partitioning.BoundaryProjection;
import org.apache.commons.math3.geometry.partitioning.Region;
import org.apache.solr.client.solrj.io.eval.Matrix;
import org.apache.solr.client.solrj.io.eval.RecursiveObjectEvaluator;
import org.apache.solr.client.solrj.io.eval.TwoValueWorker;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpression;
import org.apache.solr.client.solrj.io.stream.expr.StreamFactory;

public class ProjectToBorderEvaluator
extends RecursiveObjectEvaluator
implements TwoValueWorker {
    private static final long serialVersionUID = 1L;

    public ProjectToBorderEvaluator(StreamExpression expression, StreamFactory factory) throws IOException {
        super(expression, factory);
    }

    @Override
    public Object doWork(Object value1, Object value2) throws IOException {
        if (!(value1 instanceof ConvexHull2D)) {
            throw new IOException(String.format(Locale.ROOT, "Invalid expression %s - found type %s for value, expecting a ConvexHull2D", this.toExpression(this.constructingFactory), value1.getClass().getSimpleName()));
        }
        if (!(value2 instanceof Matrix)) {
            throw new IOException(String.format(Locale.ROOT, "Invalid expression %s - found type %s for value, expecting a Matrix", this.toExpression(this.constructingFactory), value2.getClass().getSimpleName()));
        }
        ConvexHull2D convexHull2D = (ConvexHull2D)value1;
        Matrix matrix = (Matrix)value2;
        double[][] data = matrix.getData();
        Region<Euclidean2D> region = convexHull2D.createRegion();
        double[][] borderPoints = new double[data.length][2];
        int i = 0;
        for (double[] row : data) {
            BoundaryProjection<Euclidean2D> boundaryProjection = region.projectToBoundary(new Vector2D(row));
            Vector2D point = (Vector2D)boundaryProjection.getProjected();
            borderPoints[i][0] = point.getX();
            borderPoints[i][1] = point.getY();
            ++i;
        }
        return new Matrix(borderPoints);
    }
}

