/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.io.eval;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.apache.commons.math3.ml.clustering.CentroidCluster;
import org.apache.solr.client.solrj.io.eval.KmeansEvaluator;
import org.apache.solr.client.solrj.io.eval.Matrix;
import org.apache.solr.client.solrj.io.eval.RecursiveObjectEvaluator;
import org.apache.solr.client.solrj.io.eval.TwoValueWorker;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpression;
import org.apache.solr.client.solrj.io.stream.expr.StreamFactory;

public class GetClusterEvaluator
extends RecursiveObjectEvaluator
implements TwoValueWorker {
    private static final long serialVersionUID = 1L;

    public GetClusterEvaluator(StreamExpression expression, StreamFactory factory) throws IOException {
        super(expression, factory);
    }

    @Override
    public Object doWork(Object value1, Object value2) throws IOException {
        if (!(value1 instanceof KmeansEvaluator.ClusterTuple)) {
            throw new IOException(String.format(Locale.ROOT, "Invalid expression %s - found type %s for value, expecting a cluster result.", this.toExpression(this.constructingFactory), value1.getClass().getSimpleName()));
        }
        KmeansEvaluator.ClusterTuple clusterTuple = (KmeansEvaluator.ClusterTuple)value1;
        List<CentroidCluster<KmeansEvaluator.ClusterPoint>> clusters = clusterTuple.getClusters();
        Number index = (Number)value2;
        CentroidCluster<KmeansEvaluator.ClusterPoint> cluster = clusters.get(index.intValue());
        List points = cluster.getPoints();
        ArrayList<String> rowLabels = new ArrayList<String>();
        double[][] data = new double[points.size()][];
        for (int i = 0; i < points.size(); ++i) {
            KmeansEvaluator.ClusterPoint p = (KmeansEvaluator.ClusterPoint)points.get(i);
            data[i] = p.getPoint();
            rowLabels.add(p.getId());
        }
        Matrix matrix = new Matrix(data);
        matrix.setRowLabels(rowLabels);
        matrix.setColumnLabels(clusterTuple.getColumnLabels());
        return matrix;
    }
}

