/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.pipes.pipesiterator.json;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.concurrent.TimeoutException;
import org.apache.tika.config.Initializable;
import org.apache.tika.pipes.FetchEmitTuple;
import org.apache.tika.pipes.pipesiterator.PipesIterator;
import org.apache.tika.serialization.pipes.JsonFetchEmitTuple;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonPipesIterator
extends PipesIterator
implements Initializable {
    private static final Logger LOGGER = LoggerFactory.getLogger(JsonPipesIterator.class);
    private Path jsonPath;

    protected void enqueue() throws InterruptedException, IOException, TimeoutException {
        try (BufferedReader reader = Files.newBufferedReader(this.jsonPath, StandardCharsets.UTF_8);){
            String line = reader.readLine();
            while (line != null) {
                try (StringReader r = new StringReader(line);){
                    FetchEmitTuple t = JsonFetchEmitTuple.fromJson((Reader)r);
                    LOGGER.info("from json: " + String.valueOf(t));
                    this.tryToAdd(t);
                    line = reader.readLine();
                }
            }
        }
    }

    public void setJsonPath(String jsonPath) {
        this.jsonPath = Paths.get(jsonPath, new String[0]);
    }
}

