/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.pipes.pipesiterator.jdbc;

import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeoutException;
import org.apache.tika.config.Field;
import org.apache.tika.config.Initializable;
import org.apache.tika.config.InitializableProblemHandler;
import org.apache.tika.config.Param;
import org.apache.tika.config.TikaConfig;
import org.apache.tika.exception.TikaConfigException;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.pipes.FetchEmitTuple;
import org.apache.tika.pipes.HandlerConfig;
import org.apache.tika.pipes.emitter.EmitKey;
import org.apache.tika.pipes.fetcher.FetchKey;
import org.apache.tika.pipes.pipesiterator.PipesIterator;
import org.apache.tika.utils.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JDBCPipesIterator
extends PipesIterator
implements Initializable {
    private static final Logger LOGGER = LoggerFactory.getLogger(JDBCPipesIterator.class);
    private String idColumn;
    private String fetchKeyColumn;
    private String fetchKeyRangeStartColumn;
    private String fetchKeyRangeEndColumn;
    private String emitKeyColumn;
    private String connection;
    private String select;
    private int fetchSize = -1;
    private int queryTimeoutSeconds = -1;
    private Connection db;

    @Field
    public void setIdColumn(String idColumn) {
        this.idColumn = idColumn;
    }

    @Field
    public void setFetchKeyColumn(String fetchKeyColumn) {
        this.fetchKeyColumn = fetchKeyColumn;
    }

    @Field
    public void setFetchKeyRangeStartColumn(String fetchKeyRangeStartColumn) {
        this.fetchKeyRangeStartColumn = fetchKeyRangeStartColumn;
    }

    @Field
    public void setFetchKeyRangeEndColumn(String fetchKeyRangeEndColumn) {
        this.fetchKeyRangeEndColumn = fetchKeyRangeEndColumn;
    }

    @Field
    public void setEmitKeyColumn(String fetchKeyColumn) {
        this.emitKeyColumn = fetchKeyColumn;
    }

    @Field
    public void setConnection(String connection) {
        this.connection = connection;
    }

    public String getSelect() {
        return this.select;
    }

    @Field
    public void setSelect(String select) {
        this.select = select;
    }

    @Field
    public void setFetchSize(int fetchSize) throws TikaConfigException {
        if (fetchSize == 0) {
            throw new TikaConfigException("Can't set fetch size == 0");
        }
        if (fetchSize < 0) {
            LOGGER.info("fetch size < 0; no fetch size will be set");
        }
        this.fetchSize = fetchSize;
    }

    public void setQueryTimeoutSeconds(int seconds) {
        this.queryTimeoutSeconds = seconds;
    }

    protected void enqueue() throws InterruptedException, IOException, TimeoutException {
        String fetcherName = this.getFetcherName();
        String emitterName = this.getEmitterName();
        FetchEmitKeyIndices fetchEmitKeyIndices = null;
        ArrayList<String> headers = new ArrayList<String>();
        int rowCount = 0;
        HandlerConfig handlerConfig = this.getHandlerConfig();
        LOGGER.debug("select: {}", (Object)this.select);
        try (Statement st = this.db.createStatement();){
            if (this.fetchSize > 0) {
                st.setFetchSize(this.fetchSize);
            }
            if (this.queryTimeoutSeconds > 0) {
                st.setQueryTimeout(this.queryTimeoutSeconds);
            }
            try (ResultSet rs = st.executeQuery(this.select);){
                while (rs.next()) {
                    if (headers.size() == 0) {
                        fetchEmitKeyIndices = this.loadHeaders(rs.getMetaData(), headers);
                        this.checkFetchEmitValidity(fetcherName, emitterName, fetchEmitKeyIndices, headers);
                    }
                    try {
                        this.processRow(fetcherName, emitterName, headers, fetchEmitKeyIndices, rs, handlerConfig);
                    }
                    catch (SQLException e) {
                        LOGGER.warn("Failed to insert: " + String.valueOf(rs), (Throwable)e);
                    }
                    if (++rowCount % 1000 != 0) continue;
                    LOGGER.info("added " + rowCount + " rows to the queue");
                }
            }
        }
        catch (SQLException e) {
            LOGGER.warn("problem initializing connection and selecting", (Throwable)e);
            throw new IOException(e);
        }
        finally {
            try {
                this.db.close();
            }
            catch (SQLException e) {
                LOGGER.warn("failed to close connection", (Throwable)e);
            }
        }
    }

    private void checkFetchEmitValidity(String fetcherName, String emitterName, FetchEmitKeyIndices fetchEmitKeyIndices, List<String> headers) throws IOException {
        if (!StringUtils.isBlank((String)this.fetchKeyColumn) && fetchEmitKeyIndices.fetchKeyIndex < 0) {
            throw new IOException((Throwable)new TikaConfigException("Couldn't find fetchkey column: " + this.fetchKeyColumn));
        }
        if (!StringUtils.isBlank((String)this.emitKeyColumn) && fetchEmitKeyIndices.emitKeyIndex < 0) {
            throw new IOException((Throwable)new TikaConfigException("Couldn't find emitKey column: " + this.emitKeyColumn));
        }
        if (!StringUtils.isBlank((String)this.idColumn) && fetchEmitKeyIndices.idIndex < 0) {
            throw new IOException((Throwable)new TikaConfigException("Couldn't find id column: " + this.idColumn));
        }
        if (StringUtils.isBlank((String)this.idColumn)) {
            LOGGER.warn("id column is blank, using fetchkey column as the id column");
            fetchEmitKeyIndices.idIndex = fetchEmitKeyIndices.fetchKeyIndex;
        }
    }

    private void processRow(String fetcherName, String emitterName, List<String> headers, FetchEmitKeyIndices fetchEmitKeyIndices, ResultSet rs, HandlerConfig handlerConfig) throws SQLException, TimeoutException, InterruptedException {
        Metadata metadata = new Metadata();
        String fetchKey = "";
        long fetchStartRange = -1L;
        long fetchEndRange = -1L;
        String emitKey = "";
        String id = "";
        for (int i = 1; i <= rs.getMetaData().getColumnCount(); ++i) {
            String val;
            boolean isUsed = false;
            if (i == fetchEmitKeyIndices.fetchKeyIndex) {
                fetchKey = this.getString(i, rs);
                if (StringUtils.isBlank((String)fetchKey)) {
                    LOGGER.debug("fetchKey is empty for record " + this.toString(rs));
                }
                fetchKey = fetchKey == null ? "" : fetchKey;
                isUsed = true;
            }
            if (i == fetchEmitKeyIndices.emitKeyIndex) {
                emitKey = this.getString(i, rs);
                if (StringUtils.isBlank((String)emitKey)) {
                    LOGGER.debug("emitKey is empty for record " + this.toString(rs));
                }
                emitKey = emitKey == null ? "" : emitKey;
                isUsed = true;
            }
            if (i == fetchEmitKeyIndices.idIndex) {
                id = this.getString(i, rs);
                if (StringUtils.isBlank((String)id)) {
                    LOGGER.warn("id is empty for record " + this.toString(rs));
                }
                id = id == null ? "" : id;
                isUsed = true;
            }
            if (i == fetchEmitKeyIndices.fetchStartRangeIndex) {
                fetchStartRange = this.getLong(i, rs);
                isUsed = true;
            }
            if (i == fetchEmitKeyIndices.fetchEndRangeIndex) {
                fetchEndRange = this.getLong(i, rs);
                isUsed = true;
            }
            if (isUsed || StringUtils.isBlank((String)(val = this.getString(i, rs)))) continue;
            metadata.set(headers.get(i - 1), val);
        }
        ParseContext parseContext = new ParseContext();
        parseContext.set(HandlerConfig.class, (Object)handlerConfig);
        this.tryToAdd(new FetchEmitTuple(id, new FetchKey(fetcherName, fetchKey, fetchStartRange, fetchEndRange), new EmitKey(emitterName, emitKey), metadata, parseContext, this.getOnParseException()));
    }

    private String toString(ResultSet rs) throws SQLException {
        StringBuilder sb = new StringBuilder();
        for (int i = 1; i <= rs.getMetaData().getColumnCount(); ++i) {
            String val = rs.getString(i);
            val = val == null ? "" : val;
            val = val.length() > 100 ? val.substring(0, 100) : val;
            sb.append(rs.getMetaData().getColumnLabel(i)).append(":").append(val).append("\n");
        }
        return sb.toString();
    }

    private String getString(int i, ResultSet rs) throws SQLException {
        String val = rs.getString(i);
        if (rs.wasNull()) {
            return null;
        }
        return val;
    }

    private long getLong(int i, ResultSet rs) throws SQLException {
        long val = rs.getLong(i);
        if (rs.wasNull()) {
            return -1L;
        }
        return val;
    }

    private FetchEmitKeyIndices loadHeaders(ResultSetMetaData metaData, List<String> headers) throws SQLException {
        int idIndex = -1;
        int fetchKeyIndex = -1;
        int fetchKeyStartRangeIndex = -1;
        int fetchKeyEndRangeIndex = -1;
        int emitKeyIndex = -1;
        for (int i = 1; i <= metaData.getColumnCount(); ++i) {
            String colLabel = metaData.getColumnLabel(i);
            if (colLabel.equalsIgnoreCase(this.fetchKeyColumn)) {
                fetchKeyIndex = i;
            }
            if (colLabel.equalsIgnoreCase(this.fetchKeyRangeStartColumn)) {
                fetchKeyStartRangeIndex = i;
            }
            if (colLabel.equalsIgnoreCase(this.fetchKeyRangeEndColumn)) {
                fetchKeyEndRangeIndex = i;
            }
            if (colLabel.equalsIgnoreCase(this.emitKeyColumn)) {
                emitKeyIndex = i;
            }
            if (colLabel.equalsIgnoreCase(this.idColumn)) {
                idIndex = i;
            }
            headers.add(metaData.getColumnLabel(i));
        }
        return new FetchEmitKeyIndices(idIndex, fetchKeyIndex, fetchKeyStartRangeIndex, fetchKeyEndRangeIndex, emitKeyIndex);
    }

    public void initialize(Map<String, Param> params) throws TikaConfigException {
        try {
            this.db = DriverManager.getConnection(this.connection);
        }
        catch (SQLException e) {
            throw new TikaConfigException("couldn't connect to db", (Throwable)e);
        }
    }

    public void checkInitialization(InitializableProblemHandler problemHandler) throws TikaConfigException {
        super.checkInitialization(problemHandler);
        TikaConfig.mustNotBeEmpty((String)"connection", (String)this.connection);
        TikaConfig.mustNotBeEmpty((String)"select", (String)this.select);
        if (StringUtils.isBlank((String)this.getFetcherName()) && !StringUtils.isBlank((String)this.fetchKeyColumn)) {
            throw new TikaConfigException("If you specify a 'fetchKeyColumn', you must specify a 'fetcherName'");
        }
        if (StringUtils.isBlank((String)this.getEmitterName()) && !StringUtils.isBlank((String)this.emitKeyColumn)) {
            throw new TikaConfigException("If you specify an 'emitKeyColumn', you must specify an 'emitterName'");
        }
        if (StringUtils.isBlank((String)this.getEmitterName()) && StringUtils.isBlank((String)this.getFetcherName())) {
            LOGGER.warn("no fetcher or emitter specified?!");
        }
        if (StringUtils.isEmpty((CharSequence)this.fetchKeyColumn)) {
            LOGGER.warn("no fetch key column has been specified");
        }
    }

    private static class FetchEmitKeyIndices {
        private final int fetchKeyIndex;
        private final int fetchStartRangeIndex;
        private final int fetchEndRangeIndex;
        private final int emitKeyIndex;
        private int idIndex;

        public FetchEmitKeyIndices(int idIndex, int fetchKeyIndex, int fetchStartRangeIndex, int fetchEndRangeIndex, int emitKeyIndex) {
            this.idIndex = idIndex;
            this.fetchKeyIndex = fetchKeyIndex;
            this.fetchStartRangeIndex = fetchStartRangeIndex;
            this.fetchEndRangeIndex = fetchEndRangeIndex;
            this.emitKeyIndex = emitKeyIndex;
        }

        public boolean shouldSkip(int index) {
            return this.idIndex == index || this.fetchKeyIndex == index || this.fetchStartRangeIndex == index || this.fetchEndRangeIndex == index || this.emitKeyIndex == index;
        }
    }
}

