/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.opentelemetry;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.io.BaseEncoding;
import io.grpc.ExperimentalApi;
import io.grpc.InternalMetadata;
import io.grpc.Metadata;
import io.grpc.opentelemetry.BinaryFormat;
import io.grpc.opentelemetry.MetadataGetter;
import io.grpc.opentelemetry.MetadataSetter;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.SpanContext;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.propagation.TextMapGetter;
import io.opentelemetry.context.propagation.TextMapPropagator;
import io.opentelemetry.context.propagation.TextMapSetter;
import java.util.Collection;
import java.util.Collections;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;

@ExperimentalApi(value="https://github.com/grpc/grpc-java/issues/11400")
public final class GrpcTraceBinContextPropagator
implements TextMapPropagator {
    private static final Logger log = Logger.getLogger(GrpcTraceBinContextPropagator.class.getName());
    public static final String GRPC_TRACE_BIN_HEADER = "grpc-trace-bin";
    private final Metadata.BinaryMarshaller<SpanContext> binaryFormat;
    private static final GrpcTraceBinContextPropagator INSTANCE = new GrpcTraceBinContextPropagator(BinaryFormat.getInstance());

    public static GrpcTraceBinContextPropagator defaultInstance() {
        return INSTANCE;
    }

    @VisibleForTesting
    GrpcTraceBinContextPropagator(Metadata.BinaryMarshaller<SpanContext> binaryFormat) {
        this.binaryFormat = Preconditions.checkNotNull(binaryFormat, "binaryFormat");
    }

    @Override
    public Collection<String> fields() {
        return Collections.singleton(GRPC_TRACE_BIN_HEADER);
    }

    @Override
    public <C> void inject(Context context, @Nullable C carrier, TextMapSetter<C> setter) {
        if (context == null || setter == null) {
            return;
        }
        SpanContext spanContext = Span.fromContext(context).getSpanContext();
        if (!spanContext.isValid()) {
            return;
        }
        try {
            byte[] b = this.binaryFormat.toBytes(spanContext);
            if (setter instanceof MetadataSetter) {
                ((MetadataSetter)setter).set((Metadata)carrier, GRPC_TRACE_BIN_HEADER, b);
            } else {
                setter.set(carrier, GRPC_TRACE_BIN_HEADER, InternalMetadata.BASE64_ENCODING_OMIT_PADDING.encode(b));
            }
        }
        catch (Exception e) {
            log.log(Level.FINE, "Set grpc-trace-bin spanContext failed", e);
        }
    }

    @Override
    public <C> Context extract(Context context, @Nullable C carrier, TextMapGetter<C> getter) {
        SpanContext spanContext;
        byte[] b;
        block14: {
            String value;
            if (context == null) {
                return Context.root();
            }
            if (getter == null) {
                return context;
            }
            if (getter instanceof MetadataGetter) {
                try {
                    b = ((MetadataGetter)getter).getBinary((Metadata)carrier, GRPC_TRACE_BIN_HEADER);
                    if (b == null) {
                        log.log(Level.FINE, "No grpc-trace-bin present in carrier");
                        return context;
                    }
                    break block14;
                }
                catch (Exception e) {
                    log.log(Level.FINE, "Get 'grpc-trace-bin' from MetadataGetter failed", e);
                    return context;
                }
            }
            try {
                value = getter.get(carrier, GRPC_TRACE_BIN_HEADER);
                if (value == null) {
                    log.log(Level.FINE, "No grpc-trace-bin present in carrier");
                    return context;
                }
            }
            catch (Exception e) {
                log.log(Level.FINE, "Get 'grpc-trace-bin' from getter failed", e);
                return context;
            }
            try {
                b = BaseEncoding.base64().decode(value);
            }
            catch (Exception e) {
                log.log(Level.FINE, "Base64-decode spanContext bytes failed", e);
                return context;
            }
        }
        try {
            spanContext = this.binaryFormat.parseBytes(b);
        }
        catch (Exception e) {
            log.log(Level.FINE, "Failed to parse tracing header", e);
            return context;
        }
        if (!spanContext.isValid()) {
            return context;
        }
        return context.with(Span.wrap(spanContext));
    }
}

