/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.storage;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.InternalApi;
import com.google.api.gax.grpc.GrpcCallContext;
import com.google.cloud.storage.GrpcUtils;
import com.google.cloud.storage.IOAutoCloseable;
import com.google.cloud.storage.ObjectReadSession;
import com.google.cloud.storage.ObjectReadSessionImpl;
import com.google.cloud.storage.ObjectReadSessionState;
import com.google.cloud.storage.ObjectReadSessionStream;
import com.google.cloud.storage.ObjectReadSessionStreamRead;
import com.google.cloud.storage.ReadProjectionConfig;
import com.google.cloud.storage.RetryContext;
import com.google.cloud.storage.Retrying;
import com.google.common.base.Preconditions;
import com.google.storage.v2.BidiReadObjectRequest;
import com.google.storage.v2.BidiReadObjectResponse;
import java.io.IOException;
import java.time.Duration;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

@InternalApi
final class StorageDataClient
implements AutoCloseable {
    final ScheduledExecutorService executor;
    private final Duration terminationAwaitDuration;
    private final GrpcUtils.ZeroCopyBidiStreamingCallable<BidiReadObjectRequest, BidiReadObjectResponse> bidiReadObject;
    final RetryContext.RetryContextProvider retryContextProvider;
    private final IOAutoCloseable onClose;

    private StorageDataClient(ScheduledExecutorService executor, Duration terminationAwaitDuration, GrpcUtils.ZeroCopyBidiStreamingCallable<BidiReadObjectRequest, BidiReadObjectResponse> bidiReadObject, RetryContext.RetryContextProvider retryContextProvider, IOAutoCloseable onClose) {
        this.executor = executor;
        this.terminationAwaitDuration = terminationAwaitDuration;
        this.bidiReadObject = bidiReadObject;
        this.retryContextProvider = retryContextProvider;
        this.onClose = onClose;
    }

    ApiFuture<ObjectReadSession> readSession(BidiReadObjectRequest req, GrpcCallContext ctx) {
        Preconditions.checkArgument(req.getReadRangesList().isEmpty(), "ranges included in the initial request are not supported");
        ObjectReadSessionState state = new ObjectReadSessionState(ctx, req);
        GrpcUtils.ZeroCopyBidiStreamingCallable<BidiReadObjectRequest, BidiReadObjectResponse> callable = this.getCallable();
        ObjectReadSessionStream stream = ObjectReadSessionStream.create(this.executor, callable, state, this.retryContextProvider.create());
        ApiFuture<ObjectReadSession> objectReadSessionFuture = ApiFutures.transform(stream, nowOpen -> new ObjectReadSessionImpl(this.executor, callable, stream, state, this.retryContextProvider), this.executor);
        stream.send(req);
        return objectReadSessionFuture;
    }

    <Projection> ApiFuture<FastOpenObjectReadSession<Projection>> fastOpenReadSession(BidiReadObjectRequest openRequest, GrpcCallContext ctx, ReadProjectionConfig<Projection> config) {
        Preconditions.checkArgument(openRequest.getReadRangesList().isEmpty(), "ranges included in the initial request are not supported");
        Preconditions.checkArgument(config.getType() == ReadProjectionConfig.ProjectionType.STREAM_READ, "unsupported ReadProjectionConfig: %s", (Object)config.getClass().getName());
        ObjectReadSessionState state = new ObjectReadSessionState(ctx, openRequest);
        GrpcUtils.ZeroCopyBidiStreamingCallable<BidiReadObjectRequest, BidiReadObjectResponse> callable = this.getCallable();
        ObjectReadSessionStream stream = ObjectReadSessionStream.create(this.executor, callable, state, this.retryContextProvider.create());
        long readId = state.newReadId();
        Object read = config.cast().newRead(readId, this.retryContextProvider.create());
        state.putOutstandingRead(readId, (ObjectReadSessionStreamRead<?>)read);
        ApiFuture<FastOpenObjectReadSession<Projection>> objectReadSessionFuture = ApiFutures.transform(stream, nowOpen -> new FastOpenObjectReadSession(new ObjectReadSessionImpl(this.executor, callable, stream, state, this.retryContextProvider), (ObjectReadSessionStreamRead)read, stream), this.executor);
        ObjectReadSessionState.OpenArguments openArguments = state.getOpenArguments();
        BidiReadObjectRequest req = openArguments.getReq();
        stream.send(req);
        read.setOnCloseCallback(stream);
        return objectReadSessionFuture;
    }

    @Override
    public void close() throws Exception {
        try (IOAutoCloseable ignore = this.onClose;){
            this.executor.shutdownNow();
            this.executor.awaitTermination(this.terminationAwaitDuration.toNanos(), TimeUnit.NANOSECONDS);
        }
    }

    private GrpcUtils.ZeroCopyBidiStreamingCallable<BidiReadObjectRequest, BidiReadObjectResponse> getCallable() {
        return this.bidiReadObject.withDefaultCallContext(Retrying.newCallContext());
    }

    static StorageDataClient create(ScheduledExecutorService executor, Duration terminationAwaitDuration, GrpcUtils.ZeroCopyBidiStreamingCallable<BidiReadObjectRequest, BidiReadObjectResponse> read, RetryContext.RetryContextProvider retryContextProvider, IOAutoCloseable onClose) {
        return new StorageDataClient(executor, terminationAwaitDuration, read, retryContextProvider, onClose);
    }

    static final class FastOpenObjectReadSession<Projection>
    implements IOAutoCloseable {
        private final ObjectReadSession session;
        private final ObjectReadSessionStreamRead<Projection> read;
        private final Borrowable borrowable;
        private boolean sessionLeased;

        private FastOpenObjectReadSession(ObjectReadSession session, ObjectReadSessionStreamRead<Projection> read, Borrowable borrowable) {
            this.session = session;
            this.read = read;
            this.borrowable = borrowable;
            this.sessionLeased = false;
        }

        ObjectReadSession getSession() {
            if (!this.sessionLeased) {
                this.sessionLeased = true;
                this.borrowable.borrow();
            }
            return this.session;
        }

        ObjectReadSessionStreamRead<Projection> getRead() {
            return this.read;
        }

        Projection getProjection() {
            return this.read.project();
        }

        @Override
        public void close() throws IOException {
            try (ObjectReadSession ignore1 = this.session;){
                ObjectReadSessionStreamRead<Projection> ignore2 = this.read;
                if (ignore2 != null) {
                    ignore2.close();
                }
            }
        }

        public static <Projection> FastOpenObjectReadSession<Projection> of(ObjectReadSession session, ObjectReadSessionStreamRead<Projection> read, Borrowable borrowable) {
            return new FastOpenObjectReadSession<Projection>(session, read, borrowable);
        }
    }

    @FunctionalInterface
    static interface Borrowable {
        public void borrow();
    }
}

