/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.storage;

import com.google.api.client.util.Sleeper;
import com.google.api.core.ApiClock;
import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.InternalApi;
import com.google.api.core.InternalExtensionOnly;
import com.google.api.core.NanoClock;
import com.google.api.gax.retrying.ResultRetryAlgorithm;
import com.google.cloud.storage.Backoff;
import com.google.cloud.storage.DefaultRetryContext;
import com.google.cloud.storage.Retrying;
import com.google.common.primitives.Longs;
import com.google.common.util.concurrent.MoreExecutors;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.Delayed;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

@InternalApi
@InternalExtensionOnly
interface RetryContext {
    public boolean inBackoff();

    public void reset();

    public <T extends Throwable> void recordError(T var1, OnSuccess var2, OnFailure<T> var3);

    public static RetryContext of(ScheduledExecutorService scheduledExecutorService, Retrying.RetryingDependencies retryingDependencies, ResultRetryAlgorithm<?> algorithm, Backoff.Jitterer jitterer) {
        return new DefaultRetryContext(scheduledExecutorService, retryingDependencies, algorithm, jitterer);
    }

    public static RetryContext neverRetry() {
        return new DefaultRetryContext(RetryContext.directScheduledExecutorService(), Retrying.RetryingDependencies.attemptOnce(), Retrying.neverRetry(), Backoff.Jitterer.threadLocalRandom());
    }

    public static RetryContextProvider providerFrom(ScheduledExecutorService scheduledExecutorService, Retrying.RetryingDependencies deps, ResultRetryAlgorithm<?> alg) {
        return () -> RetryContext.of(scheduledExecutorService, deps, alg, Backoff.Jitterer.threadLocalRandom());
    }

    public static ScheduledExecutorService directScheduledExecutorService() {
        return DirectScheduledExecutorService.INSTANCE;
    }

    @FunctionalInterface
    public static interface RetryContextProvider {
        public RetryContext create();
    }

    public static final class DirectScheduledExecutorService
    implements ScheduledExecutorService {
        private static final DirectScheduledExecutorService INSTANCE = new DirectScheduledExecutorService(Sleeper.DEFAULT, NanoClock.getDefaultClock());
        private static final Comparator<Delayed> COMP = Comparator.comparingLong(delay -> delay.getDelay(TimeUnit.NANOSECONDS));
        private final Sleeper sleeper;
        private final ApiClock apiClock;

        private DirectScheduledExecutorService(Sleeper sleeper, ApiClock apiClock) {
            this.sleeper = sleeper;
            this.apiClock = apiClock;
        }

        @Override
        public ScheduledFuture<?> schedule(Runnable command, long delay, TimeUnit unit) {
            return new DirectScheduledFuture(unit, delay, command);
        }

        @Override
        public <V> ScheduledFuture<V> schedule(Callable<V> callable, long delay, TimeUnit unit) {
            throw new UnsupportedOperationException();
        }

        @Override
        public ScheduledFuture<?> scheduleAtFixedRate(Runnable command, long initialDelay, long period, TimeUnit unit) {
            throw new UnsupportedOperationException();
        }

        @Override
        public ScheduledFuture<?> scheduleWithFixedDelay(Runnable command, long initialDelay, long delay, TimeUnit unit) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void shutdown() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<Runnable> shutdownNow() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isShutdown() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isTerminated() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
            throw new UnsupportedOperationException();
        }

        @Override
        public <T> Future<T> submit(Callable<T> task) {
            throw new UnsupportedOperationException();
        }

        @Override
        public <T> Future<T> submit(Runnable task, T result) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Future<?> submit(Runnable task) {
            throw new UnsupportedOperationException();
        }

        @Override
        public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks) throws InterruptedException {
            throw new UnsupportedOperationException();
        }

        @Override
        public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException {
            throw new UnsupportedOperationException();
        }

        @Override
        public <T> T invokeAny(Collection<? extends Callable<T>> tasks) throws InterruptedException, ExecutionException {
            throw new UnsupportedOperationException();
        }

        @Override
        public <T> T invokeAny(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            throw new UnsupportedOperationException();
        }

        @Override
        public void execute(Runnable command) {
            command.run();
        }

        private final class DirectScheduledFuture
        implements ScheduledFuture<Object> {
            private final long origDelayNs;
            private final long beginNs;
            private final ApiFuture<Object> delegate;

            public DirectScheduledFuture(TimeUnit unit, long delay, Runnable command) {
                this.origDelayNs = unit.toNanos(delay);
                this.beginNs = DirectScheduledExecutorService.this.apiClock.nanoTime();
                this.delegate = ApiFutures.transformAsync(ApiFutures.immediateFuture(null), ignore -> {
                    DirectScheduledExecutorService.this.sleeper.sleep(unit.toMillis(delay));
                    command.run();
                    return ApiFutures.immediateFuture(null);
                }, MoreExecutors.directExecutor());
            }

            @Override
            public long getDelay(TimeUnit unit) {
                long nowNs = DirectScheduledExecutorService.this.apiClock.nanoTime();
                return Longs.max(0L, nowNs - this.beginNs - this.origDelayNs);
            }

            @Override
            public int compareTo(Delayed o) {
                return COMP.compare(this, o);
            }

            @Override
            public boolean cancel(boolean mayInterruptIfRunning) {
                return this.delegate.cancel(mayInterruptIfRunning);
            }

            @Override
            public boolean isCancelled() {
                return this.delegate.isCancelled();
            }

            @Override
            public boolean isDone() {
                return this.delegate.isDone();
            }

            @Override
            public Object get() throws InterruptedException, ExecutionException {
                return this.delegate.get();
            }

            @Override
            public Object get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
                return this.delegate.get(timeout, unit);
            }
        }
    }

    public static final class BackoffComment
    extends Throwable {
        private BackoffComment(String message) {
            super(message, null, true, false);
        }

        static BackoffComment fromResult(Backoff.BackoffResult result) {
            return new BackoffComment(String.format("backing off %s before next attempt", result.errorString()));
        }

        static BackoffComment of(String message) {
            return new BackoffComment(message);
        }
    }

    public static final class RetryBudgetExhaustedComment
    extends Throwable {
        RetryBudgetExhaustedComment(String comment) {
            super(comment, null, true, false);
        }
    }

    @FunctionalInterface
    public static interface OnFailure<T extends Throwable> {
        public void onFailure(T var1);
    }

    @FunctionalInterface
    public static interface OnSuccess {
        public void onSuccess();
    }
}

