/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.storage;

import com.google.common.base.Preconditions;
import java.util.Locale;

final class ReadCursor {
    private final long begin;
    private long position;
    private final long end;

    ReadCursor(long begin, long end) {
        this.end = end;
        this.begin = begin;
        this.position = begin;
    }

    public boolean hasRemaining() {
        return this.remaining() > 0L;
    }

    public long remaining() {
        return this.end - this.position;
    }

    public void advance(long incr) {
        Preconditions.checkArgument(incr >= 0L);
        this.position += incr;
    }

    public long read() {
        return this.position - this.begin;
    }

    public long begin() {
        return this.begin;
    }

    public long position() {
        return this.position;
    }

    public long end() {
        return this.end;
    }

    public String toString() {
        return String.format(Locale.US, "ReadCursor{begin=%d, position=%d, end=%d}", this.begin, this.position, this.end);
    }
}

