/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.storage;

import com.google.api.client.http.GenericUrl;
import com.google.api.client.http.HttpResponseException;
import com.google.api.services.storage.model.StorageObject;
import com.google.cloud.storage.ByteRangeSpec;
import com.google.cloud.storage.HttpClientContext;
import com.google.cloud.storage.HttpContentRange;
import com.google.cloud.storage.JsonResumableSession;
import com.google.cloud.storage.JsonResumableWrite;
import com.google.cloud.storage.ResumableOperationResult;
import com.google.cloud.storage.RewindableContent;
import com.google.cloud.storage.StorageException;
import com.google.cloud.storage.UploadFailureScenario;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import io.opencensus.trace.Status;
import java.io.IOException;
import java.lang.invoke.LambdaMetafactory;
import java.math.BigInteger;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.Callable;
import org.checkerframework.checker.nullness.qual.Nullable;

final class JsonResumableSessionPutTask
implements Callable<ResumableOperationResult<StorageObject>> {
    private final HttpClientContext context;
    private final JsonResumableWrite jsonResumableWrite;
    private final RewindableContent content;
    private final HttpContentRange originalContentRange;
    private HttpContentRange contentRange;

    @VisibleForTesting
    JsonResumableSessionPutTask(HttpClientContext httpClientContext, JsonResumableWrite jsonResumableWrite, RewindableContent content, HttpContentRange originalContentRange) {
        this.context = httpClientContext;
        this.jsonResumableWrite = jsonResumableWrite;
        this.content = content;
        this.originalContentRange = originalContentRange;
        this.contentRange = originalContentRange;
    }

    public void rewindTo(long offset) {
        if (this.originalContentRange instanceof HttpContentRange.HasRange) {
            HttpContentRange.HasRange hasRange = (HttpContentRange.HasRange)((Object)this.originalContentRange);
            ByteRangeSpec range = hasRange.range();
            long originalBegin = range.beginOffset();
            long contentOffset = offset - originalBegin;
            Preconditions.checkArgument(0L <= contentOffset && contentOffset < range.length(), "Rewind offset is out of bounds. (%s <= %s < %s)", (Object)originalBegin, (Object)offset, (Object)range.endOffset());
            this.content.rewindTo(contentOffset);
        } else {
            this.content.rewindTo(0L);
        }
        if (this.contentRange instanceof HttpContentRange.HasRange) {
            HttpContentRange.HasRange range = (HttpContentRange.HasRange)((Object)this.contentRange);
            this.contentRange = range.map(s2 -> s2.withNewBeginOffset(offset));
        }
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public ResumableOperationResult<@Nullable StorageObject> call() throws IOException {
        span = this.context.startSpan(JsonResumableSession.SPAN_NAME_WRITE);
        scope = this.context.getTracer().withSpan(span);
        success = false;
        finalizing = this.originalContentRange.isFinalizing();
        uploadId = this.jsonResumableWrite.getUploadId();
        req = this.context.getRequestFactory().buildPutRequest(new GenericUrl(uploadId), this.content).setParser(this.context.getObjectParser());
        req.setThrowExceptionOnExecuteError(false);
        headers = req.getHeaders();
        headers.setContentRange(this.contentRange.getHeaderValue());
        for (Map.Entry e : this.jsonResumableWrite.getExtraHeaders().entrySet()) {
            headers.set((String)e.getKey(), e.getValue());
        }
        response = null;
        try {
            response = req.execute();
            code = response.getStatusCode();
            if (!finalizing && UploadFailureScenario.isContinue(code)) {
                effectiveEnd = ((HttpContentRange.HasRange)this.contentRange).range().endOffset();
                range = response.getHeaders().getRange();
                ackRange = ByteRangeSpec.parse(range);
                if (ackRange.endOffset() == effectiveEnd) {
                    success = true;
                    var14_27 = ResumableOperationResult.incremental(ackRange.endOffset());
                    return var14_27;
                }
                if (ackRange.endOffset() < effectiveEnd) {
                    this.rewindTo(ackRange.endOffset());
                    success = true;
                    var14_28 = ResumableOperationResult.incremental(ackRange.endOffset());
                    return var14_28;
                }
                se = UploadFailureScenario.SCENARIO_7.toStorageException(uploadId, response);
                span.setStatus(Status.UNKNOWN.withDescription(se.getMessage()));
                throw se;
            }
            if (!finalizing || !UploadFailureScenario.isOk(code)) ** GOTO lbl69
            actualSize = BigInteger.ZERO;
            contentLength = response.getHeaders().getContentLength();
            contentType = response.getHeaders().getContentType();
            storedContentLength = HttpClientContext.firstHeaderValue(response.getHeaders(), "x-goog-stored-content-length");
            v0 = isJson = contentType != null && contentType.startsWith("application/json") != false;
            if (isJson) {
                storageObject = response.parseAs(StorageObject.class);
                if (storageObject != null && (size = storageObject.getSize()) != null) {
                    actualSize = size;
                }
            } else if ((contentLength == null || contentLength == 0L) && storedContentLength != null) {
                response.ignore();
                actualSize = new BigInteger(storedContentLength, 10);
                success = true;
                storageObject = null;
            } else {
                response.ignore();
                se = UploadFailureScenario.SCENARIO_0_1.toStorageException(uploadId, response, null, (StorageException.IOExceptionCallable<String>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$call$1(), ()Ljava/lang/String;)());
                span.setStatus(Status.UNKNOWN.withDescription(se.getMessage()));
                throw se;
            }
            if ((compare = (expectedSize = BigInteger.valueOf(((HttpContentRange.HasSize)this.contentRange).getSize())).compareTo(actualSize)) == 0) {
                success = true;
                var18_39 = ResumableOperationResult.complete(storageObject, actualSize.longValue());
                return var18_39;
            }
            try {
                if (compare > 0) {
                    se = UploadFailureScenario.SCENARIO_4_1.toStorageException(uploadId, response, null, JsonResumableSessionPutTask.toString(storageObject));
                    span.setStatus(Status.UNKNOWN.withDescription(se.getMessage()));
                    throw se;
                }
                se = UploadFailureScenario.SCENARIO_4_2.toStorageException(uploadId, response, null, JsonResumableSessionPutTask.toString(storageObject));
                span.setStatus(Status.UNKNOWN.withDescription(se.getMessage()));
                throw se;
lbl69:
                // 1 sources

                if (!finalizing && UploadFailureScenario.isOk(code)) {
                    se = UploadFailureScenario.SCENARIO_1.toStorageException(uploadId, response);
                    span.setStatus(Status.UNKNOWN.withDescription(se.getMessage()));
                    throw se;
                }
                if (finalizing && UploadFailureScenario.isContinue(code)) {
                    size = (HttpContentRange.HasSize)this.contentRange;
                    range = ByteRangeSpec.parse(response.getHeaders().getRange());
                    if (range.endOffsetInclusive() < size.getSize()) {
                        se = UploadFailureScenario.SCENARIO_3.toStorageException(uploadId, response);
                        span.setStatus(Status.UNKNOWN.withDescription(se.getMessage()));
                        throw se;
                    }
                    se = UploadFailureScenario.SCENARIO_2.toStorageException(uploadId, response);
                    span.setStatus(Status.UNKNOWN.withDescription(se.getMessage()));
                    throw se;
                }
                cause = new HttpResponseException(response);
                contentType = response.getHeaders().getContentType();
                contentLength = response.getHeaders().getContentLength();
                if (!UploadFailureScenario.isOk(code) && !UploadFailureScenario.isContinue(code) && contentType != null && contentType.startsWith("text/plain") && contentLength != null && contentLength > 0L && (errorMessage = cause.getContent().toLowerCase(Locale.US)).contains("content-range") && !errorMessage.contains("earlier")) {
                    se = UploadFailureScenario.SCENARIO_5.toStorageException(uploadId, response, cause, (StorageException.IOExceptionCallable<String>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, getContent(), ()Ljava/lang/String;)((HttpResponseException)cause));
                    span.setStatus(Status.UNKNOWN.withDescription(se.getMessage()));
                    throw se;
                }
                se = UploadFailureScenario.toStorageException(response, cause, uploadId);
                span.setStatus(Status.UNKNOWN.withDescription(se.getMessage()));
                throw se;
            }
            catch (StorageException | IllegalArgumentException e) {
                span.setStatus(Status.UNKNOWN.withDescription(e.getMessage()));
                throw e;
            }
            catch (Exception e) {
                se = UploadFailureScenario.SCENARIO_0.toStorageException(uploadId, response, e);
                span.setStatus(Status.UNKNOWN.withDescription(se.getMessage()));
                throw se;
            }
        }
        finally {
            if (success && !finalizing && response != null) {
                response.ignore();
            }
            scope.close();
            span.end(JsonResumableSession.END_SPAN_OPTIONS);
        }
    }

    static StorageException.IOExceptionCallable<@Nullable String> toString(@Nullable Object o) {
        return () -> o != null ? o.toString() : null;
    }

    private static /* synthetic */ String lambda$call$1() throws IOException {
        return null;
    }
}

