/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.storage;

import com.google.api.gax.paging.Page;
import com.google.cloud.storage.Acl;
import com.google.cloud.storage.Blob;
import com.google.cloud.storage.BlobId;
import com.google.cloud.storage.BlobInfo;
import com.google.cloud.storage.BucketInfo;
import com.google.cloud.storage.Cors;
import com.google.cloud.storage.Option;
import com.google.cloud.storage.Rpo;
import com.google.cloud.storage.Storage;
import com.google.cloud.storage.StorageClass;
import com.google.cloud.storage.StorageOptions;
import com.google.cloud.storage.TransportCompatibility;
import com.google.cloud.storage.UnifiedOpts;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.math.BigInteger;
import java.security.Key;
import java.time.Duration;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

@TransportCompatibility(value={TransportCompatibility.Transport.HTTP, TransportCompatibility.Transport.GRPC})
public class Bucket
extends BucketInfo {
    private static final long serialVersionUID = 3599706574671671516L;
    private final StorageOptions options;
    private transient Storage storage;

    Bucket(Storage storage, BucketInfo.BuilderImpl infoBuilder) {
        super(infoBuilder);
        this.storage = Preconditions.checkNotNull(storage);
        this.options = (StorageOptions)storage.getOptions();
    }

    @TransportCompatibility(value={TransportCompatibility.Transport.HTTP, TransportCompatibility.Transport.GRPC})
    public boolean exists(BucketSourceOption ... options) {
        int length = options.length;
        Storage.BucketGetOption[] getOptions = Arrays.copyOf(BucketSourceOption.toGetOptions(this, options), length + 1);
        getOptions[length] = Storage.BucketGetOption.fields(new Storage.BucketField[0]);
        return this.storage.get(this.getName(), getOptions) != null;
    }

    @TransportCompatibility(value={TransportCompatibility.Transport.HTTP, TransportCompatibility.Transport.GRPC})
    public Bucket reload(BucketSourceOption ... options) {
        return this.storage.get(this.getName(), BucketSourceOption.toGetOptions(this, options));
    }

    @TransportCompatibility(value={TransportCompatibility.Transport.HTTP, TransportCompatibility.Transport.GRPC})
    public Bucket update(Storage.BucketTargetOption ... options) {
        return this.storage.update(this, options);
    }

    @TransportCompatibility(value={TransportCompatibility.Transport.HTTP, TransportCompatibility.Transport.GRPC})
    public boolean delete(BucketSourceOption ... options) {
        return this.storage.delete(this.getName(), BucketSourceOption.toSourceOptions(this, options));
    }

    @TransportCompatibility(value={TransportCompatibility.Transport.HTTP, TransportCompatibility.Transport.GRPC})
    public Page<Blob> list(Storage.BlobListOption ... options) {
        return this.storage.list(this.getName(), options);
    }

    @TransportCompatibility(value={TransportCompatibility.Transport.HTTP, TransportCompatibility.Transport.GRPC})
    public Blob get(String blob, Storage.BlobGetOption ... options) {
        return this.storage.get(BlobId.of(this.getName(), blob), options);
    }

    @TransportCompatibility(value={TransportCompatibility.Transport.HTTP, TransportCompatibility.Transport.GRPC})
    public Blob get(String blob, Long generation, Storage.BlobGetOption ... options) {
        return this.storage.get(BlobId.of(this.getName(), blob, generation), options);
    }

    @TransportCompatibility(value={TransportCompatibility.Transport.HTTP})
    public List<Blob> get(String blobName1, String blobName2, String ... blobNames) {
        ArrayList<BlobId> blobIds = Lists.newArrayListWithCapacity(blobNames.length + 2);
        blobIds.add(BlobId.of(this.getName(), blobName1));
        blobIds.add(BlobId.of(this.getName(), blobName2));
        for (String blobName : blobNames) {
            blobIds.add(BlobId.of(this.getName(), blobName));
        }
        return this.storage.get(blobIds);
    }

    @TransportCompatibility(value={TransportCompatibility.Transport.HTTP})
    public List<Blob> get(Iterable<String> blobNames) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (String blobName : blobNames) {
            builder.add(BlobId.of(this.getName(), blobName));
        }
        return this.storage.get(builder.build());
    }

    @TransportCompatibility(value={TransportCompatibility.Transport.HTTP, TransportCompatibility.Transport.GRPC})
    public Blob create(String blob, byte[] content, String contentType, BlobTargetOption ... options) {
        BlobInfo blobInfo = BlobInfo.newBuilder(BlobId.of(this.getName(), blob)).setContentType(contentType).build();
        Storage.BlobTargetOption[] targetOptions = BlobTargetOption.toTargetOptions(blobInfo, options);
        return this.storage.create(blobInfo, content, targetOptions);
    }

    @TransportCompatibility(value={TransportCompatibility.Transport.HTTP, TransportCompatibility.Transport.GRPC})
    public Blob create(String blob, InputStream content, String contentType, BlobWriteOption ... options) {
        BlobInfo blobInfo = BlobInfo.newBuilder(BlobId.of(this.getName(), blob)).setContentType(contentType).build();
        Storage.BlobWriteOption[] writeOptions = BlobWriteOption.toWriteOptions(blobInfo, options);
        return this.storage.create(blobInfo, content, writeOptions);
    }

    @TransportCompatibility(value={TransportCompatibility.Transport.HTTP, TransportCompatibility.Transport.GRPC})
    public Blob create(String blob, byte[] content, BlobTargetOption ... options) {
        BlobInfo blobInfo = BlobInfo.newBuilder(BlobId.of(this.getName(), blob)).build();
        Storage.BlobTargetOption[] targetOptions = BlobTargetOption.toTargetOptions(blobInfo, options);
        return this.storage.create(blobInfo, content, targetOptions);
    }

    @TransportCompatibility(value={TransportCompatibility.Transport.HTTP, TransportCompatibility.Transport.GRPC})
    public Blob create(String blob, InputStream content, BlobWriteOption ... options) {
        BlobInfo blobInfo = BlobInfo.newBuilder(BlobId.of(this.getName(), blob)).build();
        Storage.BlobWriteOption[] write = BlobWriteOption.toWriteOptions(blobInfo, options);
        return this.storage.create(blobInfo, content, write);
    }

    @TransportCompatibility(value={TransportCompatibility.Transport.HTTP, TransportCompatibility.Transport.GRPC})
    public Acl getAcl(Acl.Entity entity) {
        return this.storage.getAcl(this.getName(), entity);
    }

    @TransportCompatibility(value={TransportCompatibility.Transport.HTTP, TransportCompatibility.Transport.GRPC})
    public boolean deleteAcl(Acl.Entity entity) {
        return this.storage.deleteAcl(this.getName(), entity);
    }

    @TransportCompatibility(value={TransportCompatibility.Transport.HTTP, TransportCompatibility.Transport.GRPC})
    public Acl createAcl(Acl acl) {
        return this.storage.createAcl(this.getName(), acl);
    }

    @TransportCompatibility(value={TransportCompatibility.Transport.HTTP, TransportCompatibility.Transport.GRPC})
    public Acl updateAcl(Acl acl) {
        return this.storage.updateAcl(this.getName(), acl);
    }

    @TransportCompatibility(value={TransportCompatibility.Transport.HTTP, TransportCompatibility.Transport.GRPC})
    public List<Acl> listAcls() {
        return this.storage.listAcls(this.getName());
    }

    @TransportCompatibility(value={TransportCompatibility.Transport.HTTP, TransportCompatibility.Transport.GRPC})
    public Acl getDefaultAcl(Acl.Entity entity) {
        return this.storage.getDefaultAcl(this.getName(), entity);
    }

    @TransportCompatibility(value={TransportCompatibility.Transport.HTTP, TransportCompatibility.Transport.GRPC})
    public boolean deleteDefaultAcl(Acl.Entity entity) {
        return this.storage.deleteDefaultAcl(this.getName(), entity);
    }

    @TransportCompatibility(value={TransportCompatibility.Transport.HTTP, TransportCompatibility.Transport.GRPC})
    public Acl createDefaultAcl(Acl acl) {
        return this.storage.createDefaultAcl(this.getName(), acl);
    }

    @TransportCompatibility(value={TransportCompatibility.Transport.HTTP, TransportCompatibility.Transport.GRPC})
    public Acl updateDefaultAcl(Acl acl) {
        return this.storage.updateDefaultAcl(this.getName(), acl);
    }

    @TransportCompatibility(value={TransportCompatibility.Transport.HTTP, TransportCompatibility.Transport.GRPC})
    public List<Acl> listDefaultAcls() {
        return this.storage.listDefaultAcls(this.getName());
    }

    @TransportCompatibility(value={TransportCompatibility.Transport.HTTP, TransportCompatibility.Transport.GRPC})
    public Bucket lockRetentionPolicy(Storage.BucketTargetOption ... options) {
        return this.storage.lockRetentionPolicy(this, options);
    }

    public Storage getStorage() {
        return this.storage;
    }

    @Override
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Override
    public final boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !obj.getClass().equals(Bucket.class)) {
            return false;
        }
        Bucket other = (Bucket)obj;
        return super.equals(other) && Objects.equals(this.options, other.options);
    }

    @Override
    public final int hashCode() {
        return Objects.hash(super.hashCode(), this.options);
    }

    public BucketInfo asBucketInfo() {
        return this.toBuilder().infoBuilder.build();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.storage = (Storage)this.options.getService();
    }

    @TransportCompatibility(value={TransportCompatibility.Transport.HTTP, TransportCompatibility.Transport.GRPC})
    public static class BucketSourceOption
    extends Option<UnifiedOpts.BucketSourceOpt> {
        private static final long serialVersionUID = 6765489853972162215L;

        private BucketSourceOption(UnifiedOpts.BucketSourceOpt opt) {
            super(opt);
        }

        @TransportCompatibility(value={TransportCompatibility.Transport.HTTP, TransportCompatibility.Transport.GRPC})
        public static BucketSourceOption metagenerationMatch() {
            return new BucketSourceOption(UnifiedOpts.metagenerationMatchExtractor());
        }

        @TransportCompatibility(value={TransportCompatibility.Transport.HTTP, TransportCompatibility.Transport.GRPC})
        public static BucketSourceOption metagenerationNotMatch() {
            return new BucketSourceOption(UnifiedOpts.metagenerationNotMatchExtractor());
        }

        @TransportCompatibility(value={TransportCompatibility.Transport.HTTP, TransportCompatibility.Transport.GRPC})
        public static BucketSourceOption userProject(@NonNull String userProject) {
            return new BucketSourceOption(UnifiedOpts.userProject(userProject));
        }

        public static BucketSourceOption[] dedupe(BucketSourceOption ... os) {
            return (BucketSourceOption[])Option.dedupe(BucketSourceOption[]::new, (Option[])os);
        }

        public static BucketSourceOption[] dedupe(Collection<BucketSourceOption> collection, BucketSourceOption ... os) {
            return (BucketSourceOption[])Option.dedupe(BucketSourceOption[]::new, collection, (Option[])os);
        }

        public static BucketSourceOption[] dedupe(BucketSourceOption[] array, BucketSourceOption ... os) {
            return (BucketSourceOption[])Option.dedupe(BucketSourceOption[]::new, (Option[])array, (Option[])os);
        }

        static Storage.BucketSourceOption[] toSourceOptions(BucketInfo bucketInfo, BucketSourceOption ... options) {
            Storage.BucketSourceOption[] convertedOptions = new Storage.BucketSourceOption[options.length];
            for (int i = 0; i < options.length; ++i) {
                UnifiedOpts.BucketSourceOpt opt = (UnifiedOpts.BucketSourceOpt)options[i].getOpt();
                if (opt instanceof UnifiedOpts.BucketOptExtractor) {
                    UnifiedOpts.BucketOptExtractor ex = (UnifiedOpts.BucketOptExtractor)opt;
                    UnifiedOpts.BucketSourceOpt bucketSourceOpt = (UnifiedOpts.BucketSourceOpt)ex.extractFromBucketInfo(bucketInfo);
                    convertedOptions[i] = new Storage.BucketSourceOption(bucketSourceOpt);
                    continue;
                }
                convertedOptions[i] = new Storage.BucketSourceOption((UnifiedOpts.BucketSourceOpt)options[i].getOpt());
            }
            return convertedOptions;
        }

        static Storage.BucketGetOption[] toGetOptions(BucketInfo bucketInfo, BucketSourceOption ... options) {
            Storage.BucketGetOption[] convertedOptions = new Storage.BucketGetOption[options.length];
            for (int i = 0; i < options.length; ++i) {
                UnifiedOpts.BucketSourceOpt opt = (UnifiedOpts.BucketSourceOpt)options[i].getOpt();
                if (opt instanceof UnifiedOpts.BucketOptExtractor) {
                    UnifiedOpts.BucketOptExtractor ex = (UnifiedOpts.BucketOptExtractor)opt;
                    UnifiedOpts.BucketSourceOpt bucketSourceOpt = (UnifiedOpts.BucketSourceOpt)ex.extractFromBucketInfo(bucketInfo);
                    convertedOptions[i] = new Storage.BucketGetOption(bucketSourceOpt);
                    continue;
                }
                convertedOptions[i] = new Storage.BucketGetOption((UnifiedOpts.BucketSourceOpt)options[i].getOpt());
            }
            return convertedOptions;
        }
    }

    public static class BlobTargetOption
    extends Option<UnifiedOpts.ObjectTargetOpt> {
        private static final long serialVersionUID = -7203767045761758606L;

        private BlobTargetOption(UnifiedOpts.ObjectTargetOpt opt) {
            super(opt);
        }

        @TransportCompatibility(value={TransportCompatibility.Transport.HTTP, TransportCompatibility.Transport.GRPC})
        public static BlobTargetOption predefinedAcl(@NonNull Storage.PredefinedAcl acl) {
            return new BlobTargetOption(UnifiedOpts.predefinedAcl(acl));
        }

        @TransportCompatibility(value={TransportCompatibility.Transport.HTTP, TransportCompatibility.Transport.GRPC})
        public static BlobTargetOption doesNotExist() {
            return new BlobTargetOption(UnifiedOpts.doesNotExist());
        }

        @TransportCompatibility(value={TransportCompatibility.Transport.HTTP, TransportCompatibility.Transport.GRPC})
        public static BlobTargetOption generationMatch(long generation) {
            return new BlobTargetOption(UnifiedOpts.generationMatch(generation));
        }

        @TransportCompatibility(value={TransportCompatibility.Transport.HTTP, TransportCompatibility.Transport.GRPC})
        public static BlobTargetOption generationNotMatch(long generation) {
            return new BlobTargetOption(UnifiedOpts.generationNotMatch(generation));
        }

        @TransportCompatibility(value={TransportCompatibility.Transport.HTTP, TransportCompatibility.Transport.GRPC})
        public static BlobTargetOption metagenerationMatch(long metageneration) {
            return new BlobTargetOption(UnifiedOpts.metagenerationMatch(metageneration));
        }

        @TransportCompatibility(value={TransportCompatibility.Transport.HTTP, TransportCompatibility.Transport.GRPC})
        public static BlobTargetOption metagenerationNotMatch(long metageneration) {
            return new BlobTargetOption(UnifiedOpts.metagenerationNotMatch(metageneration));
        }

        @TransportCompatibility(value={TransportCompatibility.Transport.HTTP, TransportCompatibility.Transport.GRPC})
        public static BlobTargetOption encryptionKey(@NonNull Key key) {
            return new BlobTargetOption(UnifiedOpts.encryptionKey(key));
        }

        @TransportCompatibility(value={TransportCompatibility.Transport.HTTP, TransportCompatibility.Transport.GRPC})
        public static BlobTargetOption encryptionKey(@NonNull String key) {
            return new BlobTargetOption(UnifiedOpts.encryptionKey(key));
        }

        @TransportCompatibility(value={TransportCompatibility.Transport.HTTP, TransportCompatibility.Transport.GRPC})
        public static BlobTargetOption kmsKeyName(@NonNull String kmsKeyName) {
            return new BlobTargetOption(UnifiedOpts.kmsKeyName(kmsKeyName));
        }

        @TransportCompatibility(value={TransportCompatibility.Transport.HTTP, TransportCompatibility.Transport.GRPC})
        public static BlobTargetOption userProject(@NonNull String userProject) {
            return new BlobTargetOption(UnifiedOpts.userProject(userProject));
        }

        @TransportCompatibility(value={TransportCompatibility.Transport.HTTP})
        public static BlobTargetOption overrideUnlockedRetention(boolean overrideUnlockedRetention) {
            return new BlobTargetOption(UnifiedOpts.overrideUnlockedRetention(overrideUnlockedRetention));
        }

        public static BlobTargetOption[] dedupe(BlobTargetOption ... os) {
            return (BlobTargetOption[])Option.dedupe(BlobTargetOption[]::new, (Option[])os);
        }

        public static BlobTargetOption[] dedupe(Collection<BlobTargetOption> collection, BlobTargetOption ... os) {
            return (BlobTargetOption[])Option.dedupe(BlobTargetOption[]::new, collection, (Option[])os);
        }

        public static BlobTargetOption[] dedupe(BlobTargetOption[] array, BlobTargetOption ... os) {
            return (BlobTargetOption[])Option.dedupe(BlobTargetOption[]::new, (Option[])array, (Option[])os);
        }

        static Storage.BlobTargetOption[] toTargetOptions(BlobInfo blobInfo, BlobTargetOption ... options) {
            Storage.BlobTargetOption[] targetOptions = new Storage.BlobTargetOption[options.length];
            for (int i = 0; i < options.length; ++i) {
                UnifiedOpts.ObjectTargetOpt opt = (UnifiedOpts.ObjectTargetOpt)options[i].getOpt();
                if (opt instanceof UnifiedOpts.ObjectOptExtractor) {
                    UnifiedOpts.ObjectOptExtractor ex = (UnifiedOpts.ObjectOptExtractor)opt;
                    UnifiedOpts.ObjectTargetOpt objectTargetOpt = (UnifiedOpts.ObjectTargetOpt)ex.extractFromBlobInfo(blobInfo);
                    targetOptions[i] = new Storage.BlobTargetOption(objectTargetOpt);
                    continue;
                }
                targetOptions[i] = new Storage.BlobTargetOption((UnifiedOpts.ObjectTargetOpt)options[i].getOpt());
            }
            return targetOptions;
        }
    }

    public static class BlobWriteOption
    extends Option<UnifiedOpts.ObjectTargetOpt>
    implements Serializable {
        private static final long serialVersionUID = 59762268190041584L;

        private BlobWriteOption(UnifiedOpts.ObjectTargetOpt opt) {
            super(opt);
        }

        @TransportCompatibility(value={TransportCompatibility.Transport.HTTP, TransportCompatibility.Transport.GRPC})
        public static BlobWriteOption predefinedAcl(@NonNull Storage.PredefinedAcl acl) {
            return new BlobWriteOption(UnifiedOpts.predefinedAcl(acl));
        }

        @TransportCompatibility(value={TransportCompatibility.Transport.HTTP, TransportCompatibility.Transport.GRPC})
        public static BlobWriteOption doesNotExist() {
            return new BlobWriteOption(UnifiedOpts.doesNotExist());
        }

        @TransportCompatibility(value={TransportCompatibility.Transport.HTTP, TransportCompatibility.Transport.GRPC})
        public static BlobWriteOption generationMatch(long generation) {
            return new BlobWriteOption(UnifiedOpts.generationMatch(generation));
        }

        @TransportCompatibility(value={TransportCompatibility.Transport.HTTP, TransportCompatibility.Transport.GRPC})
        public static BlobWriteOption generationNotMatch(long generation) {
            return new BlobWriteOption(UnifiedOpts.generationNotMatch(generation));
        }

        @TransportCompatibility(value={TransportCompatibility.Transport.HTTP, TransportCompatibility.Transport.GRPC})
        public static BlobWriteOption metagenerationMatch(long metageneration) {
            return new BlobWriteOption(UnifiedOpts.metagenerationMatch(metageneration));
        }

        @TransportCompatibility(value={TransportCompatibility.Transport.HTTP, TransportCompatibility.Transport.GRPC})
        public static BlobWriteOption metagenerationNotMatch(long metageneration) {
            return new BlobWriteOption(UnifiedOpts.metagenerationNotMatch(metageneration));
        }

        @TransportCompatibility(value={TransportCompatibility.Transport.HTTP, TransportCompatibility.Transport.GRPC})
        public static BlobWriteOption md5Match(@NonNull String md5) {
            return new BlobWriteOption(UnifiedOpts.md5Match(md5));
        }

        @TransportCompatibility(value={TransportCompatibility.Transport.HTTP, TransportCompatibility.Transport.GRPC})
        public static BlobWriteOption crc32cMatch(@NonNull String crc32c) {
            return new BlobWriteOption(UnifiedOpts.crc32cMatch(crc32c));
        }

        @TransportCompatibility(value={TransportCompatibility.Transport.HTTP, TransportCompatibility.Transport.GRPC})
        public static BlobWriteOption encryptionKey(@NonNull Key key) {
            return new BlobWriteOption(UnifiedOpts.encryptionKey(key));
        }

        @TransportCompatibility(value={TransportCompatibility.Transport.HTTP, TransportCompatibility.Transport.GRPC})
        public static BlobWriteOption encryptionKey(@NonNull String key) {
            return new BlobWriteOption(UnifiedOpts.encryptionKey(key));
        }

        @TransportCompatibility(value={TransportCompatibility.Transport.HTTP, TransportCompatibility.Transport.GRPC})
        public static BlobWriteOption userProject(@NonNull String userProject) {
            return new BlobWriteOption(UnifiedOpts.userProject(userProject));
        }

        public static BlobWriteOption[] dedupe(BlobWriteOption ... os) {
            return (BlobWriteOption[])Option.dedupe(BlobWriteOption[]::new, (Option[])os);
        }

        public static BlobWriteOption[] dedupe(Collection<BlobWriteOption> collection, BlobWriteOption ... os) {
            return (BlobWriteOption[])Option.dedupe(BlobWriteOption[]::new, collection, (Option[])os);
        }

        public static BlobWriteOption[] dedupe(BlobWriteOption[] array, BlobWriteOption ... os) {
            return (BlobWriteOption[])Option.dedupe(BlobWriteOption[]::new, (Option[])array, (Option[])os);
        }

        static Storage.BlobWriteOption[] toWriteOptions(BlobInfo blobInfo, BlobWriteOption ... options) {
            Storage.BlobWriteOption[] convertedOptions = new Storage.BlobWriteOption[options.length];
            for (int i = 0; i < options.length; ++i) {
                UnifiedOpts.ObjectTargetOpt opt = (UnifiedOpts.ObjectTargetOpt)options[i].getOpt();
                if (opt instanceof UnifiedOpts.ObjectOptExtractor) {
                    UnifiedOpts.ObjectOptExtractor ex = (UnifiedOpts.ObjectOptExtractor)opt;
                    UnifiedOpts.ObjectTargetOpt objectTargetOpt = (UnifiedOpts.ObjectTargetOpt)ex.extractFromBlobInfo(blobInfo);
                    convertedOptions[i] = new Storage.BlobWriteOption(objectTargetOpt);
                    continue;
                }
                convertedOptions[i] = new Storage.BlobWriteOption((UnifiedOpts.ObjectTargetOpt)options[i].getOpt());
            }
            return convertedOptions;
        }
    }

    public static class Builder
    extends BucketInfo.Builder {
        private final Storage storage;
        private final BucketInfo.BuilderImpl infoBuilder;

        Builder(Bucket bucket) {
            this.storage = bucket.storage;
            this.infoBuilder = new BucketInfo.BuilderImpl(bucket);
        }

        @Override
        public Builder setName(String name) {
            this.infoBuilder.setName(name);
            return this;
        }

        @Override
        Builder setProject(BigInteger project) {
            this.infoBuilder.setProject(project);
            return this;
        }

        @Override
        Builder setGeneratedId(String generatedId) {
            this.infoBuilder.setGeneratedId(generatedId);
            return this;
        }

        @Override
        Builder setOwner(Acl.Entity owner) {
            this.infoBuilder.setOwner(owner);
            return this;
        }

        @Override
        Builder setSelfLink(String selfLink) {
            this.infoBuilder.setSelfLink(selfLink);
            return this;
        }

        @Override
        public Builder setVersioningEnabled(Boolean enable) {
            this.infoBuilder.setVersioningEnabled(enable);
            return this;
        }

        @Override
        public Builder setRequesterPays(Boolean requesterPays) {
            this.infoBuilder.setRequesterPays(requesterPays);
            return this;
        }

        @Override
        public Builder setIndexPage(String indexPage) {
            this.infoBuilder.setIndexPage(indexPage);
            return this;
        }

        @Override
        public Builder setNotFoundPage(String notFoundPage) {
            this.infoBuilder.setNotFoundPage(notFoundPage);
            return this;
        }

        @Override
        @Deprecated
        public Builder setDeleteRules(Iterable<? extends BucketInfo.DeleteRule> rules) {
            this.infoBuilder.setDeleteRules(rules);
            return this;
        }

        @Override
        public Builder setLifecycleRules(Iterable<? extends BucketInfo.LifecycleRule> rules) {
            this.infoBuilder.setLifecycleRules(rules);
            return this;
        }

        @Override
        public Builder deleteLifecycleRules() {
            this.infoBuilder.deleteLifecycleRules();
            return this;
        }

        @Override
        public Builder setRpo(Rpo rpo) {
            this.infoBuilder.setRpo(rpo);
            return this;
        }

        @Override
        public Builder setStorageClass(StorageClass storageClass) {
            this.infoBuilder.setStorageClass(storageClass);
            return this;
        }

        @Override
        public Builder setLocation(String location) {
            this.infoBuilder.setLocation(location);
            return this;
        }

        @Override
        Builder setEtag(String etag) {
            this.infoBuilder.setEtag(etag);
            return this;
        }

        @Override
        @Deprecated
        Builder setCreateTime(Long createTime) {
            this.infoBuilder.setCreateTime(createTime);
            return this;
        }

        @Override
        BucketInfo.Builder setCreateTimeOffsetDateTime(OffsetDateTime createTime) {
            this.infoBuilder.setCreateTimeOffsetDateTime(createTime);
            return this;
        }

        @Override
        @Deprecated
        Builder setUpdateTime(Long updateTime) {
            this.infoBuilder.setUpdateTime(updateTime);
            return this;
        }

        @Override
        BucketInfo.Builder setUpdateTimeOffsetDateTime(OffsetDateTime updateTime) {
            this.infoBuilder.setUpdateTimeOffsetDateTime(updateTime);
            return this;
        }

        @Override
        Builder setMetageneration(Long metageneration) {
            this.infoBuilder.setMetageneration(metageneration);
            return this;
        }

        @Override
        public Builder setCors(Iterable<Cors> cors) {
            this.infoBuilder.setCors(cors);
            return this;
        }

        @Override
        public Builder setAcl(Iterable<Acl> acl) {
            this.infoBuilder.setAcl(acl);
            return this;
        }

        @Override
        public Builder setDefaultAcl(Iterable<Acl> acl) {
            this.infoBuilder.setDefaultAcl(acl);
            return this;
        }

        @Override
        public Builder setLabels(@Nullable Map<@NonNull String, @Nullable String> labels) {
            this.infoBuilder.setLabels(labels);
            return this;
        }

        @Override
        public Builder setDefaultKmsKeyName(String defaultKmsKeyName) {
            this.infoBuilder.setDefaultKmsKeyName(defaultKmsKeyName);
            return this;
        }

        @Override
        public Builder setDefaultEventBasedHold(Boolean defaultEventBasedHold) {
            this.infoBuilder.setDefaultEventBasedHold(defaultEventBasedHold);
            return this;
        }

        @Override
        @Deprecated
        Builder setRetentionEffectiveTime(Long retentionEffectiveTime) {
            this.infoBuilder.setRetentionEffectiveTime(retentionEffectiveTime);
            return this;
        }

        @Override
        BucketInfo.Builder setRetentionEffectiveTimeOffsetDateTime(OffsetDateTime retentionEffectiveTime) {
            this.infoBuilder.setRetentionEffectiveTimeOffsetDateTime(retentionEffectiveTime);
            return this;
        }

        @Override
        Builder setRetentionPolicyIsLocked(Boolean retentionIsLocked) {
            this.infoBuilder.setRetentionPolicyIsLocked(retentionIsLocked);
            return this;
        }

        @Override
        @Deprecated
        public Builder setRetentionPeriod(Long retentionPeriod) {
            this.infoBuilder.setRetentionPeriod(retentionPeriod);
            return this;
        }

        @Override
        public BucketInfo.Builder setRetentionPeriodDuration(Duration retentionPeriod) {
            this.infoBuilder.setRetentionPeriodDuration(retentionPeriod);
            return this;
        }

        @Override
        public Builder setIamConfiguration(BucketInfo.IamConfiguration iamConfiguration) {
            this.infoBuilder.setIamConfiguration(iamConfiguration);
            return this;
        }

        @Override
        public Builder setAutoclass(BucketInfo.Autoclass autoclass) {
            this.infoBuilder.setAutoclass(autoclass);
            return this;
        }

        @Override
        public Builder setLogging(BucketInfo.Logging logging) {
            this.infoBuilder.setLogging(logging);
            return this;
        }

        @Override
        Builder setLocationType(String locationType) {
            this.infoBuilder.setLocationType(locationType);
            return this;
        }

        @Override
        public Builder setCustomPlacementConfig(BucketInfo.CustomPlacementConfig customPlacementConfig) {
            this.infoBuilder.setCustomPlacementConfig(customPlacementConfig);
            return this;
        }

        @Override
        Builder setObjectRetention(BucketInfo.ObjectRetention objectRetention) {
            this.infoBuilder.setObjectRetention(objectRetention);
            return this;
        }

        @Override
        public Builder setSoftDeletePolicy(BucketInfo.SoftDeletePolicy softDeletePolicy) {
            this.infoBuilder.setSoftDeletePolicy(softDeletePolicy);
            return this;
        }

        @Override
        public Builder setHierarchicalNamespace(BucketInfo.HierarchicalNamespace hierarchicalNamespace) {
            this.infoBuilder.setHierarchicalNamespace(hierarchicalNamespace);
            return this;
        }

        @Override
        public Builder setIpFilter(BucketInfo.IpFilter ipFilter) {
            this.infoBuilder.setIpFilter(ipFilter);
            return this;
        }

        @Override
        public Builder setGoogleManagedEncryptionEnforcementConfig(BucketInfo.GoogleManagedEncryptionEnforcementConfig googleManagedEncryptionEnforcementConfig) {
            this.infoBuilder.setGoogleManagedEncryptionEnforcementConfig(googleManagedEncryptionEnforcementConfig);
            return this;
        }

        @Override
        public Builder setCustomerManagedEncryptionEnforcementConfig(BucketInfo.CustomerManagedEncryptionEnforcementConfig customerManagedEncryptionEnforcementConfig) {
            this.infoBuilder.setCustomerManagedEncryptionEnforcementConfig(customerManagedEncryptionEnforcementConfig);
            return this;
        }

        @Override
        public Builder setCustomerSuppliedEncryptionEnforcementConfig(BucketInfo.CustomerSuppliedEncryptionEnforcementConfig customerSuppliedEncryptionEnforcementConfig) {
            this.infoBuilder.setCustomerSuppliedEncryptionEnforcementConfig(customerSuppliedEncryptionEnforcementConfig);
            return this;
        }

        @Override
        public Bucket build() {
            return new Bucket(this.storage, this.infoBuilder);
        }

        @Override
        Builder clearGeneratedId() {
            this.infoBuilder.clearGeneratedId();
            return this;
        }

        @Override
        Builder clearProject() {
            this.infoBuilder.clearProject();
            return this;
        }

        @Override
        Builder clearName() {
            this.infoBuilder.clearName();
            return this;
        }

        @Override
        Builder clearOwner() {
            this.infoBuilder.clearOwner();
            return this;
        }

        @Override
        Builder clearSelfLink() {
            this.infoBuilder.clearSelfLink();
            return this;
        }

        @Override
        Builder clearRequesterPays() {
            this.infoBuilder.clearRequesterPays();
            return this;
        }

        @Override
        Builder clearVersioningEnabled() {
            this.infoBuilder.clearVersioningEnabled();
            return this;
        }

        @Override
        Builder clearIndexPage() {
            this.infoBuilder.clearIndexPage();
            return this;
        }

        @Override
        Builder clearNotFoundPage() {
            this.infoBuilder.clearNotFoundPage();
            return this;
        }

        @Override
        Builder clearLifecycleRules() {
            this.infoBuilder.clearLifecycleRules();
            return this;
        }

        @Override
        Builder clearRpo() {
            this.infoBuilder.clearRpo();
            return this;
        }

        @Override
        Builder clearStorageClass() {
            this.infoBuilder.clearStorageClass();
            return this;
        }

        @Override
        Builder clearLocation() {
            this.infoBuilder.clearLocation();
            return this;
        }

        @Override
        Builder clearEtag() {
            this.infoBuilder.clearEtag();
            return this;
        }

        @Override
        Builder clearCreateTime() {
            this.infoBuilder.clearCreateTime();
            return this;
        }

        @Override
        Builder clearUpdateTime() {
            this.infoBuilder.clearUpdateTime();
            return this;
        }

        @Override
        Builder clearMetageneration() {
            this.infoBuilder.clearMetageneration();
            return this;
        }

        @Override
        Builder clearCors() {
            this.infoBuilder.clearCors();
            return this;
        }

        @Override
        Builder clearAcl() {
            this.infoBuilder.clearAcl();
            return this;
        }

        @Override
        Builder clearDefaultAcl() {
            this.infoBuilder.clearDefaultAcl();
            return this;
        }

        @Override
        Builder clearLabels() {
            this.infoBuilder.clearLabels();
            return this;
        }

        @Override
        Builder clearDefaultKmsKeyName() {
            this.infoBuilder.clearDefaultKmsKeyName();
            return this;
        }

        @Override
        Builder clearDefaultEventBasedHold() {
            this.infoBuilder.clearDefaultEventBasedHold();
            return this;
        }

        @Override
        Builder clearRetentionEffectiveTime() {
            this.infoBuilder.clearRetentionEffectiveTime();
            return this;
        }

        @Override
        Builder clearRetentionPolicyIsLocked() {
            this.infoBuilder.clearRetentionPolicyIsLocked();
            return this;
        }

        @Override
        Builder clearRetentionPeriod() {
            this.infoBuilder.clearRetentionPeriod();
            return this;
        }

        @Override
        Builder clearIamConfiguration() {
            this.infoBuilder.clearIamConfiguration();
            return this;
        }

        @Override
        Builder clearLocationType() {
            this.infoBuilder.clearLocationType();
            return this;
        }

        @Override
        Builder clearLogging() {
            this.infoBuilder.clearLogging();
            return this;
        }

        @Override
        Builder clearCustomPlacementConfig() {
            this.infoBuilder.clearCustomPlacementConfig();
            return this;
        }

        @Override
        Builder clearIpFilter() {
            this.infoBuilder.clearIpFilter();
            return this;
        }

        @Override
        public Builder clearGoogleManagedEncryptionEnforcementConfig() {
            this.infoBuilder.clearGoogleManagedEncryptionEnforcementConfig();
            return this;
        }

        @Override
        public Builder clearCustomerManagedEncryptionEnforcementConfig() {
            this.infoBuilder.clearCustomerManagedEncryptionEnforcementConfig();
            return this;
        }

        @Override
        public Builder clearCustomerSuppliedEncryptionEnforcementConfig() {
            this.infoBuilder.clearCustomerSuppliedEncryptionEnforcementConfig();
            return this;
        }
    }
}

