/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.storage;

import com.google.api.gax.retrying.RetrySettings;
import com.google.cloud.storage.Durations;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.time.Duration;
import java.util.Objects;
import java.util.concurrent.ThreadLocalRandom;

final class Backoff {
    private final Duration initialBackoff;
    private final Duration maxBackoff;
    private final Duration timeout;
    private final double retryDelayMultiplier;
    private final Jitterer jitterer;
    private Duration cumulativeBackoff;
    private Duration previousBackoff;

    private Backoff(Duration initialBackoff, double backoffDelayMultiplier, Duration maxBackoff, Duration timeout, Jitterer jitterer) {
        this.initialBackoff = initialBackoff;
        this.maxBackoff = maxBackoff;
        this.timeout = timeout;
        this.jitterer = jitterer;
        this.retryDelayMultiplier = backoffDelayMultiplier;
        this.cumulativeBackoff = Duration.ZERO;
        this.previousBackoff = Duration.ZERO;
    }

    BackoffResult nextBackoff(Duration elapsed) {
        Duration cappedBackoff;
        Duration cumulativeAndElapsed;
        Preconditions.checkArgument(Durations.gtEq(elapsed, Duration.ZERO), "elapsed must be >= PT0S (%s >= %s)", (Object)elapsed, (Object)Duration.ZERO);
        this.cumulativeBackoff = cumulativeAndElapsed = this.cumulativeBackoff.plus(elapsed);
        if (Durations.gtEq(cumulativeAndElapsed, this.timeout)) {
            return BackoffResults.EXHAUSTED;
        }
        Duration nextDelay = Duration.ofNanos(Math.round((double)this.previousBackoff.toNanos() * this.retryDelayMultiplier));
        if (Durations.eq(nextDelay, Duration.ZERO)) {
            nextDelay = this.initialBackoff;
        }
        Duration nextBackoffWithJitter = this.jitterer.jitter(nextDelay);
        Duration remainingUtilTimeout = this.timeout.minus(cumulativeAndElapsed);
        this.previousBackoff = cappedBackoff = Durations.min(nextBackoffWithJitter, this.maxBackoff, remainingUtilTimeout);
        return BackoffDuration.of(cappedBackoff);
    }

    void reset() {
        this.cumulativeBackoff = Duration.ZERO;
        this.previousBackoff = Duration.ZERO;
    }

    Duration getCumulativeBackoff() {
        return this.cumulativeBackoff;
    }

    Duration getTimeout() {
        return this.timeout;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Backoff)) {
            return false;
        }
        Backoff backoff = (Backoff)o;
        return Double.compare(this.retryDelayMultiplier, backoff.retryDelayMultiplier) == 0 && Objects.equals(this.initialBackoff, backoff.initialBackoff) && Objects.equals(this.maxBackoff, backoff.maxBackoff) && Objects.equals(this.timeout, backoff.timeout) && Objects.equals(this.jitterer, backoff.jitterer) && Objects.equals(this.cumulativeBackoff, backoff.cumulativeBackoff);
    }

    public int hashCode() {
        return Objects.hash(this.initialBackoff, this.maxBackoff, this.timeout, this.retryDelayMultiplier, this.jitterer, this.cumulativeBackoff);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("previousBackoff", this.previousBackoff).add("cumulativeBackoff", this.cumulativeBackoff).add("initialBackoff", this.initialBackoff).add("maxBackoff", this.maxBackoff).add("timeout", this.timeout).add("retryDelayMultiplier", this.retryDelayMultiplier).add("jitterer", this.jitterer).toString();
    }

    static Builder from(RetrySettings retrySettings) {
        return Backoff.newBuilder().setInitialBackoff(retrySettings.getInitialRetryDelayDuration()).setRetryDelayMultiplier(retrySettings.getRetryDelayMultiplier()).setMaxBackoff(retrySettings.getMaxRetryDelayDuration()).setTimeout(retrySettings.getTotalTimeoutDuration());
    }

    static Builder newBuilder() {
        return new Builder();
    }

    @FunctionalInterface
    static interface Jitterer {
        public Duration jitter(Duration var1);

        public static Jitterer threadLocalRandom() {
            return ThreadLocalRandomJitterer.INSTANCE;
        }

        @VisibleForTesting
        public static Jitterer noJitter() {
            return NoJitter.INSTANCE;
        }
    }

    static enum BackoffResults implements BackoffResult
    {
        EXHAUSTED;


        @Override
        public String errorString() {
            return this.name();
        }
    }

    static final class BackoffDuration
    implements BackoffResult {
        private final Duration duration;

        private BackoffDuration(Duration duration) {
            this.duration = duration;
        }

        Duration getDuration() {
            return this.duration;
        }

        @Override
        public String errorString() {
            return this.duration.toString();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof BackoffDuration)) {
                return false;
            }
            BackoffDuration that = (BackoffDuration)o;
            return Objects.equals(this.duration, that.duration);
        }

        public int hashCode() {
            return Objects.hashCode(this.duration);
        }

        public String toString() {
            return MoreObjects.toStringHelper(this).add("duration", this.duration).toString();
        }

        static BackoffDuration of(Duration duration) {
            return new BackoffDuration(duration);
        }
    }

    static final class Builder {
        private Duration initialBackoff;
        private Duration maxBackoff;
        private Duration timeout;
        private double retryDelayMultiplier;
        private Jitterer jitterer;

        private Builder() {
        }

        Builder setInitialBackoff(Duration initialBackoff) {
            this.initialBackoff = initialBackoff;
            return this;
        }

        Builder setMaxBackoff(Duration maxBackoff) {
            this.maxBackoff = maxBackoff;
            return this;
        }

        Builder setTimeout(Duration timeout) {
            this.timeout = timeout;
            return this;
        }

        Builder setRetryDelayMultiplier(double retryDelayMultiplier) {
            this.retryDelayMultiplier = retryDelayMultiplier;
            return this;
        }

        Builder setJitterer(Jitterer jitterer) {
            this.jitterer = jitterer;
            return this;
        }

        Backoff build() {
            Preconditions.checkState(this.retryDelayMultiplier >= 1.0, "retryDelayMultiplier must be >= 1.0");
            Duration effectiveTimeout = Objects.requireNonNull(this.timeout, "timeout must be non null");
            if (Durations.ltEq(effectiveTimeout, Duration.ZERO)) {
                effectiveTimeout = Durations.EFFECTIVE_INFINITY;
            }
            return new Backoff(Objects.requireNonNull(this.initialBackoff, "initialBackoff must be non null"), this.retryDelayMultiplier, Objects.requireNonNull(this.maxBackoff, "maxBackoff must be non null"), effectiveTimeout, Objects.requireNonNull(this.jitterer, "jitterer must be non null"));
        }
    }

    private static final class NoJitter
    implements Jitterer {
        private static final NoJitter INSTANCE = new NoJitter();

        private NoJitter() {
        }

        @Override
        public Duration jitter(Duration baseline) {
            return baseline;
        }
    }

    private static final class ThreadLocalRandomJitterer
    implements Jitterer {
        private static final ThreadLocalRandomJitterer INSTANCE = new ThreadLocalRandomJitterer();

        private ThreadLocalRandomJitterer() {
        }

        @Override
        public Duration jitter(Duration baseline) {
            if (Durations.gt(baseline, Duration.ZERO)) {
                long nanos = baseline.toNanos();
                long randNanos = ThreadLocalRandom.current().nextLong(nanos);
                return baseline.plusNanos(randNanos);
            }
            return baseline;
        }
    }

    static interface BackoffResult {
        public String errorString();
    }
}

