/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.xds.internal.security.certprovider;

import com.google.common.base.Preconditions;
import io.grpc.netty.shaded.io.grpc.netty.GrpcSslContexts;
import io.grpc.netty.shaded.io.netty.handler.ssl.SslContextBuilder;
import io.grpc.xds.EnvoyServerProtoData;
import io.grpc.xds.client.Bootstrapper;
import io.grpc.xds.internal.security.certprovider.CertProviderSslContextProvider;
import io.grpc.xds.internal.security.certprovider.CertificateProviderStore;
import io.grpc.xds.internal.security.trust.XdsTrustManagerFactory;
import io.grpc.xds.shaded.io.envoyproxy.envoy.config.core.v3.Node;
import io.grpc.xds.shaded.io.envoyproxy.envoy.extensions.transport_sockets.tls.v3.CertificateValidationContext;
import io.grpc.xds.shaded.io.envoyproxy.envoy.extensions.transport_sockets.tls.v3.CommonTlsContext;
import java.io.IOException;
import java.security.cert.CertStoreException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Map;
import javax.annotation.Nullable;

final class CertProviderServerSslContextProvider
extends CertProviderSslContextProvider {
    CertProviderServerSslContextProvider(Node node, @Nullable Map<String, Bootstrapper.CertificateProviderInfo> certProviders, CommonTlsContext.CertificateProviderInstance certInstance, CommonTlsContext.CertificateProviderInstance rootCertInstance, CertificateValidationContext staticCertValidationContext, EnvoyServerProtoData.DownstreamTlsContext downstreamTlsContext, CertificateProviderStore certificateProviderStore) {
        super(node, certProviders, Preconditions.checkNotNull(certInstance, "Server SSL requires certInstance"), rootCertInstance, staticCertValidationContext, downstreamTlsContext, certificateProviderStore);
    }

    @Override
    protected final SslContextBuilder getSslContextBuilder(CertificateValidationContext certificateValidationContextdationContext) throws CertStoreException, CertificateException, IOException {
        SslContextBuilder sslContextBuilder = SslContextBuilder.forServer(this.savedKey, this.savedCertChain);
        XdsTrustManagerFactory trustManagerFactory = null;
        if (this.isMtls() && this.savedSpiffeTrustMap != null) {
            trustManagerFactory = new XdsTrustManagerFactory(this.savedSpiffeTrustMap, certificateValidationContextdationContext);
        } else if (this.isMtls()) {
            trustManagerFactory = new XdsTrustManagerFactory(this.savedTrustedRoots.toArray(new X509Certificate[0]), certificateValidationContextdationContext);
        }
        this.setClientAuthValues(sslContextBuilder, trustManagerFactory);
        sslContextBuilder = GrpcSslContexts.configure(sslContextBuilder);
        return sslContextBuilder;
    }
}

