/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.xds;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.protobuf.Any;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;
import com.google.protobuf.util.Durations;
import io.grpc.CallOptions;
import io.grpc.Channel;
import io.grpc.ClientCall;
import io.grpc.ClientInterceptor;
import io.grpc.Context;
import io.grpc.Deadline;
import io.grpc.ForwardingClientCall;
import io.grpc.ForwardingClientCallListener;
import io.grpc.Metadata;
import io.grpc.MethodDescriptor;
import io.grpc.Status;
import io.grpc.internal.DelayedClientCall;
import io.grpc.internal.GrpcUtil;
import io.grpc.xds.ConfigOrError;
import io.grpc.xds.FaultConfig;
import io.grpc.xds.Filter;
import io.grpc.xds.ThreadSafeRandom;
import io.grpc.xds.shaded.io.envoyproxy.envoy.extensions.filters.common.fault.v3.FaultDelay;
import io.grpc.xds.shaded.io.envoyproxy.envoy.extensions.filters.http.fault.v3.FaultAbort;
import io.grpc.xds.shaded.io.envoyproxy.envoy.extensions.filters.http.fault.v3.HTTPFault;
import io.grpc.xds.shaded.io.envoyproxy.envoy.type.v3.FractionalPercent;
import java.util.Locale;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.Nullable;

final class FaultFilter
implements Filter,
Filter.ClientInterceptorBuilder {
    static final FaultFilter INSTANCE = new FaultFilter(ThreadSafeRandom.ThreadSafeRandomImpl.instance, new AtomicLong());
    @VisibleForTesting
    static final Metadata.Key<String> HEADER_DELAY_KEY = Metadata.Key.of("x-envoy-fault-delay-request", Metadata.ASCII_STRING_MARSHALLER);
    @VisibleForTesting
    static final Metadata.Key<String> HEADER_DELAY_PERCENTAGE_KEY = Metadata.Key.of("x-envoy-fault-delay-request-percentage", Metadata.ASCII_STRING_MARSHALLER);
    @VisibleForTesting
    static final Metadata.Key<String> HEADER_ABORT_HTTP_STATUS_KEY = Metadata.Key.of("x-envoy-fault-abort-request", Metadata.ASCII_STRING_MARSHALLER);
    @VisibleForTesting
    static final Metadata.Key<String> HEADER_ABORT_GRPC_STATUS_KEY = Metadata.Key.of("x-envoy-fault-abort-grpc-request", Metadata.ASCII_STRING_MARSHALLER);
    @VisibleForTesting
    static final Metadata.Key<String> HEADER_ABORT_PERCENTAGE_KEY = Metadata.Key.of("x-envoy-fault-abort-request-percentage", Metadata.ASCII_STRING_MARSHALLER);
    static final String TYPE_URL = "type.googleapis.com/envoy.extensions.filters.http.fault.v3.HTTPFault";
    private final ThreadSafeRandom random;
    private final AtomicLong activeFaultCounter;

    @VisibleForTesting
    FaultFilter(ThreadSafeRandom random, AtomicLong activeFaultCounter) {
        this.random = random;
        this.activeFaultCounter = activeFaultCounter;
    }

    @Override
    public String[] typeUrls() {
        return new String[]{TYPE_URL};
    }

    public ConfigOrError<FaultConfig> parseFilterConfig(Message rawProtoMessage) {
        HTTPFault httpFaultProto;
        if (!(rawProtoMessage instanceof Any)) {
            return ConfigOrError.fromError("Invalid config type: " + rawProtoMessage.getClass());
        }
        Any anyMessage = (Any)rawProtoMessage;
        try {
            httpFaultProto = anyMessage.unpack(HTTPFault.class);
        }
        catch (InvalidProtocolBufferException e) {
            return ConfigOrError.fromError("Invalid proto: " + e);
        }
        return FaultFilter.parseHttpFault(httpFaultProto);
    }

    private static ConfigOrError<FaultConfig> parseHttpFault(HTTPFault httpFault) {
        FaultConfig.FaultDelay faultDelay = null;
        FaultConfig.FaultAbort faultAbort = null;
        if (httpFault.hasDelay()) {
            faultDelay = FaultFilter.parseFaultDelay(httpFault.getDelay());
        }
        if (httpFault.hasAbort()) {
            ConfigOrError<FaultConfig.FaultAbort> faultAbortOrError = FaultFilter.parseFaultAbort(httpFault.getAbort());
            if (faultAbortOrError.errorDetail != null) {
                return ConfigOrError.fromError("HttpFault contains invalid FaultAbort: " + faultAbortOrError.errorDetail);
            }
            faultAbort = (FaultConfig.FaultAbort)faultAbortOrError.config;
        }
        Integer maxActiveFaults = null;
        if (httpFault.hasMaxActiveFaults() && (maxActiveFaults = Integer.valueOf(httpFault.getMaxActiveFaults().getValue())) < 0) {
            maxActiveFaults = Integer.MAX_VALUE;
        }
        return ConfigOrError.fromConfig(FaultConfig.create(faultDelay, faultAbort, maxActiveFaults));
    }

    private static FaultConfig.FaultDelay parseFaultDelay(FaultDelay faultDelay) {
        FaultConfig.FractionalPercent percent = FaultFilter.parsePercent(faultDelay.getPercentage());
        if (faultDelay.hasHeaderDelay()) {
            return FaultConfig.FaultDelay.forHeader(percent);
        }
        return FaultConfig.FaultDelay.forFixedDelay(Durations.toNanos(faultDelay.getFixedDelay()), percent);
    }

    @VisibleForTesting
    static ConfigOrError<FaultConfig.FaultAbort> parseFaultAbort(FaultAbort faultAbort) {
        FaultConfig.FractionalPercent percent = FaultFilter.parsePercent(faultAbort.getPercentage());
        switch (faultAbort.getErrorTypeCase()) {
            case HEADER_ABORT: {
                return ConfigOrError.fromConfig(FaultConfig.FaultAbort.forHeader(percent));
            }
            case HTTP_STATUS: {
                return ConfigOrError.fromConfig(FaultConfig.FaultAbort.forStatus(GrpcUtil.httpStatusToGrpcStatus(faultAbort.getHttpStatus()), percent));
            }
            case GRPC_STATUS: {
                return ConfigOrError.fromConfig(FaultConfig.FaultAbort.forStatus(Status.fromCodeValue(faultAbort.getGrpcStatus()), percent));
            }
        }
        return ConfigOrError.fromError("Unknown error type case: " + faultAbort.getErrorTypeCase());
    }

    private static FaultConfig.FractionalPercent parsePercent(FractionalPercent proto) {
        switch (proto.getDenominator()) {
            case HUNDRED: {
                return FaultConfig.FractionalPercent.perHundred(proto.getNumerator());
            }
            case TEN_THOUSAND: {
                return FaultConfig.FractionalPercent.perTenThousand(proto.getNumerator());
            }
            case MILLION: {
                return FaultConfig.FractionalPercent.perMillion(proto.getNumerator());
            }
        }
        throw new IllegalArgumentException("Unknown denominator type: " + proto.getDenominator());
    }

    public ConfigOrError<FaultConfig> parseFilterConfigOverride(Message rawProtoMessage) {
        return this.parseFilterConfig(rawProtoMessage);
    }

    @Override
    @Nullable
    public ClientInterceptor buildClientInterceptor(Filter.FilterConfig config, @Nullable Filter.FilterConfig overrideConfig, final ScheduledExecutorService scheduler) {
        Preconditions.checkNotNull(config, "config");
        if (overrideConfig != null) {
            config = overrideConfig;
        }
        final FaultConfig faultConfig = (FaultConfig)config;
        final class FaultInjectionInterceptor
        implements ClientInterceptor {
            FaultInjectionInterceptor() {
            }

            @Override
            public <ReqT, RespT> ClientCall<ReqT, RespT> interceptCall(final MethodDescriptor<ReqT, RespT> method, final CallOptions callOptions, final Channel next) {
                boolean checkFault = false;
                if (faultConfig.maxActiveFaults() == null || FaultFilter.this.activeFaultCounter.get() < (long)faultConfig.maxActiveFaults().intValue()) {
                    boolean bl = checkFault = faultConfig.faultDelay() != null || faultConfig.faultAbort() != null;
                }
                if (!checkFault) {
                    return next.newCall(method, callOptions);
                }
                final class DeadlineInsightForwardingCall
                extends ForwardingClientCall<ReqT, RespT> {
                    private ClientCall<ReqT, RespT> delegate;

                    DeadlineInsightForwardingCall() {
                    }

                    @Override
                    protected ClientCall<ReqT, RespT> delegate() {
                        return this.delegate;
                    }

                    @Override
                    public void start(ClientCall.Listener<RespT> listener, Metadata headers) {
                        Executor callExecutor = callOptions.getExecutor();
                        if (callExecutor == null) {
                            callExecutor = MoreExecutors.directExecutor();
                        }
                        Status abortStatus = null;
                        final Long delayNanos = faultConfig.faultDelay() != null ? FaultFilter.this.determineFaultDelayNanos(faultConfig.faultDelay(), headers) : null;
                        if (faultConfig.faultAbort() != null) {
                            abortStatus = FaultFilter.getAbortStatusWithDescription(FaultFilter.this.determineFaultAbortStatus(faultConfig.faultAbort(), headers));
                        }
                        Supplier callSupplier = abortStatus != null ? Suppliers.ofInstance(new FailingClientCall(abortStatus, callExecutor)) : new Supplier<ClientCall<ReqT, RespT>>(){

                            @Override
                            public ClientCall<ReqT, RespT> get() {
                                return next.newCall(method, callOptions);
                            }
                        };
                        if (delayNanos == null) {
                            this.delegate = (ClientCall)callSupplier.get();
                            this.delegate().start(listener, headers);
                            return;
                        }
                        this.delegate = new DelayInjectedCall(delayNanos, callExecutor, scheduler, callOptions.getDeadline(), callSupplier);
                        ForwardingClientCallListener.SimpleForwardingClientCallListener finalListener = new ForwardingClientCallListener.SimpleForwardingClientCallListener<RespT>(listener){

                            @Override
                            public void onClose(Status status, Metadata trailers) {
                                if (status.getCode().equals((Object)Status.Code.DEADLINE_EXCEEDED)) {
                                    String description = String.format(Locale.US, "Deadline exceeded after up to %d ns of fault-injected delay", delayNanos);
                                    if (status.getDescription() != null) {
                                        description = description + ": " + status.getDescription();
                                    }
                                    status = Status.DEADLINE_EXCEEDED.withDescription(description).withCause(status.getCause());
                                    trailers = new Metadata();
                                }
                                this.delegate().onClose(status, trailers);
                            }
                        };
                        this.delegate().start(finalListener, headers);
                    }
                }
                return new DeadlineInsightForwardingCall();
            }
        }
        return new FaultInjectionInterceptor();
    }

    private static Status getAbortStatusWithDescription(Status abortStatus) {
        Status finalAbortStatus = null;
        if (abortStatus != null) {
            String abortDesc = "RPC terminated due to fault injection";
            if (abortStatus.getDescription() != null) {
                abortDesc = abortDesc + ": " + abortStatus.getDescription();
            }
            finalAbortStatus = abortStatus.withDescription(abortDesc);
        }
        return finalAbortStatus;
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    private Long determineFaultDelayNanos(FaultConfig.FaultDelay faultDelay, Metadata headers) {
        fractionalPercent = faultDelay.percent();
        if (faultDelay.headerDelay()) {
            try {
                delayMillis = Integer.parseInt(headers.get(FaultFilter.HEADER_DELAY_KEY));
                delayNanos = TimeUnit.MILLISECONDS.toNanos(delayMillis);
                delayPercentageStr = headers.get(FaultFilter.HEADER_DELAY_PERCENTAGE_KEY);
                if (delayPercentageStr == null || (delayPercentage = Integer.parseInt(delayPercentageStr)) < 0 || delayPercentage >= fractionalPercent.numerator()) ** GOTO lbl13
                fractionalPercent = FaultConfig.FractionalPercent.create(delayPercentage, fractionalPercent.denominatorType());
            }
            catch (NumberFormatException e) {
                return null;
            }
        } else {
            delayNanos = faultDelay.delayNanos();
        }
lbl13:
        // 3 sources

        if (this.random.nextInt(1000000) >= FaultFilter.getRatePerMillion(fractionalPercent)) {
            return null;
        }
        return delayNanos;
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    private Status determineFaultAbortStatus(FaultConfig.FaultAbort faultAbort, Metadata headers) {
        abortStatus = null;
        fractionalPercent = faultAbort.percent();
        if (faultAbort.headerAbort()) {
            try {
                grpcCodeStr = headers.get(FaultFilter.HEADER_ABORT_GRPC_STATUS_KEY);
                if (grpcCodeStr != null) {
                    grpcCode = Integer.parseInt(grpcCodeStr);
                    abortStatus = Status.fromCodeValue(grpcCode);
                }
                if ((httpCodeStr = headers.get(FaultFilter.HEADER_ABORT_HTTP_STATUS_KEY)) != null) {
                    httpCode = Integer.parseInt(httpCodeStr);
                    abortStatus = GrpcUtil.httpStatusToGrpcStatus(httpCode);
                }
                if ((abortPercentageStr = headers.get(FaultFilter.HEADER_ABORT_PERCENTAGE_KEY)) == null || (abortPercentage = Integer.parseInt(headers.get(FaultFilter.HEADER_ABORT_PERCENTAGE_KEY))) < 0 || abortPercentage >= fractionalPercent.numerator()) ** GOTO lbl18
                fractionalPercent = FaultConfig.FractionalPercent.create(abortPercentage, fractionalPercent.denominatorType());
            }
            catch (NumberFormatException e) {
                return null;
            }
        } else {
            abortStatus = faultAbort.status();
        }
lbl18:
        // 3 sources

        if (this.random.nextInt(1000000) >= FaultFilter.getRatePerMillion(fractionalPercent)) {
            return null;
        }
        return abortStatus;
    }

    private static int getRatePerMillion(FaultConfig.FractionalPercent percent) {
        int numerator = percent.numerator();
        FaultConfig.FractionalPercent.DenominatorType type = percent.denominatorType();
        switch (type) {
            case TEN_THOUSAND: {
                numerator *= 100;
                break;
            }
            case HUNDRED: {
                numerator *= 10000;
                break;
            }
        }
        if (numerator > 1000000 || numerator < 0) {
            numerator = 1000000;
        }
        return numerator;
    }

    private final class FailingClientCall<ReqT, RespT>
    extends ClientCall<ReqT, RespT> {
        final Status error;
        final Executor callExecutor;
        final Context context;

        FailingClientCall(Status error, Executor callExecutor) {
            this.error = error;
            this.callExecutor = callExecutor;
            this.context = Context.current();
        }

        @Override
        public void start(final ClientCall.Listener<RespT> listener, Metadata headers) {
            FaultFilter.this.activeFaultCounter.incrementAndGet();
            this.callExecutor.execute(new Runnable(){

                @Override
                public void run() {
                    Context previous = FailingClientCall.this.context.attach();
                    try {
                        listener.onClose(FailingClientCall.this.error, new Metadata());
                        FaultFilter.this.activeFaultCounter.decrementAndGet();
                    }
                    finally {
                        FailingClientCall.this.context.detach(previous);
                    }
                }
            });
        }

        @Override
        public void request(int numMessages) {
        }

        @Override
        public void cancel(String message, Throwable cause) {
        }

        @Override
        public void halfClose() {
        }

        @Override
        public void sendMessage(ReqT message) {
        }
    }

    private final class DelayInjectedCall<ReqT, RespT>
    extends DelayedClientCall<ReqT, RespT> {
        final Object lock;
        ScheduledFuture<?> delayTask;
        boolean cancelled;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        DelayInjectedCall(long delayNanos, Executor callExecutor, @Nullable ScheduledExecutorService scheduler, Deadline deadline, final Supplier<? extends ClientCall<ReqT, RespT>> callSupplier) {
            super(callExecutor, scheduler, deadline);
            this.lock = new Object();
            FaultFilter.this.activeFaultCounter.incrementAndGet();
            ScheduledFuture<?> task = scheduler.schedule(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    Object object = DelayInjectedCall.this.lock;
                    synchronized (object) {
                        if (!DelayInjectedCall.this.cancelled) {
                            FaultFilter.this.activeFaultCounter.decrementAndGet();
                        }
                    }
                    Runnable toRun = DelayInjectedCall.this.setCall((ClientCall)callSupplier.get());
                    if (toRun != null) {
                        toRun.run();
                    }
                }
            }, delayNanos, TimeUnit.NANOSECONDS);
            Object object = this.lock;
            synchronized (object) {
                if (!this.cancelled) {
                    this.delayTask = task;
                    return;
                }
            }
            task.cancel(false);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void callCancelled() {
            ScheduledFuture<?> savedDelayTask;
            Object object = this.lock;
            synchronized (object) {
                this.cancelled = true;
                FaultFilter.this.activeFaultCounter.decrementAndGet();
                savedDelayTask = this.delayTask;
            }
            if (savedDelayTask != null) {
                savedDelayTask.cancel(false);
            }
        }
    }
}

