/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.xds;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.protobuf.util.Timestamps;
import io.grpc.BindableService;
import io.grpc.ServerServiceDefinition;
import io.grpc.Status;
import io.grpc.StatusException;
import io.grpc.internal.ObjectPool;
import io.grpc.stub.StreamObserver;
import io.grpc.xds.SharedXdsClientPoolProvider;
import io.grpc.xds.XdsClientPoolFactory;
import io.grpc.xds.client.XdsClient;
import io.grpc.xds.client.XdsResourceType;
import io.grpc.xds.shaded.io.envoyproxy.envoy.admin.v3.ClientResourceStatus;
import io.grpc.xds.shaded.io.envoyproxy.envoy.admin.v3.UpdateFailureState;
import io.grpc.xds.shaded.io.envoyproxy.envoy.service.status.v3.ClientConfig;
import io.grpc.xds.shaded.io.envoyproxy.envoy.service.status.v3.ClientStatusDiscoveryServiceGrpc;
import io.grpc.xds.shaded.io.envoyproxy.envoy.service.status.v3.ClientStatusRequest;
import io.grpc.xds.shaded.io.envoyproxy.envoy.service.status.v3.ClientStatusResponse;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class CsdsService
implements BindableService {
    private static final Logger logger = Logger.getLogger(CsdsService.class.getName());
    private final XdsClientPoolFactory xdsClientPoolFactory;
    private final CsdsServiceInternal delegate = new CsdsServiceInternal();

    @VisibleForTesting
    CsdsService(XdsClientPoolFactory xdsClientPoolFactory) {
        this.xdsClientPoolFactory = Preconditions.checkNotNull(xdsClientPoolFactory, "xdsClientPoolProvider");
    }

    private CsdsService() {
        this(SharedXdsClientPoolProvider.getDefaultProvider());
    }

    public static CsdsService newInstance() {
        return new CsdsService();
    }

    @Override
    public ServerServiceDefinition bindService() {
        return this.delegate.bindService();
    }

    private boolean handleRequest(ClientStatusRequest request, StreamObserver<ClientStatusResponse> responseObserver) {
        StatusException error = null;
        if (request.getNodeMatchersCount() > 0) {
            error = new StatusException(Status.INVALID_ARGUMENT.withDescription("node_matchers not supported"));
        } else {
            List<String> targets = this.xdsClientPoolFactory.getTargets();
            ArrayList<ClientConfig> clientConfigs = new ArrayList<ClientConfig>(targets.size());
            for (int i = 0; i < targets.size() && error == null; ++i) {
                try {
                    ClientConfig clientConfig = this.getConfigForRequest(targets.get(i));
                    if (clientConfig == null) continue;
                    clientConfigs.add(clientConfig);
                    continue;
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    logger.log(Level.FINE, "Server interrupted while building CSDS config dump", e);
                    error = Status.ABORTED.withDescription("Thread interrupted").withCause(e).asException();
                    continue;
                }
                catch (RuntimeException e) {
                    logger.log(Level.WARNING, "Unexpected error while building CSDS config dump", e);
                    error = Status.INTERNAL.withDescription("Unexpected internal error").withCause(e).asException();
                }
            }
            try {
                responseObserver.onNext(this.getStatusResponse(clientConfigs));
            }
            catch (RuntimeException e) {
                logger.log(Level.WARNING, "Unexpected error while processing CSDS config dump", e);
                error = Status.INTERNAL.withDescription("Unexpected internal error").withCause(e).asException();
            }
        }
        if (error == null) {
            return true;
        }
        responseObserver.onError(error);
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ClientConfig getConfigForRequest(String target) throws InterruptedException {
        ObjectPool<XdsClient> xdsClientPool = this.xdsClientPoolFactory.get(target);
        if (xdsClientPool == null) {
            return null;
        }
        XdsClient xdsClient = null;
        try {
            xdsClient = xdsClientPool.getObject();
            ClientConfig clientConfig = CsdsService.getClientConfigForXdsClient(xdsClient, target);
            return clientConfig;
        }
        finally {
            if (xdsClient != null) {
                xdsClientPool.returnObject(xdsClient);
            }
        }
    }

    private ClientStatusResponse getStatusResponse(List<ClientConfig> clientConfigs) {
        if (clientConfigs.isEmpty()) {
            return ClientStatusResponse.getDefaultInstance();
        }
        return ClientStatusResponse.newBuilder().addAllConfig(clientConfigs).build();
    }

    @VisibleForTesting
    static ClientConfig getClientConfigForXdsClient(XdsClient xdsClient, String target) throws InterruptedException {
        ClientConfig.Builder builder = ClientConfig.newBuilder().setClientScope(target).setNode(xdsClient.getBootstrapInfo().node().toEnvoyProtoNode());
        Map<XdsResourceType<?>, Map<String, XdsClient.ResourceMetadata>> metadataByType = CsdsService.awaitSubscribedResourcesMetadata(xdsClient.getSubscribedResourcesMetadataSnapshot());
        for (Map.Entry<XdsResourceType<?>, Map<String, XdsClient.ResourceMetadata>> metadataByTypeEntry : metadataByType.entrySet()) {
            XdsResourceType<?> type = metadataByTypeEntry.getKey();
            Map<String, XdsClient.ResourceMetadata> metadataByResourceName = metadataByTypeEntry.getValue();
            for (Map.Entry<String, XdsClient.ResourceMetadata> metadataEntry : metadataByResourceName.entrySet()) {
                String resourceName = metadataEntry.getKey();
                XdsClient.ResourceMetadata metadata = metadataEntry.getValue();
                ClientConfig.GenericXdsConfig.Builder genericXdsConfigBuilder = ClientConfig.GenericXdsConfig.newBuilder().setTypeUrl(type.typeUrl()).setName(resourceName).setClientStatus(CsdsService.metadataStatusToClientStatus(metadata.getStatus()));
                if (metadata.getRawResource() != null) {
                    genericXdsConfigBuilder.setVersionInfo(metadata.getVersion()).setLastUpdated(Timestamps.fromNanos(metadata.getUpdateTimeNanos())).setXdsConfig(metadata.getRawResource());
                }
                if (metadata.getStatus() == XdsClient.ResourceMetadata.ResourceMetadataStatus.NACKED) {
                    Verify.verifyNotNull(metadata.getErrorState(), "resource %s getErrorState", resourceName);
                    genericXdsConfigBuilder.setErrorState(CsdsService.metadataUpdateFailureStateToProto(metadata.getErrorState()));
                }
                builder.addGenericXdsConfigs(genericXdsConfigBuilder);
            }
        }
        return builder.build();
    }

    private static Map<XdsResourceType<?>, Map<String, XdsClient.ResourceMetadata>> awaitSubscribedResourcesMetadata(ListenableFuture<Map<XdsResourceType<?>, Map<String, XdsClient.ResourceMetadata>>> future) throws InterruptedException {
        try {
            return (Map)future.get(20L, TimeUnit.SECONDS);
        }
        catch (ExecutionException | TimeoutException e) {
            throw new RuntimeException(e);
        }
    }

    @VisibleForTesting
    static ClientResourceStatus metadataStatusToClientStatus(XdsClient.ResourceMetadata.ResourceMetadataStatus status) {
        switch (status) {
            case UNKNOWN: {
                return ClientResourceStatus.UNKNOWN;
            }
            case DOES_NOT_EXIST: {
                return ClientResourceStatus.DOES_NOT_EXIST;
            }
            case REQUESTED: {
                return ClientResourceStatus.REQUESTED;
            }
            case ACKED: {
                return ClientResourceStatus.ACKED;
            }
            case NACKED: {
                return ClientResourceStatus.NACKED;
            }
        }
        throw new AssertionError((Object)("Unexpected ResourceMetadataStatus: " + (Object)((Object)status)));
    }

    private static UpdateFailureState metadataUpdateFailureStateToProto(XdsClient.ResourceMetadata.UpdateFailureState errorState) {
        return UpdateFailureState.newBuilder().setLastUpdateAttempt(Timestamps.fromNanos(errorState.getFailedUpdateTimeNanos())).setDetails(errorState.getFailedDetails()).setVersionInfo(errorState.getFailedVersion()).build();
    }

    private final class CsdsServiceInternal
    extends ClientStatusDiscoveryServiceGrpc.ClientStatusDiscoveryServiceImplBase {
        private CsdsServiceInternal() {
        }

        @Override
        public void fetchClientStatus(ClientStatusRequest request, StreamObserver<ClientStatusResponse> responseObserver) {
            if (CsdsService.this.handleRequest(request, responseObserver)) {
                responseObserver.onCompleted();
            }
        }

        @Override
        public StreamObserver<ClientStatusRequest> streamClientStatus(final StreamObserver<ClientStatusResponse> responseObserver) {
            return new StreamObserver<ClientStatusRequest>(){

                @Override
                public void onNext(ClientStatusRequest request) {
                    CsdsService.this.handleRequest(request, responseObserver);
                }

                @Override
                public void onError(Throwable t2) {
                    this.onCompleted();
                }

                @Override
                public void onCompleted() {
                    responseObserver.onCompleted();
                }
            };
        }
    }
}

