/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.storage.transfermanager;

import com.google.cloud.ReadChannel;
import com.google.cloud.storage.BlobInfo;
import com.google.cloud.storage.Storage;
import com.google.cloud.storage.StorageException;
import com.google.cloud.storage.transfermanager.DownloadSegment;
import com.google.cloud.storage.transfermanager.TransferStatus;
import com.google.common.io.ByteStreams;
import java.nio.channels.FileChannel;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.concurrent.Callable;

final class ChunkedDownloadCallable
implements Callable<DownloadSegment> {
    private final BlobInfo originalBlob;
    private final Storage storage;
    private final Storage.BlobSourceOption[] opts;
    private final long startPosition;
    private final long endPosition;
    private final Path destPath;

    ChunkedDownloadCallable(Storage storage, BlobInfo originalBlob, Storage.BlobSourceOption[] opts, Path destPath, long startPosition, long endPosition) {
        this.originalBlob = originalBlob;
        this.storage = storage;
        this.opts = opts;
        this.startPosition = startPosition;
        this.endPosition = endPosition;
        this.destPath = destPath;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public DownloadSegment call() {
        long bytesCopied = -1L;
        try (ReadChannel rc = this.storage.reader(this.originalBlob.getBlobId(), this.opts);
             FileChannel wc = FileChannel.open(this.destPath, StandardOpenOption.WRITE, StandardOpenOption.CREATE);){
            rc.setChunkSize(0);
            rc.seek(this.startPosition);
            rc.limit(this.endPosition);
            wc.position(this.startPosition);
            bytesCopied = ByteStreams.copy(rc, wc);
            long bytesExpected = this.endPosition - this.startPosition;
            if (bytesCopied == bytesExpected) return DownloadSegment.newBuilder(this.originalBlob, TransferStatus.SUCCESS).setOutputDestination(this.destPath).build();
            DownloadSegment downloadSegment = DownloadSegment.newBuilder(this.originalBlob, TransferStatus.FAILED_TO_FINISH).setException(new StorageException(0, "Unexpected end of stream, read " + bytesCopied + " expected " + bytesExpected + " from object " + this.originalBlob.getBlobId().toGsUtilUriWithGeneration())).build();
            return downloadSegment;
        }
        catch (Exception e) {
            if (bytesCopied != -1L) return DownloadSegment.newBuilder(this.originalBlob, TransferStatus.FAILED_TO_FINISH).setException(e).build();
            return DownloadSegment.newBuilder(this.originalBlob, TransferStatus.FAILED_TO_START).setException(e).build();
        }
    }
}

