/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.storage;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.gax.grpc.GrpcCallContext;
import com.google.cloud.storage.ObjectReadSessionStreamRead;
import com.google.cloud.storage.RetryContext;
import com.google.cloud.storage.StorageException;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.storage.v2.BidiReadHandle;
import com.google.storage.v2.BidiReadObjectRequest;
import com.google.storage.v2.BidiReadObjectSpec;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.checkerframework.checker.lock.qual.GuardedBy;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

final class ObjectReadSessionState {
    private final GrpcCallContext baseContext;
    private final BidiReadObjectRequest openRequest;
    private final AtomicReference<@Nullable BidiReadHandle> bidiReadHandle;
    private final AtomicReference<@Nullable String> routingToken;
    private final AtomicReference<@MonotonicNonNull com.google.storage.v2.Object> metadata;
    private final AtomicLong readIdSeq;
    private final @GuardedBy(value={"this.lock"}) Map<Long, ObjectReadSessionStreamRead<?>> outstandingReads;
    private final ReentrantLock lock;

    ObjectReadSessionState(@NonNull GrpcCallContext baseContext, @NonNull BidiReadObjectRequest openRequest) {
        this(baseContext, openRequest, new AtomicLong(1L), new AtomicReference<BidiReadHandle>(), new AtomicReference<String>(), new AtomicReference<com.google.storage.v2.Object>());
    }

    private ObjectReadSessionState(@NonNull GrpcCallContext baseContext, @NonNull BidiReadObjectRequest openRequest, AtomicLong readIdSeq, AtomicReference<@Nullable BidiReadHandle> bidiReadHandle, AtomicReference<@Nullable String> routingToken, AtomicReference<@MonotonicNonNull com.google.storage.v2.Object> metadata) {
        this.baseContext = baseContext;
        this.openRequest = openRequest;
        this.bidiReadHandle = bidiReadHandle;
        this.routingToken = routingToken;
        this.metadata = metadata;
        this.readIdSeq = readIdSeq;
        this.outstandingReads = new HashMap();
        this.lock = new ReentrantLock();
    }

    ObjectReadSessionState forkChild() {
        return new ObjectReadSessionState(this.baseContext, this.openRequest, this.readIdSeq, new AtomicReference<BidiReadHandle>(this.bidiReadHandle.get()), new AtomicReference<String>(this.routingToken.get()), new AtomicReference<com.google.storage.v2.Object>(this.metadata.get()));
    }

    boolean canHandleNewRead(ObjectReadSessionStreamRead<?> newRead) {
        this.lock.lock();
        try {
            boolean bl = this.outstandingReads.values().stream().allMatch(r -> r.canShareStreamWith(newRead));
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    OpenArguments getOpenArguments() {
        this.lock.lock();
        try {
            BidiReadHandle bidiReadHandle;
            String routingToken;
            BidiReadObjectRequest.Builder b = this.openRequest.toBuilder().clearReadRanges();
            com.google.storage.v2.Object obj = this.metadata.get();
            BidiReadObjectSpec spec = this.openRequest.getReadObjectSpec();
            if (obj != null && obj.getGeneration() != spec.getGeneration()) {
                b.getReadObjectSpecBuilder().setGeneration(obj.getGeneration());
            }
            if ((routingToken = this.routingToken.get()) != null) {
                b.getReadObjectSpecBuilder().setRoutingToken(routingToken);
            }
            if ((bidiReadHandle = this.bidiReadHandle.get()) != null) {
                b.getReadObjectSpecBuilder().setReadHandle(bidiReadHandle);
            }
            this.outstandingReads.values().stream().filter(ObjectReadSessionStreamRead::readyToSend).map(ObjectReadSessionStreamRead::makeReadRange).forEach(b::addReadRanges);
            ImmutableMap<String, ImmutableList<String>> headers = ImmutableMap.of("x-goog-request-params", ImmutableList.of(Stream.of("bucket=" + spec.getBucket(), routingToken != null ? "routing_token=" + routingToken : null).filter(Objects::nonNull).collect(Collectors.joining("&"))));
            OpenArguments openArguments = OpenArguments.of((GrpcCallContext)this.baseContext.withExtraHeaders(headers), b.build());
            return openArguments;
        }
        finally {
            this.lock.unlock();
        }
    }

    void setBidiReadHandle(BidiReadHandle newValue) {
        this.bidiReadHandle.set(newValue);
    }

    com.google.storage.v2.Object getMetadata() {
        return this.metadata.get();
    }

    void setMetadata(com.google.storage.v2.Object metadata) {
        this.metadata.set(metadata);
    }

    long newReadId() {
        return this.readIdSeq.getAndIncrement();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable ObjectReadSessionStreamRead<?> getOutstandingRead(long key) {
        this.lock.lock();
        try {
            ObjectReadSessionStreamRead<?> objectReadSessionStreamRead = this.outstandingReads.get(key);
            return objectReadSessionStreamRead;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void putOutstandingRead(long key, ObjectReadSessionStreamRead<?> value) {
        this.lock.lock();
        try {
            this.outstandingReads.put(key, value);
        }
        finally {
            this.lock.unlock();
        }
    }

    void removeOutstandingRead(long key) {
        this.lock.lock();
        try {
            this.outstandingReads.remove(key);
        }
        finally {
            this.lock.unlock();
        }
    }

    <T extends Throwable> RetryContext.OnFailure<T> removeOutstandingReadOnFailure(long key, RetryContext.OnFailure<T> onFail) {
        return t2 -> {
            this.removeOutstandingRead(key);
            onFail.onFailure(t2);
        };
    }

    void setRoutingToken(String routingToken) {
        this.routingToken.set(routingToken);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ObjectReadSessionStreamRead<?> assignNewReadId(long oldReadId) {
        this.lock.lock();
        try {
            ObjectReadSessionStreamRead<?> remove = this.outstandingReads.remove(oldReadId);
            Preconditions.checkState(remove != null, "unable to locate old read");
            long newReadId = this.newReadId();
            ObjectReadSessionStreamRead<?> withNewReadId = remove.withNewReadId(newReadId);
            this.outstandingReads.put(newReadId, withNewReadId);
            ObjectReadSessionStreamRead<?> objectReadSessionStreamRead = withNewReadId;
            return objectReadSessionStreamRead;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ApiFuture<?> failAll(Executor executor, Supplier<Throwable> terminalFailure) {
        this.lock.lock();
        try {
            Iterator<Map.Entry<Long, ObjectReadSessionStreamRead<?>>> iter = this.outstandingReads.entrySet().iterator();
            ArrayList futures = new ArrayList();
            while (iter.hasNext()) {
                Map.Entry<Long, ObjectReadSessionStreamRead<?>> entry = iter.next();
                iter.remove();
                ObjectReadSessionStreamRead<?> read = entry.getValue();
                read.preFail();
                ApiFuture f = ApiFutures.transformAsync(ApiFutures.immediateFuture("trigger"), ignore -> read.fail(StorageException.coalesce((Throwable)terminalFailure.get())), executor);
                futures.add(f);
            }
            ApiFuture apiFuture = ApiFutures.successfulAsList(futures);
            return apiFuture;
        }
        finally {
            this.lock.unlock();
        }
    }

    static final class OpenArguments {
        private final GrpcCallContext ctx;
        private final BidiReadObjectRequest req;

        private OpenArguments(GrpcCallContext ctx, BidiReadObjectRequest req) {
            this.ctx = ctx;
            this.req = req;
        }

        public GrpcCallContext getCtx() {
            return this.ctx;
        }

        public BidiReadObjectRequest getReq() {
            return this.req;
        }

        public static OpenArguments of(GrpcCallContext ctx, BidiReadObjectRequest req) {
            return new OpenArguments(ctx, req);
        }
    }
}

