/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.storage;

import com.google.api.core.BetaApi;
import com.google.cloud.storage.RangeSpec;
import com.google.cloud.storage.RangeSpecFunction;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.math.DoubleMath;
import java.math.RoundingMode;
import java.util.Objects;
import java.util.OptionalLong;
import javax.annotation.concurrent.Immutable;

@BetaApi
@Immutable
public final class LinearExponentialRangeSpecFunction
extends RangeSpecFunction {
    static final LinearExponentialRangeSpecFunction INSTANCE = new LinearExponentialRangeSpecFunction(0x200000L, 4.0);
    private final long initialMaxLength;
    private final double maxLengthScalar;

    private LinearExponentialRangeSpecFunction(long initialMaxLength, double maxLengthScalar) {
        this.initialMaxLength = initialMaxLength;
        this.maxLengthScalar = maxLengthScalar;
    }

    public long getInitialMaxLength() {
        return this.initialMaxLength;
    }

    public LinearExponentialRangeSpecFunction withInitialMaxLength(long initialMaxLength) {
        Preconditions.checkArgument(initialMaxLength > 0L, "initialMaxLength > 0 (%s > 0)", initialMaxLength);
        return new LinearExponentialRangeSpecFunction(initialMaxLength, this.maxLengthScalar);
    }

    public double getMaxLengthScalar() {
        return this.maxLengthScalar;
    }

    public LinearExponentialRangeSpecFunction withMaxLengthScalar(double maxLengthScalar) {
        Preconditions.checkArgument(maxLengthScalar >= 1.0, "maxLengthScalar >= 1.0 (%s >= 1.0)", (Object)maxLengthScalar);
        return new LinearExponentialRangeSpecFunction(this.initialMaxLength, maxLengthScalar);
    }

    @Override
    RangeSpec apply(long offset, RangeSpec prev) {
        long maxLength;
        if (prev == null) {
            return RangeSpec.of(offset, this.initialMaxLength);
        }
        OptionalLong maybeMaxLength = prev.maxLength();
        if (maybeMaxLength.isPresent()) {
            maxLength = maybeMaxLength.getAsLong();
            long expectedOffset = prev.begin() + maxLength;
            if (offset != expectedOffset) {
                return RangeSpec.of(offset, this.initialMaxLength);
            }
        } else {
            maxLength = Long.MAX_VALUE;
        }
        long scaleReadSize = LinearExponentialRangeSpecFunction.scaleMaxLength(maxLength, this.maxLengthScalar);
        return RangeSpec.of(offset, scaleReadSize);
    }

    private static long scaleMaxLength(long lastReadSize, double rangeMaxLengthScalar) {
        double scaled = (double)lastReadSize * rangeMaxLengthScalar;
        if (Double.isInfinite(scaled)) {
            return Long.MAX_VALUE;
        }
        return DoubleMath.roundToLong(scaled, RoundingMode.HALF_EVEN);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof LinearExponentialRangeSpecFunction)) {
            return false;
        }
        LinearExponentialRangeSpecFunction that = (LinearExponentialRangeSpecFunction)o;
        return this.initialMaxLength == that.initialMaxLength && Double.compare(this.maxLengthScalar, that.maxLengthScalar) == 0;
    }

    public int hashCode() {
        return Objects.hash(this.initialMaxLength, this.maxLengthScalar);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("initialMaxLength", this.initialMaxLength).add("rangeMaxLengthScalar", this.maxLengthScalar).toString();
    }
}

