/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.storage;

import com.google.api.core.BetaApi;
import com.google.cloud.storage.BidiBlobWriteSessionConfig;
import com.google.cloud.storage.BlobWriteSessionConfig;
import com.google.cloud.storage.BufferToDiskThenUpload;
import com.google.cloud.storage.DefaultBlobWriteSessionConfig;
import com.google.cloud.storage.JournalingBlobWriteSessionConfig;
import com.google.cloud.storage.ParallelCompositeUploadBlobWriteSessionConfig;
import com.google.cloud.storage.TransportCompatibility;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;

@BetaApi
public final class BlobWriteSessionConfigs {
    private BlobWriteSessionConfigs() {
    }

    @BetaApi
    @TransportCompatibility(value={TransportCompatibility.Transport.GRPC, TransportCompatibility.Transport.HTTP})
    public static DefaultBlobWriteSessionConfig getDefault() {
        return new DefaultBlobWriteSessionConfig(0x1000000);
    }

    @BetaApi
    @TransportCompatibility(value={TransportCompatibility.Transport.GRPC})
    public static BidiBlobWriteSessionConfig bidiWrite() {
        return new BidiBlobWriteSessionConfig(0x1000000);
    }

    @BetaApi
    @TransportCompatibility(value={TransportCompatibility.Transport.GRPC, TransportCompatibility.Transport.HTTP})
    public static BlobWriteSessionConfig bufferToTempDirThenUpload() throws IOException {
        return BlobWriteSessionConfigs.bufferToDiskThenUpload(Paths.get(System.getProperty("java.io.tmpdir"), "google-cloud-storage"));
    }

    @BetaApi
    @TransportCompatibility(value={TransportCompatibility.Transport.GRPC, TransportCompatibility.Transport.HTTP})
    public static BufferToDiskThenUpload bufferToDiskThenUpload(Path path) throws IOException {
        return BlobWriteSessionConfigs.bufferToDiskThenUpload(ImmutableList.of(path));
    }

    @BetaApi
    @TransportCompatibility(value={TransportCompatibility.Transport.GRPC, TransportCompatibility.Transport.HTTP})
    public static BufferToDiskThenUpload bufferToDiskThenUpload(Collection<Path> paths) throws IOException {
        return new BufferToDiskThenUpload(ImmutableList.copyOf(paths), false);
    }

    @BetaApi
    @TransportCompatibility(value={TransportCompatibility.Transport.GRPC})
    public static JournalingBlobWriteSessionConfig journaling(Collection<Path> paths) {
        return new JournalingBlobWriteSessionConfig(ImmutableList.copyOf(paths), false);
    }

    @BetaApi
    @TransportCompatibility(value={TransportCompatibility.Transport.GRPC, TransportCompatibility.Transport.HTTP})
    public static ParallelCompositeUploadBlobWriteSessionConfig parallelCompositeUpload() {
        return ParallelCompositeUploadBlobWriteSessionConfig.withDefaults();
    }
}

