/*
 * Decompiled with CFR 0.152.
 */
package com.google.auth.oauth2;

import com.google.api.client.http.GenericUrl;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestFactory;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.UrlEncodedContent;
import com.google.api.client.json.GenericJson;
import com.google.api.client.json.JsonObjectParser;
import com.google.api.client.util.GenericData;
import com.google.api.client.util.Joiner;
import com.google.api.client.util.Preconditions;
import com.google.auth.http.HttpTransportFactory;
import com.google.auth.oauth2.AccessToken;
import com.google.auth.oauth2.ClientId;
import com.google.auth.oauth2.DefaultPKCEProvider;
import com.google.auth.oauth2.MemoryTokensStorage;
import com.google.auth.oauth2.OAuth2Credentials;
import com.google.auth.oauth2.OAuth2Utils;
import com.google.auth.oauth2.PKCEProvider;
import com.google.auth.oauth2.TokenStore;
import com.google.auth.oauth2.UserCredentials;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;

public class UserAuthorizer {
    static final URI DEFAULT_CALLBACK_URI = URI.create("/oauth2callback");
    private final String TOKEN_STORE_ERROR = "Error parsing stored token data.";
    private final String FETCH_TOKEN_ERROR = "Error reading result of Token API:";
    private final ClientId clientId;
    private final Collection<String> scopes;
    private final TokenStore tokenStore;
    private final URI callbackUri;
    private final HttpTransportFactory transportFactory;
    private final URI tokenServerUri;
    private final URI userAuthUri;
    private final PKCEProvider pkce;
    private final ClientAuthenticationType clientAuthenticationType;

    private UserAuthorizer(Builder builder) {
        this.clientId = Preconditions.checkNotNull(builder.clientId);
        this.scopes = ImmutableList.copyOf(Preconditions.checkNotNull(builder.scopes));
        this.callbackUri = builder.callbackUri == null ? DEFAULT_CALLBACK_URI : builder.callbackUri;
        this.transportFactory = builder.transportFactory == null ? OAuth2Utils.HTTP_TRANSPORT_FACTORY : builder.transportFactory;
        this.tokenServerUri = builder.tokenServerUri == null ? OAuth2Utils.TOKEN_SERVER_URI : builder.tokenServerUri;
        this.userAuthUri = builder.userAuthUri == null ? OAuth2Utils.USER_AUTH_URI : builder.userAuthUri;
        this.tokenStore = builder.tokenStore == null ? new MemoryTokensStorage() : builder.tokenStore;
        this.pkce = builder.pkce;
        this.clientAuthenticationType = builder.clientAuthenticationType == null ? ClientAuthenticationType.CLIENT_SECRET_POST : builder.clientAuthenticationType;
    }

    public ClientId getClientId() {
        return this.clientId;
    }

    public Collection<String> getScopes() {
        return this.scopes;
    }

    public URI getCallbackUri() {
        return this.callbackUri;
    }

    public URI getCallbackUri(URI baseUri) {
        if (this.callbackUri.isAbsolute()) {
            return this.callbackUri;
        }
        if (baseUri == null || !baseUri.isAbsolute()) {
            throw new IllegalStateException("If the callback URI is relative, the baseUri passed must be an absolute URI");
        }
        return baseUri.resolve(this.callbackUri);
    }

    public TokenStore getTokenStore() {
        return this.tokenStore;
    }

    public ClientAuthenticationType getClientAuthenticationType() {
        return this.clientAuthenticationType;
    }

    public URL getAuthorizationUrl(String userId, String state, URI baseUri) {
        return this.getAuthorizationUrl(userId, state, baseUri, null);
    }

    public URL getAuthorizationUrl(String userId, String state, URI baseUri, Map<String, String> additionalParameters) {
        URI resolvedCallbackUri = this.getCallbackUri(baseUri);
        String scopesString = Joiner.on(' ').join(this.scopes);
        GenericUrl url = new GenericUrl(this.userAuthUri);
        url.put("response_type", (Object)"code");
        url.put("client_id", (Object)this.clientId.getClientId());
        url.put("redirect_uri", (Object)resolvedCallbackUri);
        url.put("scope", (Object)scopesString);
        if (state != null) {
            url.put("state", (Object)state);
        }
        url.put("access_type", (Object)"offline");
        url.put("prompt", (Object)"consent");
        if (userId != null) {
            url.put("login_hint", (Object)userId);
        }
        url.put("include_granted_scopes", (Object)true);
        if (additionalParameters != null) {
            for (Map.Entry<String, String> entry : additionalParameters.entrySet()) {
                url.put(entry.getKey(), (Object)entry.getValue());
            }
        }
        if (this.pkce != null) {
            url.put("code_challenge", (Object)this.pkce.getCodeChallenge());
            url.put("code_challenge_method", (Object)this.pkce.getCodeChallengeMethod());
        }
        return url.toURL();
    }

    public UserCredentials getCredentials(String userId) throws IOException {
        Preconditions.checkNotNull(userId);
        if (this.tokenStore == null) {
            throw new IllegalStateException("Method cannot be called if token store is not specified.");
        }
        String tokenData = this.tokenStore.load(userId);
        if (tokenData == null) {
            return null;
        }
        GenericJson tokenJson = OAuth2Utils.parseJson(tokenData);
        String accessTokenValue = OAuth2Utils.validateString(tokenJson, "access_token", "Error parsing stored token data.");
        Long expirationMillis = OAuth2Utils.validateLong(tokenJson, "expiration_time_millis", "Error parsing stored token data.");
        Date expirationTime = new Date(expirationMillis);
        List<String> scopes = OAuth2Utils.validateOptionalListString(tokenJson, "scope", "Error reading result of Token API:");
        AccessToken accessToken = AccessToken.newBuilder().setExpirationTime(expirationTime).setTokenValue(accessTokenValue).setScopes(scopes).build();
        String refreshToken = OAuth2Utils.validateOptionalString(tokenJson, "refresh_token", "Error parsing stored token data.");
        UserCredentials credentials = UserCredentials.newBuilder().setClientId(this.clientId.getClientId()).setClientSecret(this.clientId.getClientSecret()).setRefreshToken(refreshToken).setAccessToken(accessToken).setHttpTransportFactory(this.transportFactory).setTokenServerUri(this.tokenServerUri).build();
        this.monitorCredentials(userId, credentials);
        return credentials;
    }

    public UserCredentials getCredentialsFromCode(String code, URI baseUri) throws IOException {
        return this.getCredentialsFromCode(code, baseUri, null);
    }

    public UserCredentials getCredentialsFromCode(String code, URI baseUri, Map<String, String> additionalParameters) throws IOException {
        TokenResponseWithConfig tokenResponseWithConfig = this.getCredentialsFromCodeInternal(code, baseUri, additionalParameters);
        return UserCredentials.newBuilder().setClientId(tokenResponseWithConfig.getClientId()).setClientSecret(tokenResponseWithConfig.getClientSecret()).setAccessToken(tokenResponseWithConfig.getAccessToken()).setRefreshToken(tokenResponseWithConfig.getRefreshToken()).setHttpTransportFactory(tokenResponseWithConfig.getHttpTransportFactory()).setTokenServerUri(tokenResponseWithConfig.getTokenServerUri()).build();
    }

    public TokenResponseWithConfig getTokenResponseFromAuthCodeExchange(String code, URI callbackUri, Map<String, String> additionalParameters) throws IOException {
        return this.getCredentialsFromCodeInternal(code, callbackUri, additionalParameters);
    }

    public UserCredentials getAndStoreCredentialsFromCode(String userId, String code, URI baseUri) throws IOException {
        Preconditions.checkNotNull(userId);
        Preconditions.checkNotNull(code);
        UserCredentials credentials = this.getCredentialsFromCode(code, baseUri);
        this.storeCredentials(userId, credentials);
        this.monitorCredentials(userId, credentials);
        return credentials;
    }

    public void revokeAuthorization(String userId) throws IOException {
        Preconditions.checkNotNull(userId);
        if (this.tokenStore == null) {
            throw new IllegalStateException("Method cannot be called if token store is not specified.");
        }
        String tokenData = this.tokenStore.load(userId);
        if (tokenData == null) {
            return;
        }
        IOException deleteTokenException = null;
        try {
            this.tokenStore.delete(userId);
        }
        catch (IOException e) {
            deleteTokenException = e;
        }
        GenericJson tokenJson = OAuth2Utils.parseJson(tokenData);
        String accessTokenValue = OAuth2Utils.validateOptionalString(tokenJson, "access_token", "Error parsing stored token data.");
        String refreshToken = OAuth2Utils.validateOptionalString(tokenJson, "refresh_token", "Error parsing stored token data.");
        String revokeToken = refreshToken != null ? refreshToken : accessTokenValue;
        GenericUrl revokeUrl = new GenericUrl(OAuth2Utils.TOKEN_REVOKE_URI);
        GenericData genericData = new GenericData();
        genericData.put("token", (Object)revokeToken);
        UrlEncodedContent content = new UrlEncodedContent(genericData);
        HttpRequestFactory requestFactory = this.transportFactory.create().createRequestFactory();
        HttpRequest tokenRequest = requestFactory.buildPostRequest(revokeUrl, content);
        tokenRequest.execute();
        if (deleteTokenException != null) {
            throw deleteTokenException;
        }
    }

    public void storeCredentials(String userId, UserCredentials credentials) throws IOException {
        if (this.tokenStore == null) {
            throw new IllegalStateException("Cannot store tokens if tokenStore is not specified.");
        }
        AccessToken accessToken = credentials.getAccessToken();
        String acessTokenValue = null;
        Date expiresBy = null;
        List<Object> grantedScopes = new ArrayList();
        if (accessToken != null) {
            acessTokenValue = accessToken.getTokenValue();
            expiresBy = accessToken.getExpirationTime();
            grantedScopes = accessToken.getScopes();
        }
        String refreshToken = credentials.getRefreshToken();
        GenericJson tokenStateJson = new GenericJson();
        tokenStateJson.setFactory(OAuth2Utils.JSON_FACTORY);
        tokenStateJson.put("access_token", (Object)acessTokenValue);
        tokenStateJson.put("scope", (Object)grantedScopes);
        tokenStateJson.put("expiration_time_millis", (Object)expiresBy.getTime());
        if (refreshToken != null) {
            tokenStateJson.put("refresh_token", (Object)refreshToken);
        }
        String tokenState = tokenStateJson.toString();
        this.tokenStore.store(userId, tokenState);
    }

    protected void monitorCredentials(String userId, UserCredentials credentials) {
        credentials.addChangeListener(new UserCredentialsListener(userId));
    }

    private TokenResponseWithConfig getCredentialsFromCodeInternal(String code, URI baseUri, Map<String, String> additionalParameters) throws IOException {
        Preconditions.checkNotNull(code);
        URI resolvedCallbackUri = this.getCallbackUri(baseUri);
        GenericData tokenData = new GenericData();
        tokenData.put("code", (Object)code);
        tokenData.put("client_id", (Object)this.clientId.getClientId());
        tokenData.put("redirect_uri", (Object)resolvedCallbackUri);
        tokenData.put("grant_type", (Object)"authorization_code");
        if (additionalParameters != null) {
            for (Map.Entry<String, String> entry : additionalParameters.entrySet()) {
                tokenData.put(entry.getKey(), (Object)entry.getValue());
            }
        }
        if (this.pkce != null) {
            tokenData.put("code_verifier", (Object)this.pkce.getCodeVerifier());
        }
        if (this.clientAuthenticationType == ClientAuthenticationType.CLIENT_SECRET_POST) {
            tokenData.put("client_secret", (Object)this.clientId.getClientSecret());
        }
        HttpRequestFactory requestFactory = this.transportFactory.create().createRequestFactory();
        UrlEncodedContent tokenContent = new UrlEncodedContent(tokenData);
        HttpRequest tokenRequest = requestFactory.buildPostRequest(new GenericUrl(this.tokenServerUri), tokenContent);
        tokenRequest.setParser(new JsonObjectParser(OAuth2Utils.JSON_FACTORY));
        if (this.clientAuthenticationType == ClientAuthenticationType.CLIENT_SECRET_BASIC) {
            tokenRequest.getHeaders().setAuthorization(OAuth2Utils.generateBasicAuthHeader(this.clientId.getClientId(), this.clientId.getClientSecret()));
        }
        HttpResponse tokenResponse = tokenRequest.execute();
        GenericJson parsedTokens = tokenResponse.parseAs(GenericJson.class);
        String accessTokenValue = OAuth2Utils.validateString(parsedTokens, "access_token", "Error reading result of Token API:");
        int expiresInSecs = OAuth2Utils.validateInt32(parsedTokens, "expires_in", "Error reading result of Token API:");
        Date expirationTime = new Date(new Date().getTime() + (long)(expiresInSecs * 1000));
        String scopes = OAuth2Utils.validateOptionalString(parsedTokens, "scope", "Error reading result of Token API:");
        AccessToken accessToken = AccessToken.newBuilder().setExpirationTime(expirationTime).setTokenValue(accessTokenValue).setScopes(scopes).build();
        String refreshToken = OAuth2Utils.validateOptionalString(parsedTokens, "refresh_token", "Error reading result of Token API:");
        return TokenResponseWithConfig.newBuilder().setClientId(this.clientId.getClientId()).setClientSecret(this.clientId.getClientSecret()).setAccessToken(accessToken).setRefreshToken(refreshToken).setHttpTransportFactory(this.transportFactory).setTokenServerUri(this.tokenServerUri).build();
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static class TokenResponseWithConfig {
        private final String clientId;
        private final String clientSecret;
        private final String refreshToken;
        private final AccessToken accessToken;
        private URI tokenServerUri;
        private final HttpTransportFactory httpTransportFactory;

        private TokenResponseWithConfig(Builder builder) {
            this.clientId = builder.clientId;
            this.clientSecret = builder.clientSecret;
            this.accessToken = builder.accessToken;
            this.httpTransportFactory = builder.httpTransportFactory;
            this.tokenServerUri = builder.tokenServerUri;
            this.refreshToken = builder.refreshToken;
        }

        public String getClientId() {
            return this.clientId;
        }

        public String getClientSecret() {
            return this.clientSecret;
        }

        public AccessToken getAccessToken() {
            return this.accessToken;
        }

        public HttpTransportFactory getHttpTransportFactory() {
            return this.httpTransportFactory;
        }

        public URI getTokenServerUri() {
            return this.tokenServerUri;
        }

        @Nullable
        public String getRefreshToken() {
            return this.refreshToken;
        }

        static Builder newBuilder() {
            return new Builder();
        }

        static class Builder {
            private String clientId;
            private String clientSecret;
            private String refreshToken;
            private AccessToken accessToken;
            private URI tokenServerUri;
            private HttpTransportFactory httpTransportFactory;

            Builder() {
            }

            @CanIgnoreReturnValue
            Builder setClientId(String clientId) {
                this.clientId = clientId;
                return this;
            }

            @CanIgnoreReturnValue
            Builder setClientSecret(String clientSecret) {
                this.clientSecret = clientSecret;
                return this;
            }

            @CanIgnoreReturnValue
            Builder setRefreshToken(String refreshToken) {
                this.refreshToken = refreshToken;
                return this;
            }

            @CanIgnoreReturnValue
            Builder setAccessToken(AccessToken accessToken) {
                this.accessToken = accessToken;
                return this;
            }

            @CanIgnoreReturnValue
            Builder setHttpTransportFactory(HttpTransportFactory httpTransportFactory) {
                this.httpTransportFactory = httpTransportFactory;
                return this;
            }

            @CanIgnoreReturnValue
            Builder setTokenServerUri(URI tokenServerUri) {
                this.tokenServerUri = tokenServerUri;
                return this;
            }

            TokenResponseWithConfig build() {
                return new TokenResponseWithConfig(this);
            }
        }
    }

    public static class Builder {
        private ClientId clientId;
        private TokenStore tokenStore;
        private URI callbackUri;
        private URI tokenServerUri;
        private URI userAuthUri;
        private Collection<String> scopes;
        private HttpTransportFactory transportFactory;
        private PKCEProvider pkce;
        private ClientAuthenticationType clientAuthenticationType;

        protected Builder() {
        }

        protected Builder(UserAuthorizer authorizer) {
            this.clientId = authorizer.clientId;
            this.scopes = authorizer.scopes;
            this.transportFactory = authorizer.transportFactory;
            this.tokenServerUri = authorizer.tokenServerUri;
            this.tokenStore = authorizer.tokenStore;
            this.callbackUri = authorizer.callbackUri;
            this.userAuthUri = authorizer.userAuthUri;
            this.pkce = new DefaultPKCEProvider();
            this.clientAuthenticationType = authorizer.clientAuthenticationType;
        }

        @CanIgnoreReturnValue
        public Builder setClientId(ClientId clientId) {
            this.clientId = clientId;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setTokenStore(TokenStore tokenStore) {
            this.tokenStore = tokenStore;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setScopes(Collection<String> scopes) {
            this.scopes = scopes;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setTokenServerUri(URI tokenServerUri) {
            this.tokenServerUri = tokenServerUri;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setCallbackUri(URI callbackUri) {
            this.callbackUri = callbackUri;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setUserAuthUri(URI userAuthUri) {
            this.userAuthUri = userAuthUri;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setHttpTransportFactory(HttpTransportFactory transportFactory) {
            this.transportFactory = transportFactory;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setPKCEProvider(PKCEProvider pkce) {
            if (pkce != null && (pkce.getCodeChallenge() == null || pkce.getCodeVerifier() == null || pkce.getCodeChallengeMethod() == null)) {
                throw new IllegalArgumentException("PKCE provider contained null implementations. PKCE object must implement all PKCEProvider methods.");
            }
            this.pkce = pkce;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setClientAuthenticationType(ClientAuthenticationType clientAuthentication) {
            this.clientAuthenticationType = clientAuthentication;
            return this;
        }

        public ClientId getClientId() {
            return this.clientId;
        }

        public TokenStore getTokenStore() {
            return this.tokenStore;
        }

        public Collection<String> getScopes() {
            return this.scopes;
        }

        public URI getTokenServerUri() {
            return this.tokenServerUri;
        }

        public URI getCallbackUri() {
            return this.callbackUri;
        }

        public URI getUserAuthUri() {
            return this.userAuthUri;
        }

        public HttpTransportFactory getHttpTransportFactory() {
            return this.transportFactory;
        }

        public PKCEProvider getPKCEProvider() {
            return this.pkce;
        }

        public ClientAuthenticationType getClientAuthenticationType() {
            return this.clientAuthenticationType;
        }

        public UserAuthorizer build() {
            return new UserAuthorizer(this);
        }
    }

    private class UserCredentialsListener
    implements OAuth2Credentials.CredentialsChangedListener {
        private final String userId;

        public UserCredentialsListener(String userId) {
            this.userId = userId;
        }

        @Override
        public void onChanged(OAuth2Credentials credentials) throws IOException {
            UserCredentials userCredentials = (UserCredentials)credentials;
            UserAuthorizer.this.storeCredentials(this.userId, userCredentials);
        }
    }

    public static enum ClientAuthenticationType {
        CLIENT_SECRET_POST,
        CLIENT_SECRET_BASIC,
        NONE;

    }
}

