/*
 * Decompiled with CFR 0.152.
 */
package com.google.auth.oauth2;

import com.google.auth.oauth2.ExternalAccountCredentials;
import com.google.common.base.Preconditions;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Nullable;

public class IdentityPoolCredentialSource
extends ExternalAccountCredentials.CredentialSource {
    private static final long serialVersionUID = -745855247050085694L;
    IdentityPoolCredentialSourceType credentialSourceType;
    CredentialFormatType credentialFormatType;
    private String credentialLocation;
    @Nullable
    String subjectTokenFieldName;
    @Nullable
    Map<String, String> headers;
    @Nullable
    private CertificateConfig certificateConfig;

    public String getCredentialLocation() {
        return this.credentialLocation;
    }

    public void setCredentialLocation(String credentialLocation) {
        this.credentialLocation = credentialLocation;
    }

    @Nullable
    public CertificateConfig getCertificateConfig() {
        return this.certificateConfig;
    }

    private CertificateConfig certificateConfigFromSourceMap(Map<String, Object> credentialSourceMap) {
        Object certValue = credentialSourceMap.get("certificate");
        if (!(certValue instanceof Map)) {
            throw new IllegalArgumentException("The 'certificate' credential source must be a JSON object (Map).");
        }
        Map certificateMap = (Map)certValue;
        Boolean useDefaultCertificateConfig = this.getOptionalBoolean(certificateMap, "use_default_certificate_config");
        String trustChain = this.getOptionalString(certificateMap, "trust_chain_path");
        String certificateConfigLocation = this.getOptionalString(certificateMap, "certificate_config_location");
        return new CertificateConfig(useDefaultCertificateConfig, certificateConfigLocation, trustChain);
    }

    @Nullable
    private Boolean getOptionalBoolean(Map<String, Object> map, String key) {
        Object value = map.get(key);
        if (value == null) {
            return null;
        }
        if (!(value instanceof Boolean)) {
            throw new IllegalArgumentException(String.format("Invalid type for '%s' in certificate configuration: expected Boolean, got %s.", key, value.getClass().getSimpleName()));
        }
        return (Boolean)value;
    }

    @Nullable
    private String getOptionalString(Map<String, Object> map, String key) {
        Object value = map.get(key);
        if (value == null) {
            return null;
        }
        if (!(value instanceof String)) {
            throw new IllegalArgumentException(String.format("Invalid type for '%s' in certificate configuration: expected String, got %s.", key, value.getClass().getSimpleName()));
        }
        return (String)value;
    }

    public IdentityPoolCredentialSource(Map<String, Object> credentialSourceMap) {
        super(credentialSourceMap);
        boolean filePresent = credentialSourceMap.containsKey("file");
        boolean urlPresent = credentialSourceMap.containsKey("url");
        boolean certificatePresent = credentialSourceMap.containsKey("certificate");
        if (filePresent && urlPresent || filePresent && certificatePresent || urlPresent && certificatePresent) {
            throw new IllegalArgumentException("Only one credential source type can be set: 'file', 'url', or 'certificate'.");
        }
        if (filePresent) {
            this.credentialLocation = (String)credentialSourceMap.get("file");
            this.credentialSourceType = IdentityPoolCredentialSourceType.FILE;
        } else if (urlPresent) {
            this.credentialLocation = (String)credentialSourceMap.get("url");
            this.credentialSourceType = IdentityPoolCredentialSourceType.URL;
        } else if (certificatePresent) {
            this.credentialSourceType = IdentityPoolCredentialSourceType.CERTIFICATE;
            this.certificateConfig = this.certificateConfigFromSourceMap(credentialSourceMap);
        } else {
            throw new IllegalArgumentException("Missing credential source file location, URL, or certificate. At least one must be specified.");
        }
        Map headersMap = (Map)credentialSourceMap.get("headers");
        if (headersMap != null && !headersMap.isEmpty()) {
            this.headers = new HashMap<String, String>();
            this.headers.putAll(headersMap);
        }
        this.credentialFormatType = CredentialFormatType.TEXT;
        Map formatMap = (Map)credentialSourceMap.get("format");
        if (formatMap != null && formatMap.containsKey("type")) {
            String type = (String)formatMap.get("type");
            if (type != null && "json".equals(type.toLowerCase(Locale.US))) {
                if (!formatMap.containsKey("subject_token_field_name")) {
                    throw new IllegalArgumentException("When specifying a JSON credential type, the subject_token_field_name must be set.");
                }
                this.credentialFormatType = CredentialFormatType.JSON;
                this.subjectTokenFieldName = (String)formatMap.get("subject_token_field_name");
            } else if (type != null && "text".equals(type.toLowerCase(Locale.US))) {
                this.credentialFormatType = CredentialFormatType.TEXT;
            } else {
                throw new IllegalArgumentException(String.format("Invalid credential source format type: %s.", type));
            }
        }
    }

    boolean hasHeaders() {
        return this.headers != null && !this.headers.isEmpty();
    }

    static enum CredentialFormatType {
        TEXT,
        JSON;

    }

    static enum IdentityPoolCredentialSourceType {
        FILE,
        URL,
        CERTIFICATE;

    }

    public static class CertificateConfig
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final boolean useDefaultCertificateConfig;
        @Nullable
        private final String certificateConfigLocation;
        @Nullable
        private final String trustChainPath;

        CertificateConfig(@Nullable Boolean useDefaultCertificateConfig, @Nullable String certificateConfigLocation, @Nullable String trustChainPath) {
            boolean useDefault = useDefaultCertificateConfig != null && useDefaultCertificateConfig != false;
            boolean locationIsPresent = certificateConfigLocation != null && !certificateConfigLocation.isEmpty();
            Preconditions.checkArgument(useDefault || locationIsPresent, "Invalid 'certificate' configuration in credential source: Must specify either 'certificate_config_location' or set 'use_default_certificate_config' to true.");
            Preconditions.checkArgument(!useDefault || !locationIsPresent, "Invalid 'certificate' configuration in credential source: Cannot specify both 'certificate_config_location' and set 'use_default_certificate_config' to true.");
            this.useDefaultCertificateConfig = useDefault;
            this.certificateConfigLocation = certificateConfigLocation;
            this.trustChainPath = trustChainPath;
        }

        public boolean useDefaultCertificateConfig() {
            return this.useDefaultCertificateConfig;
        }

        @Nullable
        public String getCertificateConfigLocation() {
            return this.certificateConfigLocation;
        }

        @Nullable
        public String getTrustChainPath() {
            return this.trustChainPath;
        }
    }
}

