/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.pipes.pipesiterator.csv;

import java.io.BufferedReader;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.TimeoutException;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVRecord;
import org.apache.tika.config.Field;
import org.apache.tika.config.Initializable;
import org.apache.tika.config.InitializableProblemHandler;
import org.apache.tika.config.TikaConfig;
import org.apache.tika.exception.TikaConfigException;
import org.apache.tika.exception.TikaException;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.pipes.FetchEmitTuple;
import org.apache.tika.pipes.HandlerConfig;
import org.apache.tika.pipes.emitter.EmitKey;
import org.apache.tika.pipes.fetcher.FetchKey;
import org.apache.tika.pipes.pipesiterator.PipesIterator;
import org.apache.tika.utils.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CSVPipesIterator
extends PipesIterator
implements Initializable {
    private static final Logger LOGGER = LoggerFactory.getLogger(CSVPipesIterator.class);
    private final Charset charset = StandardCharsets.UTF_8;
    private Path csvPath;
    private String fetchKeyColumn;
    private String emitKeyColumn;
    private String idColumn;

    @Field
    public void setCsvPath(String csvPath) {
        this.setCsvPath(Paths.get(csvPath, new String[0]));
    }

    @Field
    public void setFetchKeyColumn(String fetchKeyColumn) {
        this.fetchKeyColumn = fetchKeyColumn;
    }

    @Field
    public void setEmitKeyColumn(String emitKeyColumn) {
        this.emitKeyColumn = emitKeyColumn;
    }

    @Field
    public void setIdColumn(String idColumn) {
        this.idColumn = idColumn;
    }

    @Field
    public void setCsvPath(Path csvPath) {
        this.csvPath = csvPath;
    }

    protected void enqueue() throws InterruptedException, IOException, TimeoutException {
        String fetcherName = this.getFetcherName();
        String emitterName = this.getEmitterName();
        try (BufferedReader reader = Files.newBufferedReader(this.csvPath, this.charset);){
            CSVParser records = CSVFormat.EXCEL.parse(reader);
            ArrayList<String> headers = new ArrayList<String>();
            FetchEmitKeyIndices fetchEmitKeyIndices = null;
            Iterator iterator = records.iterator();
            if (iterator.hasNext()) {
                CSVRecord record = (CSVRecord)iterator.next();
                fetchEmitKeyIndices = this.loadHeaders(record, headers);
            }
            try {
                this.checkFetchEmitValidity(fetcherName, emitterName, fetchEmitKeyIndices, headers);
            }
            catch (TikaConfigException e) {
                throw new IOException(e);
            }
            HandlerConfig handlerConfig = this.getHandlerConfig();
            for (CSVRecord record : records) {
                String id = record.get(fetchEmitKeyIndices.idIndex);
                String fetchKey = record.get(fetchEmitKeyIndices.fetchKeyIndex);
                String emitKey = record.get(fetchEmitKeyIndices.emitKeyIndex);
                if (StringUtils.isBlank((String)fetchKey) && !StringUtils.isBlank((String)fetcherName)) {
                    LOGGER.debug("Fetcher specified ({}), but no fetchkey was found in ({})", (Object)fetcherName, (Object)record);
                }
                if (StringUtils.isBlank((String)emitKey)) {
                    throw new IOException("emitKey must not be blank in :" + String.valueOf(record));
                }
                Metadata metadata = this.loadMetadata(fetchEmitKeyIndices, headers, record);
                ParseContext parseContext = new ParseContext();
                parseContext.set(HandlerConfig.class, (Object)handlerConfig);
                this.tryToAdd(new FetchEmitTuple(id, new FetchKey(fetcherName, fetchKey), new EmitKey(emitterName, emitKey), metadata, parseContext, this.getOnParseException()));
            }
        }
    }

    private void checkFetchEmitValidity(String fetcherName, String emitterName, FetchEmitKeyIndices fetchEmitKeyIndices, List<String> headers) throws TikaConfigException {
        if (StringUtils.isBlank((String)emitterName)) {
            throw new TikaConfigException("must specify at least an emitterName");
        }
        if (StringUtils.isBlank((String)fetcherName) && !StringUtils.isBlank((String)this.fetchKeyColumn)) {
            throw new TikaConfigException("If specifying a 'fetchKeyColumn', you must also specify a 'fetcherName'");
        }
        if (StringUtils.isBlank((String)fetcherName)) {
            LOGGER.info("No fetcher specified. This will be metadata only");
        }
        if (StringUtils.isBlank((String)this.fetchKeyColumn)) {
            throw new TikaConfigException("must specify fetchKeyColumn");
        }
        if (!StringUtils.isBlank((String)this.fetchKeyColumn) && fetchEmitKeyIndices.fetchKeyIndex < 0) {
            throw new TikaConfigException("Couldn't find fetchKeyColumn (" + this.fetchKeyColumn + " in header.\nThese are the headers I see: " + String.valueOf(headers));
        }
        if (!StringUtils.isBlank((String)this.emitKeyColumn) && fetchEmitKeyIndices.emitKeyIndex < 0) {
            throw new TikaConfigException("Couldn't find emitKeyColumn (" + this.emitKeyColumn + " in header.\nThese are the headers I see: " + String.valueOf(headers));
        }
        if (!StringUtils.isBlank((String)this.idColumn) && fetchEmitKeyIndices.idIndex < 0) {
            throw new TikaConfigException("Couldn't find idColumn (" + this.idColumn + " in header.\nThese are the headers I see: " + String.valueOf(headers));
        }
        if (StringUtils.isBlank((String)this.emitKeyColumn)) {
            LOGGER.warn("No emitKeyColumn specified. Will use fetchKeyColumn ({}) for both the fetch key and emit key", (Object)this.fetchKeyColumn);
        }
    }

    private Metadata loadMetadata(FetchEmitKeyIndices fetchEmitKeyIndices, List<String> headers, CSVRecord record) {
        Metadata metadata = new Metadata();
        for (int i = 0; i < record.size(); ++i) {
            if (fetchEmitKeyIndices.shouldSkip(i)) continue;
            metadata.set(headers.get(i), record.get(i));
        }
        return metadata;
    }

    private FetchEmitKeyIndices loadHeaders(CSVRecord record, List<String> headers) throws IOException {
        int fetchKeyColumnIndex = -1;
        int emitKeyColumnIndex = -1;
        int idIndex = -1;
        for (int col = 0; col < record.size(); ++col) {
            String header = record.get(col);
            if (StringUtils.isBlank((String)header)) {
                throw new IOException((Throwable)new TikaException("Header in column (" + col + ") must not be empty"));
            }
            headers.add(header);
            if (header.equals(this.fetchKeyColumn)) {
                fetchKeyColumnIndex = col;
                continue;
            }
            if (header.equals(this.emitKeyColumn)) {
                emitKeyColumnIndex = col;
                continue;
            }
            if (!header.equals(this.idColumn)) continue;
            idIndex = col;
        }
        if (StringUtils.isBlank((String)this.idColumn)) {
            LOGGER.info("no idColumn specified, will use fetchKeyColumn");
            idIndex = fetchKeyColumnIndex;
        }
        if (StringUtils.isBlank((String)this.emitKeyColumn)) {
            LOGGER.info("no emitKeyColumn specified, will use fetchKeyColumn");
            emitKeyColumnIndex = fetchKeyColumnIndex;
        }
        return new FetchEmitKeyIndices(idIndex, fetchKeyColumnIndex, emitKeyColumnIndex);
    }

    public void checkInitialization(InitializableProblemHandler problemHandler) throws TikaConfigException {
        super.checkInitialization(problemHandler);
        TikaConfig.mustNotBeEmpty((String)"csvPath", (Path)this.csvPath);
    }

    private static class FetchEmitKeyIndices {
        private final int fetchKeyIndex;
        private int idIndex;
        private int emitKeyIndex;

        public FetchEmitKeyIndices(int idIndex, int fetchKeyIndex, int emitKeyIndex) {
            this.idIndex = idIndex;
            this.fetchKeyIndex = fetchKeyIndex;
            this.emitKeyIndex = emitKeyIndex;
        }

        public boolean shouldSkip(int index) {
            return this.idIndex == index || this.fetchKeyIndex == index || this.emitKeyIndex == index;
        }
    }
}

