/*
 * Decompiled with CFR 0.152.
 */
package reactor.netty.http.server.logging;

import io.netty.incubator.codec.http3.Http3HeadersFrame;
import java.net.SocketAddress;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import org.jspecify.annotations.Nullable;
import reactor.netty.http.server.logging.AbstractAccessLogArgProvider;

final class AccessLogArgProviderH3
extends AbstractAccessLogArgProvider<AccessLogArgProviderH3> {
    static final String H3_PROTOCOL_NAME = "HTTP/3.0";
    @Nullable Http3HeadersFrame requestHeaders;
    @Nullable Http3HeadersFrame responseHeaders;

    AccessLogArgProviderH3(@Nullable SocketAddress remoteAddress) {
        super(remoteAddress);
    }

    AccessLogArgProviderH3 requestHeaders(Http3HeadersFrame requestHeaders) {
        this.requestHeaders = Objects.requireNonNull(requestHeaders, "requestHeaders");
        this.onRequest();
        return this.get();
    }

    AccessLogArgProviderH3 responseHeaders(Http3HeadersFrame responseHeaders) {
        this.responseHeaders = Objects.requireNonNull(responseHeaders, "responseHeaders");
        return this.get();
    }

    @Override
    public @Nullable CharSequence status() {
        return this.responseHeaders == null ? null : this.responseHeaders.headers().status();
    }

    @Override
    public @Nullable CharSequence requestHeader(CharSequence name) {
        Objects.requireNonNull(name, "name");
        return this.requestHeaders == null ? null : (CharSequence)this.requestHeaders.headers().get((Object)name);
    }

    @Override
    public @Nullable CharSequence responseHeader(CharSequence name) {
        Objects.requireNonNull(name, "name");
        return this.responseHeaders == null ? null : (CharSequence)this.responseHeaders.headers().get((Object)name);
    }

    @Override
    public @Nullable Iterator<Map.Entry<CharSequence, CharSequence>> requestHeaderIterator() {
        return this.requestHeaders == null ? null : this.requestHeaders.headers().iterator();
    }

    @Override
    public @Nullable Iterator<Map.Entry<CharSequence, CharSequence>> responseHeaderIterator() {
        return this.responseHeaders == null ? null : this.responseHeaders.headers().iterator();
    }

    @Override
    void onRequest() {
        super.onRequest();
        if (this.requestHeaders != null) {
            this.method = this.requestHeaders.headers().method();
            this.uri = this.requestHeaders.headers().path();
            this.protocol = H3_PROTOCOL_NAME;
        }
    }

    @Override
    void clear() {
        super.clear();
        this.requestHeaders = null;
        this.responseHeaders = null;
    }

    @Override
    public AccessLogArgProviderH3 get() {
        return this;
    }
}

