/*
 * Decompiled with CFR 0.152.
 */
package reactor.netty.http.server;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.incubator.codec.http3.Http3;
import io.netty.incubator.codec.quic.QuicServerCodecBuilder;
import io.netty.incubator.codec.quic.QuicSslContext;
import io.netty.util.AttributeKey;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.jspecify.annotations.Nullable;
import reactor.netty.http.Http3SettingsSpec;
import reactor.netty.http.server.HttpServerConfig;

final class Http3ChannelInitializer
extends ChannelInitializer<Channel> {
    final Map<AttributeKey<?>, ?> attributes;
    final Map<AttributeKey<?>, ?> childAttributes;
    final Map<ChannelOption<?>, ?> childOptions;
    final @Nullable Http3SettingsSpec http3Settings;
    final @Nullable ChannelHandler loggingHandler;
    final Map<ChannelOption<?>, ?> options;
    final ChannelInitializer<Channel> quicChannelInitializer;
    final QuicSslContext quicSslContext;

    Http3ChannelInitializer(HttpServerConfig config, ChannelInitializer<Channel> quicChannelInitializer) {
        this.attributes = config.attributes();
        this.childAttributes = config.childAttributes();
        this.childOptions = config.childOptions();
        this.http3Settings = config.http3SettingsSpec();
        this.loggingHandler = config.loggingHandler();
        this.options = config.options();
        this.quicChannelInitializer = quicChannelInitializer;
        if (config.sslProvider == null || !(config.sslProvider.getSslContext() instanceof QuicSslContext)) {
            throw new IllegalArgumentException("The configured SslContext is not QuicSslContext");
        }
        this.quicSslContext = (QuicSslContext)config.sslProvider.getSslContext();
    }

    @Override
    protected void initChannel(Channel channel) {
        QuicServerCodecBuilder quicServerCodecBuilder = ((QuicServerCodecBuilder)Http3.newQuicServerCodecBuilder().sslContext(this.quicSslContext)).handler(this.quicChannelInitializer);
        if (this.http3Settings != null) {
            ((QuicServerCodecBuilder)((QuicServerCodecBuilder)((QuicServerCodecBuilder)((QuicServerCodecBuilder)quicServerCodecBuilder.initialMaxData(this.http3Settings.maxData())).initialMaxStreamDataBidirectionalLocal(this.http3Settings.maxStreamDataBidirectionalLocal())).initialMaxStreamDataBidirectionalRemote(this.http3Settings.maxStreamDataBidirectionalRemote())).initialMaxStreamsBidirectional(this.http3Settings.maxStreamsBidirectional())).tokenHandler(this.http3Settings.tokenHandler());
            if (this.http3Settings.idleTimeout() != null) {
                quicServerCodecBuilder.maxIdleTimeout(this.http3Settings.idleTimeout().toMillis(), TimeUnit.MILLISECONDS);
            }
        }
        Http3ChannelInitializer.attributes(quicServerCodecBuilder, this.attributes);
        Http3ChannelInitializer.channelOptions(quicServerCodecBuilder, this.options);
        Http3ChannelInitializer.streamAttributes(quicServerCodecBuilder, this.childAttributes);
        Http3ChannelInitializer.streamChannelOptions(quicServerCodecBuilder, this.childOptions);
        if (this.loggingHandler != null) {
            channel.pipeline().addLast("reactor.left.loggingHandler", this.loggingHandler);
            quicServerCodecBuilder.streamHandler(this.loggingHandler);
        }
        channel.pipeline().addLast(quicServerCodecBuilder.build());
        channel.pipeline().remove(this);
    }

    static void attributes(QuicServerCodecBuilder quicServerCodecBuilder, Map<AttributeKey<?>, ?> attrs) {
        for (Map.Entry<AttributeKey<?>, ?> e : attrs.entrySet()) {
            quicServerCodecBuilder.attr(e.getKey(), e.getValue());
        }
    }

    static void channelOptions(QuicServerCodecBuilder quicServerCodecBuilder, Map<ChannelOption<?>, ?> options) {
        for (Map.Entry<ChannelOption<?>, ?> e : options.entrySet()) {
            if (e.getKey() == ChannelOption.SO_REUSEADDR) continue;
            quicServerCodecBuilder.option(e.getKey(), e.getValue());
        }
    }

    static void streamAttributes(QuicServerCodecBuilder quicServerCodecBuilder, Map<AttributeKey<?>, ?> attrs) {
        for (Map.Entry<AttributeKey<?>, ?> e : attrs.entrySet()) {
            quicServerCodecBuilder.streamAttr(e.getKey(), e.getValue());
        }
    }

    static void streamChannelOptions(QuicServerCodecBuilder quicServerCodecBuilder, Map<ChannelOption<?>, ?> options) {
        for (Map.Entry<ChannelOption<?>, ?> e : options.entrySet()) {
            if (e.getKey() == ChannelOption.TCP_NODELAY) continue;
            quicServerCodecBuilder.streamOption(e.getKey(), e.getValue());
        }
    }
}

