/*
 * Decompiled with CFR 0.152.
 */
package reactor.netty.http.client;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http2.Http2FrameCodec;
import io.netty.handler.codec.http2.Http2StreamChannel;
import io.netty.handler.codec.http2.Http2StreamChannelBootstrap;
import io.netty.resolver.AddressResolverGroup;
import io.netty.util.AttributeKey;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.IOException;
import java.net.SocketAddress;
import java.time.Duration;
import java.util.Queue;
import java.util.function.BiPredicate;
import java.util.function.Function;
import org.jspecify.annotations.Nullable;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscription;
import reactor.core.CoreSubscriber;
import reactor.core.Disposable;
import reactor.core.Disposables;
import reactor.core.publisher.Mono;
import reactor.core.publisher.MonoSink;
import reactor.core.publisher.Operators;
import reactor.netty.Connection;
import reactor.netty.ConnectionObserver;
import reactor.netty.ReactorNetty;
import reactor.netty.channel.ChannelMetricsRecorder;
import reactor.netty.channel.ChannelOperations;
import reactor.netty.http.client.Http2Pool;
import reactor.netty.http.client.HttpClientConfig;
import reactor.netty.http.client.HttpClientState;
import reactor.netty.http.client.HttpDelegatingConnectionPoolMetrics;
import reactor.netty.http.client.MicrometerHttp2ConnectionProviderMeterRegistrar;
import reactor.netty.http.client.MicrometerPoolMetricsRecorder;
import reactor.netty.internal.shaded.reactor.pool.InstrumentedPool;
import reactor.netty.internal.shaded.reactor.pool.PoolConfig;
import reactor.netty.internal.shaded.reactor.pool.PooledRef;
import reactor.netty.internal.shaded.reactor.pool.PooledRefMetadata;
import reactor.netty.resources.ConnectionPoolMetrics;
import reactor.netty.resources.ConnectionProvider;
import reactor.netty.resources.PooledConnectionProvider;
import reactor.netty.transport.ClientTransportConfig;
import reactor.netty.transport.TransportConfig;
import reactor.util.Logger;
import reactor.util.Loggers;
import reactor.util.concurrent.Queues;
import reactor.util.context.Context;

final class Http2ConnectionProvider
extends PooledConnectionProvider<Connection> {
    final ConnectionProvider parent;
    static final String CONNECTION_PROVIDER_NAME = "http2";
    static final String NAME_SEPARATOR = ".";
    static final Logger log = Loggers.getLogger(Http2ConnectionProvider.class);
    static final AttributeKey<@Nullable ConnectionObserver> OWNER = AttributeKey.valueOf("http2ConnectionOwner");

    Http2ConnectionProvider(ConnectionProvider parent) {
        super(Http2ConnectionProvider.initConfiguration(parent));
        this.parent = parent;
        if (parent instanceof PooledConnectionProvider) {
            ((PooledConnectionProvider)parent).onDispose(this.disposeLater());
        }
    }

    static ConnectionProvider.Builder initConfiguration(ConnectionProvider parent) {
        String name = parent.name() == null ? CONNECTION_PROVIDER_NAME : "http2." + parent.name();
        ConnectionProvider.Builder builder = parent.mutate();
        if (builder != null) {
            return (ConnectionProvider.Builder)builder.name(name).pendingAcquireMaxCount(-1);
        }
        return (ConnectionProvider.Builder)((ConnectionProvider.Builder)ConnectionProvider.builder(name).maxConnections(parent.maxConnections())).pendingAcquireMaxCount(-1);
    }

    @Override
    protected CoreSubscriber<PooledRef<Connection>> createDisposableAcquire(TransportConfig config, ConnectionObserver connectionObserver, long pendingAcquireTimeout, InstrumentedPool<Connection> pool, MonoSink<Connection> sink, Context currentContext) {
        return this.createDisposableAcquire(config, connectionObserver, pendingAcquireTimeout, pool, (SocketAddress)null, sink, currentContext);
    }

    @Override
    protected CoreSubscriber<PooledRef<Connection>> createDisposableAcquire(TransportConfig config, ConnectionObserver connectionObserver, long pendingAcquireTimeout, InstrumentedPool<Connection> pool, SocketAddress remoteAddress, MonoSink<Connection> sink, Context currentContext) {
        boolean acceptGzip = false;
        ChannelMetricsRecorder metricsRecorder = config.metricsRecorder() != null ? config.metricsRecorder().get() : null;
        SocketAddress proxyAddress = ((ClientTransportConfig)config).proxyProvider() != null ? ((ClientTransportConfig)config).proxyProvider().getProxyAddress() : null;
        Function<String, String> uriTagValue = null;
        if (config instanceof HttpClientConfig) {
            acceptGzip = ((HttpClientConfig)config).acceptGzip;
            uriTagValue = ((HttpClientConfig)config).uriTagValue;
        }
        return new DisposableAcquire(connectionObserver, config.channelOperationsProvider(), acceptGzip, metricsRecorder, pendingAcquireTimeout, pool, proxyAddress, remoteAddress, sink, currentContext, uriTagValue);
    }

    @Override
    protected InstrumentedPool<Connection> createPool(TransportConfig config, PooledConnectionProvider.PoolFactory<Connection> poolFactory, SocketAddress remoteAddress, @Nullable AddressResolverGroup<?> resolverGroup) {
        return new PooledConnectionAllocator((ConnectionProvider)this.parent, (TransportConfig)config, poolFactory, (SocketAddress)remoteAddress, resolverGroup).pool;
    }

    @Override
    protected InstrumentedPool<Connection> createPool(String id, TransportConfig config, PooledConnectionProvider.PoolFactory<Connection> poolFactory, SocketAddress remoteAddress, @Nullable AddressResolverGroup<?> resolverGroup) {
        return new PooledConnectionAllocator((String)id, (String)this.name(), (ConnectionProvider)this.parent, (TransportConfig)config, poolFactory, (SocketAddress)remoteAddress, resolverGroup).pool;
    }

    @Override
    protected ConnectionPoolMetrics delegateConnectionPoolMetrics(InstrumentedPool.PoolMetrics metrics) {
        return new HttpDelegatingConnectionPoolMetrics((Http2Pool)metrics);
    }

    @Override
    protected void registerDefaultMetrics(String id, SocketAddress remoteAddress, InstrumentedPool.PoolMetrics metrics) {
        MicrometerHttp2ConnectionProviderMeterRegistrar.registerMetrics(this.name(), id, remoteAddress, metrics);
    }

    @Override
    protected void deRegisterDefaultMetrics(String id, SocketAddress remoteAddress) {
        MicrometerHttp2ConnectionProviderMeterRegistrar.deRegisterMetrics(this.name(), id, remoteAddress);
    }

    static Http2Pool.Http2PooledRef http2PooledRef(PooledRef<Connection> pooledRef) {
        return pooledRef instanceof Http2Pool.Http2PooledRef ? (Http2Pool.Http2PooledRef)pooledRef : (Http2Pool.Http2PooledRef)pooledRef.metadata();
    }

    static void invalidate(@Nullable ConnectionObserver owner) {
        if (owner instanceof DisposableAcquire) {
            DisposableAcquire da = (DisposableAcquire)owner;
            da.pooledRef.invalidate().subscribe();
        }
    }

    static void logStreamsState(Channel channel, Http2Pool.Slot slot, String msg) {
        log.debug(ReactorNetty.format(channel, "{}, now: this connection [{} active streams and {} max active streams], all connections [{} active streams and {} max active streams]."), msg, slot.concurrency, slot.maxConcurrentStreams, slot.pool.activeStreams(), slot.pool.totalMaxConcurrentStreams);
    }

    static void registerClose(Channel channel, ConnectionObserver owner) {
        channel.closeFuture().addListener(f -> {
            if (owner instanceof DisposableAcquire) {
                DisposableAcquire da = (DisposableAcquire)owner;
                da.pooledRef.invalidate().subscribe(null, null, () -> {
                    if (log.isDebugEnabled()) {
                        Http2Pool.Http2PooledRef http2PooledRef = Http2ConnectionProvider.http2PooledRef(da.pooledRef);
                        Http2ConnectionProvider.logStreamsState(channel, http2PooledRef.slot, "Stream closed");
                    }
                });
            }
        });
    }

    static final class PooledConnectionAllocator {
        final ConnectionProvider parent;
        final HttpClientConfig config;
        final InstrumentedPool<Connection> pool;
        final SocketAddress remoteAddress;
        final @Nullable AddressResolverGroup<?> resolver;
        static final BiPredicate<Connection, PooledRefMetadata> DEFAULT_EVICTION_PREDICATE = (connection, metadata) -> false;
        static final Function<Connection, Publisher<Void>> DEFAULT_DESTROY_HANDLER = connection -> Mono.empty();

        PooledConnectionAllocator(ConnectionProvider parent, TransportConfig config, PooledConnectionProvider.PoolFactory<Connection> poolFactory, SocketAddress remoteAddress, @Nullable AddressResolverGroup<?> resolver) {
            this(null, null, parent, config, poolFactory, remoteAddress, resolver);
        }

        PooledConnectionAllocator(@Nullable String id, @Nullable String name, ConnectionProvider parent, TransportConfig config, PooledConnectionProvider.PoolFactory<Connection> poolFactory, SocketAddress remoteAddress, @Nullable AddressResolverGroup<?> resolver) {
            this.parent = parent;
            this.config = (HttpClientConfig)config;
            this.remoteAddress = remoteAddress;
            this.resolver = resolver;
            this.pool = id == null ? poolFactory.newPool(this.connectChannel(), null, DEFAULT_DESTROY_HANDLER, DEFAULT_EVICTION_PREDICATE, poolConfig -> new Http2Pool((PoolConfig<Connection>)poolConfig, poolFactory.allocationStrategy())) : poolFactory.newPool(this.connectChannel(), DEFAULT_DESTROY_HANDLER, DEFAULT_EVICTION_PREDICATE, new MicrometerPoolMetricsRecorder(id, name, remoteAddress), poolConfig -> new Http2Pool((PoolConfig<Connection>)poolConfig, poolFactory.allocationStrategy()));
        }

        Publisher<Connection> connectChannel() {
            return this.parent.acquire(this.config, new DelegatingConnectionObserver(), () -> this.remoteAddress, this.resolver).map(conn -> conn);
        }
    }

    static final class PendingConnectionObserver
    implements ConnectionObserver {
        final Queue<Pending> pendingQueue = Queues.unbounded(4).get();

        PendingConnectionObserver() {
        }

        @Override
        public void onStateChange(Connection connection, ConnectionObserver.State newState) {
            this.pendingQueue.add(new Pending(connection, null, newState));
        }

        @Override
        public void onUncaughtException(Connection connection, Throwable error) {
            this.pendingQueue.add(new Pending(connection, error, null));
        }

        static class Pending {
            final Connection connection;
            final @Nullable Throwable error;
            final @Nullable ConnectionObserver.State state;

            Pending(Connection connection, @Nullable Throwable error, @Nullable ConnectionObserver.State state) {
                this.connection = connection;
                this.error = error;
                this.state = state;
            }
        }
    }

    static final class DisposableAcquire
    implements CoreSubscriber<PooledRef<Connection>>,
    ConnectionObserver,
    Disposable,
    GenericFutureListener<Future<Http2StreamChannel>> {
        final Disposable.Composite cancellations;
        final Context currentContext;
        final ConnectionObserver obs;
        final ChannelOperations.OnSetup opsFactory;
        final boolean acceptGzip;
        final @Nullable ChannelMetricsRecorder metricsRecorder;
        final long pendingAcquireTimeout;
        final InstrumentedPool<Connection> pool;
        final @Nullable SocketAddress proxyAddress;
        final boolean retried;
        final MonoSink<Connection> sink;
        final @Nullable Function<String, String> uriTagValue;
        PooledRef<Connection> pooledRef;
        @Nullable SocketAddress remoteAddress;
        Subscription subscription;
        static final AttributeKey<@Nullable Http2StreamChannelBootstrap> HTTP2_STREAM_CHANNEL_BOOTSTRAP = AttributeKey.valueOf("http2StreamChannelBootstrap");

        DisposableAcquire(ConnectionObserver obs, ChannelOperations.OnSetup opsFactory, boolean acceptGzip, @Nullable ChannelMetricsRecorder metricsRecorder, long pendingAcquireTimeout, InstrumentedPool<Connection> pool, @Nullable SocketAddress proxyAddress, @Nullable SocketAddress remoteAddress, MonoSink<Connection> sink, Context currentContext, @Nullable Function<String, String> uriTagValue) {
            this.cancellations = Disposables.composite();
            this.currentContext = currentContext;
            this.obs = obs;
            this.opsFactory = opsFactory;
            this.acceptGzip = acceptGzip;
            this.metricsRecorder = metricsRecorder;
            this.pendingAcquireTimeout = pendingAcquireTimeout;
            this.pool = pool;
            this.proxyAddress = proxyAddress;
            this.remoteAddress = remoteAddress;
            this.retried = false;
            this.sink = sink;
            this.uriTagValue = uriTagValue;
        }

        DisposableAcquire(DisposableAcquire parent) {
            this.cancellations = parent.cancellations;
            this.currentContext = parent.currentContext;
            this.obs = parent.obs;
            this.opsFactory = parent.opsFactory;
            this.acceptGzip = parent.acceptGzip;
            this.metricsRecorder = parent.metricsRecorder;
            this.pendingAcquireTimeout = parent.pendingAcquireTimeout;
            this.pool = parent.pool;
            this.proxyAddress = parent.proxyAddress;
            this.remoteAddress = parent.remoteAddress;
            this.retried = true;
            this.sink = parent.sink;
            this.uriTagValue = parent.uriTagValue;
        }

        @Override
        public Context currentContext() {
            return this.currentContext;
        }

        @Override
        public void dispose() {
            this.subscription.cancel();
        }

        @Override
        public void onComplete() {
        }

        @Override
        public void onError(Throwable t) {
            this.sink.error(t);
        }

        @Override
        public void onNext(PooledRef<Connection> pooledRef) {
            ConnectionObserver current;
            this.pooledRef = pooledRef;
            Channel channel = pooledRef.poolable().channel();
            if (this.remoteAddress == null) {
                this.remoteAddress = channel.remoteAddress();
            }
            if ((current = channel.attr(OWNER).getAndSet(this)) instanceof PendingConnectionObserver) {
                PendingConnectionObserver.Pending p;
                PendingConnectionObserver pending = (PendingConnectionObserver)current;
                while ((p = pending.pendingQueue.poll()) != null) {
                    if (p.error != null) {
                        this.onUncaughtException(p.connection, p.error);
                        continue;
                    }
                    if (p.state == null) continue;
                    this.onStateChange(p.connection, p.state);
                }
            }
            if (this.notHttp2()) {
                return;
            }
            if (this.isH2cUpgrade()) {
                return;
            }
            if (ReactorNetty.getChannelContext(channel) != null) {
                ReactorNetty.setChannelContext(channel, null);
            }
            DisposableAcquire.http2StreamChannelBootstrap(channel).open().addListener(this);
        }

        @Override
        public void onStateChange(Connection connection, ConnectionObserver.State newState) {
            if (newState == HttpClientState.UPGRADE_REJECTED) {
                Http2ConnectionProvider.invalidate(connection.channel().attr(OWNER).get());
            }
            this.obs.onStateChange(connection, newState);
        }

        @Override
        public void onSubscribe(Subscription s) {
            if (Operators.validate(this.subscription, s)) {
                this.subscription = s;
                this.cancellations.add(this);
                if (!this.retried) {
                    this.sink.onCancel(this.cancellations);
                }
                s.request(Long.MAX_VALUE);
            }
        }

        @Override
        public void onUncaughtException(Connection connection, Throwable error) {
            ConnectionObserver owner = connection.channel().attr(OWNER).get();
            if (owner instanceof DisposableAcquire) {
                Http2Pool.Http2PooledRef http2PooledRef = Http2ConnectionProvider.http2PooledRef(((DisposableAcquire)owner).pooledRef);
                if (http2PooledRef.slot.h2cUpgradeHandlerCtx() != null && http2PooledRef.slot.http2MultiplexHandlerCtx() == null) {
                    Http2ConnectionProvider.invalidate(owner);
                }
            }
            this.obs.onUncaughtException(connection, error);
        }

        @Override
        public void operationComplete(Future<Http2StreamChannel> future) {
            if (future.isSuccess()) {
                Channel channel = this.pooledRef.poolable().channel();
                Http2Pool.Http2PooledRef http2PooledRef = Http2ConnectionProvider.http2PooledRef(this.pooledRef);
                ChannelHandlerContext frameCodec = http2PooledRef.slot.http2FrameCodecCtx();
                Http2StreamChannel ch = future.getNow();
                if (!channel.isActive() || frameCodec == null || ((Http2FrameCodec)frameCodec.handler()).connection().goAwayReceived() || !((Http2FrameCodec)frameCodec.handler()).connection().local().canOpenStream()) {
                    Http2ConnectionProvider.invalidate(this);
                    if (!this.retried) {
                        if (log.isDebugEnabled()) {
                            log.debug(ReactorNetty.format(ch, "Immediately aborted pooled channel, max active streams is reached, re-acquiring a new channel"));
                        }
                        this.pool.acquire(Duration.ofMillis(this.pendingAcquireTimeout)).contextWrite(ctx -> ctx.put("callereventloop", channel.eventLoop())).subscribe(new DisposableAcquire(this));
                    } else {
                        this.sink.error(new IOException("Error while acquiring from " + this.pool + ". Max active streams is reached."));
                    }
                } else {
                    ChannelOperations<?, ?> ops;
                    Http2ConnectionProvider.registerClose(ch, this);
                    if (!this.currentContext().isEmpty()) {
                        ReactorNetty.setChannelContext(ch, this.currentContext());
                    }
                    HttpClientConfig.addStreamHandlers(ch, this.obs.then(new HttpClientConfig.StreamConnectionObserver(this.currentContext())), this.opsFactory, this.acceptGzip, false, this.metricsRecorder, this.proxyAddress, this.remoteAddress, -1L, this.uriTagValue);
                    if (log.isDebugEnabled()) {
                        Http2ConnectionProvider.logStreamsState(ch, http2PooledRef.slot, "Stream opened");
                    }
                    if ((ops = ChannelOperations.get(ch)) != null) {
                        this.obs.onStateChange(ops, HttpClientState.STREAM_CONFIGURED);
                        this.sink.success(ops);
                    }
                }
            } else {
                Http2ConnectionProvider.invalidate(this);
                this.sink.error(future.cause());
            }
        }

        boolean isH2cUpgrade() {
            ChannelOperations<?, ?> ops;
            Channel channel = this.pooledRef.poolable().channel();
            Http2Pool.Http2PooledRef http2PooledRef = Http2ConnectionProvider.http2PooledRef(this.pooledRef);
            if (http2PooledRef.slot.h2cUpgradeHandlerCtx() != null && http2PooledRef.slot.http2MultiplexHandlerCtx() == null && (ops = ChannelOperations.get(channel)) != null) {
                this.sink.success(ops);
                return true;
            }
            return false;
        }

        boolean notHttp2() {
            ChannelOperations<?, ?> ops;
            Channel channel = this.pooledRef.poolable().channel();
            Http2Pool.Http2PooledRef http2PooledRef = Http2ConnectionProvider.http2PooledRef(this.pooledRef);
            String applicationProtocol = http2PooledRef.slot.applicationProtocol;
            if (applicationProtocol != null) {
                if ("http/1.1".equals(applicationProtocol)) {
                    ChannelOperations<?, ?> ops2 = ChannelOperations.get(channel);
                    if (ops2 != null) {
                        this.sink.success(ops2);
                        Http2ConnectionProvider.invalidate(this);
                        return true;
                    }
                } else if (!"h2".equals(applicationProtocol)) {
                    channel.attr(OWNER).set(null);
                    Http2ConnectionProvider.invalidate(this);
                    this.sink.error(new IOException("Unknown protocol [" + applicationProtocol + "]."));
                    return true;
                }
            } else if (http2PooledRef.slot.h2cUpgradeHandlerCtx() == null && http2PooledRef.slot.http2MultiplexHandlerCtx() == null && (ops = ChannelOperations.get(channel)) != null) {
                this.sink.success(ops);
                Http2ConnectionProvider.invalidate(this);
                return true;
            }
            return false;
        }

        static Http2StreamChannelBootstrap http2StreamChannelBootstrap(Channel channel) {
            Http2StreamChannelBootstrap http2StreamChannelBootstrap;
            do {
                if ((http2StreamChannelBootstrap = channel.attr(HTTP2_STREAM_CHANNEL_BOOTSTRAP).get()) != null) {
                    return http2StreamChannelBootstrap;
                }
                http2StreamChannelBootstrap = new Http2StreamChannelBootstrap(channel);
            } while (!channel.attr(HTTP2_STREAM_CHANNEL_BOOTSTRAP).compareAndSet(null, http2StreamChannelBootstrap));
            return http2StreamChannelBootstrap;
        }
    }

    static final class DelegatingConnectionObserver
    implements ConnectionObserver {
        DelegatingConnectionObserver() {
        }

        @Override
        public void onUncaughtException(Connection connection, Throwable error) {
            DelegatingConnectionObserver.owner(connection.channel()).onUncaughtException(connection, error);
        }

        @Override
        public void onStateChange(Connection connection, ConnectionObserver.State newState) {
            DelegatingConnectionObserver.owner(connection.channel()).onStateChange(connection, newState);
        }

        static ConnectionObserver owner(Channel channel) {
            ConnectionObserver obs;
            do {
                if ((obs = channel.attr(OWNER).get()) != null) {
                    return obs;
                }
                obs = new PendingConnectionObserver();
            } while (!channel.attr(OWNER).compareAndSet(null, obs));
            return obs;
        }
    }
}

