/*
 * Decompiled with CFR 0.152.
 */
package reactor.netty;

import io.netty.channel.Channel;
import io.netty.channel.socket.DatagramChannel;
import io.netty.channel.unix.DomainDatagramChannel;
import java.net.SocketAddress;
import java.time.Duration;
import java.util.Objects;
import reactor.core.CoreSubscriber;
import reactor.core.Disposable;
import reactor.core.publisher.Mono;
import reactor.netty.FutureMono;
import reactor.netty.ReactorNetty;

@FunctionalInterface
public interface DisposableChannel
extends Disposable {
    default public SocketAddress address() {
        Channel c = this.channel();
        if (c instanceof DatagramChannel || c instanceof DomainDatagramChannel) {
            SocketAddress a = c.remoteAddress();
            return a != null ? a : c.localAddress();
        }
        return c.remoteAddress();
    }

    public Channel channel();

    @Override
    default public void dispose() {
        this.channel().close();
    }

    default public void disposeNow() {
        this.disposeNow(Duration.ofSeconds(3L));
    }

    default public void disposeNow(Duration timeout) {
        if (this.isDisposed()) {
            return;
        }
        Objects.requireNonNull(timeout, "timeout");
        this.dispose();
        try {
            this.onDispose().block(timeout);
        }
        catch (IllegalStateException e) {
            String message = e.getMessage();
            if (message != null && message.contains("blocking read")) {
                throw new IllegalStateException("Socket couldn't be stopped within " + timeout.toMillis() + "ms");
            }
            throw e;
        }
    }

    default public CoreSubscriber<Void> disposeSubscriber() {
        return new ReactorNetty.ChannelDisposer(this);
    }

    @Override
    default public boolean isDisposed() {
        return !this.channel().isActive();
    }

    default public Mono<Void> onDispose() {
        return FutureMono.from(this.channel().closeFuture());
    }

    default public DisposableChannel onDispose(Disposable onDispose) {
        Objects.requireNonNull(onDispose, "onDispose");
        this.onDispose().subscribe(null, e -> onDispose.dispose(), onDispose::dispose);
        return this;
    }
}

