/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.pipes.pipesiterator.azblob;

import com.azure.core.http.rest.PagedIterable;
import com.azure.storage.blob.BlobContainerClient;
import com.azure.storage.blob.BlobServiceClient;
import com.azure.storage.blob.BlobServiceClientBuilder;
import com.azure.storage.blob.models.BlobItem;
import com.azure.storage.blob.models.BlobListDetails;
import com.azure.storage.blob.models.ListBlobsOptions;
import java.io.IOException;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.Map;
import java.util.concurrent.TimeoutException;
import org.apache.tika.config.Field;
import org.apache.tika.config.Initializable;
import org.apache.tika.config.InitializableProblemHandler;
import org.apache.tika.config.Param;
import org.apache.tika.config.TikaConfig;
import org.apache.tika.exception.TikaConfigException;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.pipes.FetchEmitTuple;
import org.apache.tika.pipes.HandlerConfig;
import org.apache.tika.pipes.emitter.EmitKey;
import org.apache.tika.pipes.fetcher.FetchKey;
import org.apache.tika.pipes.pipesiterator.PipesIterator;
import org.apache.tika.utils.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AZBlobPipesIterator
extends PipesIterator
implements Initializable {
    private static final Logger LOGGER = LoggerFactory.getLogger(AZBlobPipesIterator.class);
    private BlobServiceClient blobServiceClient;
    private BlobContainerClient blobContainerClient;
    private String prefix = "";
    private String container = "";
    private String sasToken;
    private String endpoint;
    private long timeoutMillis = 360000L;

    @Field
    public void setSasToken(String sasToken) {
        this.sasToken = sasToken;
    }

    @Field
    public void setEndpoint(String endpoint) {
        this.endpoint = endpoint;
    }

    @Field
    public void setContainer(String container) {
        this.container = container;
    }

    @Field
    public void setPrefix(String prefix) {
        this.prefix = prefix.endsWith("/") ? prefix.substring(0, prefix.length() - 1) : prefix;
    }

    protected void enqueue() throws InterruptedException, IOException, TimeoutException {
        Object options;
        String fetcherName = this.getFetcherName();
        String emitterName = this.getEmitterName();
        long start = System.currentTimeMillis();
        int count = 0;
        HandlerConfig handlerConfig = this.getHandlerConfig();
        PagedIterable<BlobItem> blobs = null;
        if (StringUtils.isBlank((String)this.prefix)) {
            options = new ListBlobsOptions().setDetails(new BlobListDetails().setRetrieveDeletedBlobs(false).setRetrieveMetadata(false).setRetrieveSnapshots(false));
            blobs = this.blobContainerClient.listBlobs((ListBlobsOptions)options, Duration.of(this.timeoutMillis, ChronoUnit.MILLIS));
        } else {
            options = new ListBlobsOptions().setPrefix(this.prefix).setDetails(new BlobListDetails().setRetrieveDeletedBlobs(false).setRetrieveMetadata(false).setRetrieveSnapshots(false));
            blobs = this.blobContainerClient.listBlobs((ListBlobsOptions)options, Duration.of(this.timeoutMillis, ChronoUnit.MILLIS));
        }
        for (BlobItem blob : blobs) {
            if (blob == null || blob.getProperties() == null || blob.getProperties().getContentLength() == 0L) continue;
            long elapsed = System.currentTimeMillis() - start;
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("adding ({}) {} in {} ms", count, blob.getName(), elapsed);
            }
            ParseContext parseContext = new ParseContext();
            parseContext.set(HandlerConfig.class, (Object)handlerConfig);
            this.tryToAdd(new FetchEmitTuple(blob.getName(), new FetchKey(fetcherName, blob.getName()), new EmitKey(emitterName, blob.getName()), new Metadata(), parseContext, this.getOnParseException()));
            ++count;
        }
        long elapsed = System.currentTimeMillis() - start;
        LOGGER.info("finished enqueuing {} files in {} ms", (Object)count, (Object)elapsed);
    }

    public void initialize(Map<String, Param> params) throws TikaConfigException {
        this.blobServiceClient = new BlobServiceClientBuilder().endpoint(this.endpoint).sasToken(this.sasToken).buildClient();
        this.blobContainerClient = this.blobServiceClient.getBlobContainerClient(this.container);
    }

    public void checkInitialization(InitializableProblemHandler problemHandler) throws TikaConfigException {
        TikaConfig.mustNotBeEmpty((String)"sasToken", (String)this.sasToken);
        TikaConfig.mustNotBeEmpty((String)"endpoint", (String)this.endpoint);
        TikaConfig.mustNotBeEmpty((String)"container", (String)this.container);
    }
}

